/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.ManagedResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedTargetGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedTargetGroup> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ManagedTargetGroup.getter(ManagedTargetGroup::arn)).setter(ManagedTargetGroup.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ManagedTargetGroup.getter(ManagedTargetGroup::statusAsString)).setter(ManagedTargetGroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(ManagedTargetGroup.getter(ManagedTargetGroup::statusReason)).setter(ManagedTargetGroup.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(ManagedTargetGroup.getter(ManagedTargetGroup::updatedAt)).setter(ManagedTargetGroup.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("healthCheckPath").getter(ManagedTargetGroup.getter(ManagedTargetGroup::healthCheckPath)).setter(ManagedTargetGroup.setter(Builder::healthCheckPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckPath").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("healthCheckPort").getter(ManagedTargetGroup.getter(ManagedTargetGroup::healthCheckPort)).setter(ManagedTargetGroup.setter(Builder::healthCheckPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckPort").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(ManagedTargetGroup.getter(ManagedTargetGroup::port)).setter(ManagedTargetGroup.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, UPDATED_AT_FIELD, HEALTH_CHECK_PATH_FIELD, HEALTH_CHECK_PORT_FIELD, PORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedTargetGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String status;
    private final String statusReason;
    private final Instant updatedAt;
    private final String healthCheckPath;
    private final Integer healthCheckPort;
    private final Integer port;

    private ManagedTargetGroup(BuilderImpl builder) {
        this.arn = builder.arn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.updatedAt = builder.updatedAt;
        this.healthCheckPath = builder.healthCheckPath;
        this.healthCheckPort = builder.healthCheckPort;
        this.port = builder.port;
    }

    public final String arn() {
        return this.arn;
    }

    public final ManagedResourceStatus status() {
        return ManagedResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String healthCheckPath() {
        return this.healthCheckPath;
    }

    public final Integer healthCheckPort() {
        return this.healthCheckPort;
    }

    public final Integer port() {
        return this.port;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedTargetGroup)) {
            return false;
        }
        ManagedTargetGroup other = (ManagedTargetGroup)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.healthCheckPath(), other.healthCheckPath()) && Objects.equals(this.healthCheckPort(), other.healthCheckPort()) && Objects.equals(this.port(), other.port());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedTargetGroup").add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("UpdatedAt", (Object)this.updatedAt()).add("HealthCheckPath", (Object)this.healthCheckPath()).add("HealthCheckPort", (Object)this.healthCheckPort()).add("Port", (Object)this.port()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "healthCheckPath": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPath()));
            }
            case "healthCheckPort": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPort()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("healthCheckPath", HEALTH_CHECK_PATH_FIELD);
        map.put("healthCheckPort", HEALTH_CHECK_PORT_FIELD);
        map.put("port", PORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedTargetGroup, T> g) {
        return obj -> g.apply((ManagedTargetGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String status;
        private String statusReason;
        private Instant updatedAt;
        private String healthCheckPath;
        private Integer healthCheckPort;
        private Integer port;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedTargetGroup model) {
            this.arn(model.arn);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.updatedAt(model.updatedAt);
            this.healthCheckPath(model.healthCheckPath);
            this.healthCheckPort(model.healthCheckPort);
            this.port(model.port);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ManagedResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final Integer getHealthCheckPort() {
            return this.healthCheckPort;
        }

        public final void setHealthCheckPort(Integer healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(Integer healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public ManagedTargetGroup build() {
            return new ManagedTargetGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedTargetGroup> {
        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(ManagedResourceStatus var1);

        public Builder statusReason(String var1);

        public Builder updatedAt(Instant var1);

        public Builder healthCheckPath(String var1);

        public Builder healthCheckPort(Integer var1);

        public Builder port(Integer var1);
    }
}

