/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.ExpressGatewayContainer;
import software.amazon.awssdk.services.ecs.model.ExpressGatewayScalingTarget;
import software.amazon.awssdk.services.ecs.model.ExpressGatewayServiceNetworkConfiguration;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateExpressGatewayServiceRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, CreateExpressGatewayServiceRequest> {
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(CreateExpressGatewayServiceRequest.getter(CreateExpressGatewayServiceRequest::executionRoleArn)).setter(CreateExpressGatewayServiceRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<String> INFRASTRUCTURE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("infrastructureRoleArn").getter(CreateExpressGatewayServiceRequest.getter(CreateExpressGatewayServiceRequest::infrastructureRoleArn)).setter(CreateExpressGatewayServiceRequest.setter(Builder::infrastructureRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureRoleArn").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(CreateExpressGatewayServiceRequest.getter(CreateExpressGatewayServiceRequest::serviceName)).setter(CreateExpressGatewayServiceRequest.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(CreateExpressGatewayServiceRequest.getter(CreateExpressGatewayServiceRequest::cluster)).setter(CreateExpressGatewayServiceRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("healthCheckPath").getter(CreateExpressGatewayServiceRequest.getter(CreateExpressGatewayServiceRequest::healthCheckPath)).setter(CreateExpressGatewayServiceRequest.setter(Builder::healthCheckPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckPath").build()}).build();
    private static final SdkField<ExpressGatewayContainer> PRIMARY_CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("primaryContainer").getter(CreateExpressGatewayServiceRequest.getter(CreateExpressGatewayServiceRequest::primaryContainer)).setter(CreateExpressGatewayServiceRequest.setter(Builder::primaryContainer)).constructor(ExpressGatewayContainer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryContainer").build()}).build();
    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskRoleArn").getter(CreateExpressGatewayServiceRequest.getter(CreateExpressGatewayServiceRequest::taskRoleArn)).setter(CreateExpressGatewayServiceRequest.setter(Builder::taskRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRoleArn").build()}).build();
    private static final SdkField<ExpressGatewayServiceNetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(CreateExpressGatewayServiceRequest.getter(CreateExpressGatewayServiceRequest::networkConfiguration)).setter(CreateExpressGatewayServiceRequest.setter(Builder::networkConfiguration)).constructor(ExpressGatewayServiceNetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<String> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cpu").getter(CreateExpressGatewayServiceRequest.getter(CreateExpressGatewayServiceRequest::cpu)).setter(CreateExpressGatewayServiceRequest.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()}).build();
    private static final SdkField<String> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memory").getter(CreateExpressGatewayServiceRequest.getter(CreateExpressGatewayServiceRequest::memory)).setter(CreateExpressGatewayServiceRequest.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<ExpressGatewayScalingTarget> SCALING_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scalingTarget").getter(CreateExpressGatewayServiceRequest.getter(CreateExpressGatewayServiceRequest::scalingTarget)).setter(CreateExpressGatewayServiceRequest.setter(Builder::scalingTarget)).constructor(ExpressGatewayScalingTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingTarget").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateExpressGatewayServiceRequest.getter(CreateExpressGatewayServiceRequest::tags)).setter(CreateExpressGatewayServiceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ROLE_ARN_FIELD, INFRASTRUCTURE_ROLE_ARN_FIELD, SERVICE_NAME_FIELD, CLUSTER_FIELD, HEALTH_CHECK_PATH_FIELD, PRIMARY_CONTAINER_FIELD, TASK_ROLE_ARN_FIELD, NETWORK_CONFIGURATION_FIELD, CPU_FIELD, MEMORY_FIELD, SCALING_TARGET_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateExpressGatewayServiceRequest.memberNameToFieldInitializer();
    private final String executionRoleArn;
    private final String infrastructureRoleArn;
    private final String serviceName;
    private final String cluster;
    private final String healthCheckPath;
    private final ExpressGatewayContainer primaryContainer;
    private final String taskRoleArn;
    private final ExpressGatewayServiceNetworkConfiguration networkConfiguration;
    private final String cpu;
    private final String memory;
    private final ExpressGatewayScalingTarget scalingTarget;
    private final List<Tag> tags;

    private CreateExpressGatewayServiceRequest(BuilderImpl builder) {
        super(builder);
        this.executionRoleArn = builder.executionRoleArn;
        this.infrastructureRoleArn = builder.infrastructureRoleArn;
        this.serviceName = builder.serviceName;
        this.cluster = builder.cluster;
        this.healthCheckPath = builder.healthCheckPath;
        this.primaryContainer = builder.primaryContainer;
        this.taskRoleArn = builder.taskRoleArn;
        this.networkConfiguration = builder.networkConfiguration;
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.scalingTarget = builder.scalingTarget;
        this.tags = builder.tags;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String infrastructureRoleArn() {
        return this.infrastructureRoleArn;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final String healthCheckPath() {
        return this.healthCheckPath;
    }

    public final ExpressGatewayContainer primaryContainer() {
        return this.primaryContainer;
    }

    public final String taskRoleArn() {
        return this.taskRoleArn;
    }

    public final ExpressGatewayServiceNetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final String cpu() {
        return this.cpu;
    }

    public final String memory() {
        return this.memory;
    }

    public final ExpressGatewayScalingTarget scalingTarget() {
        return this.scalingTarget;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryContainer());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExpressGatewayServiceRequest)) {
            return false;
        }
        CreateExpressGatewayServiceRequest other = (CreateExpressGatewayServiceRequest)((Object)obj);
        return Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.infrastructureRoleArn(), other.infrastructureRoleArn()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.healthCheckPath(), other.healthCheckPath()) && Objects.equals(this.primaryContainer(), other.primaryContainer()) && Objects.equals(this.taskRoleArn(), other.taskRoleArn()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.scalingTarget(), other.scalingTarget()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateExpressGatewayServiceRequest").add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("InfrastructureRoleArn", (Object)this.infrastructureRoleArn()).add("ServiceName", (Object)this.serviceName()).add("Cluster", (Object)this.cluster()).add("HealthCheckPath", (Object)this.healthCheckPath()).add("PrimaryContainer", (Object)this.primaryContainer()).add("TaskRoleArn", (Object)this.taskRoleArn()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("Cpu", (Object)this.cpu()).add("Memory", (Object)this.memory()).add("ScalingTarget", (Object)this.scalingTarget()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "infrastructureRoleArn": {
                return Optional.ofNullable(clazz.cast(this.infrastructureRoleArn()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "healthCheckPath": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPath()));
            }
            case "primaryContainer": {
                return Optional.ofNullable(clazz.cast(this.primaryContainer()));
            }
            case "taskRoleArn": {
                return Optional.ofNullable(clazz.cast(this.taskRoleArn()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "scalingTarget": {
                return Optional.ofNullable(clazz.cast(this.scalingTarget()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("infrastructureRoleArn", INFRASTRUCTURE_ROLE_ARN_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("cluster", CLUSTER_FIELD);
        map.put("healthCheckPath", HEALTH_CHECK_PATH_FIELD);
        map.put("primaryContainer", PRIMARY_CONTAINER_FIELD);
        map.put("taskRoleArn", TASK_ROLE_ARN_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("cpu", CPU_FIELD);
        map.put("memory", MEMORY_FIELD);
        map.put("scalingTarget", SCALING_TARGET_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateExpressGatewayServiceRequest, T> g) {
        return obj -> g.apply((CreateExpressGatewayServiceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String executionRoleArn;
        private String infrastructureRoleArn;
        private String serviceName;
        private String cluster;
        private String healthCheckPath;
        private ExpressGatewayContainer primaryContainer;
        private String taskRoleArn;
        private ExpressGatewayServiceNetworkConfiguration networkConfiguration;
        private String cpu;
        private String memory;
        private ExpressGatewayScalingTarget scalingTarget;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExpressGatewayServiceRequest model) {
            super(model);
            this.executionRoleArn(model.executionRoleArn);
            this.infrastructureRoleArn(model.infrastructureRoleArn);
            this.serviceName(model.serviceName);
            this.cluster(model.cluster);
            this.healthCheckPath(model.healthCheckPath);
            this.primaryContainer(model.primaryContainer);
            this.taskRoleArn(model.taskRoleArn);
            this.networkConfiguration(model.networkConfiguration);
            this.cpu(model.cpu);
            this.memory(model.memory);
            this.scalingTarget(model.scalingTarget);
            this.tags(model.tags);
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getInfrastructureRoleArn() {
            return this.infrastructureRoleArn;
        }

        public final void setInfrastructureRoleArn(String infrastructureRoleArn) {
            this.infrastructureRoleArn = infrastructureRoleArn;
        }

        @Override
        public final Builder infrastructureRoleArn(String infrastructureRoleArn) {
            this.infrastructureRoleArn = infrastructureRoleArn;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getCluster() {
            return this.cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final ExpressGatewayContainer.Builder getPrimaryContainer() {
            return this.primaryContainer != null ? this.primaryContainer.toBuilder() : null;
        }

        public final void setPrimaryContainer(ExpressGatewayContainer.BuilderImpl primaryContainer) {
            this.primaryContainer = primaryContainer != null ? primaryContainer.build() : null;
        }

        @Override
        public final Builder primaryContainer(ExpressGatewayContainer primaryContainer) {
            this.primaryContainer = primaryContainer;
            return this;
        }

        public final String getTaskRoleArn() {
            return this.taskRoleArn;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final ExpressGatewayServiceNetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(ExpressGatewayServiceNetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(ExpressGatewayServiceNetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getCpu() {
            return this.cpu;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final String getMemory() {
            return this.memory;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final ExpressGatewayScalingTarget.Builder getScalingTarget() {
            return this.scalingTarget != null ? this.scalingTarget.toBuilder() : null;
        }

        public final void setScalingTarget(ExpressGatewayScalingTarget.BuilderImpl scalingTarget) {
            this.scalingTarget = scalingTarget != null ? scalingTarget.build() : null;
        }

        @Override
        public final Builder scalingTarget(ExpressGatewayScalingTarget scalingTarget) {
            this.scalingTarget = scalingTarget;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExpressGatewayServiceRequest build() {
            return new CreateExpressGatewayServiceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateExpressGatewayServiceRequest> {
        public Builder executionRoleArn(String var1);

        public Builder infrastructureRoleArn(String var1);

        public Builder serviceName(String var1);

        public Builder cluster(String var1);

        public Builder healthCheckPath(String var1);

        public Builder primaryContainer(ExpressGatewayContainer var1);

        default public Builder primaryContainer(Consumer<ExpressGatewayContainer.Builder> primaryContainer) {
            return this.primaryContainer((ExpressGatewayContainer)((ExpressGatewayContainer.Builder)ExpressGatewayContainer.builder().applyMutation(primaryContainer)).build());
        }

        public Builder taskRoleArn(String var1);

        public Builder networkConfiguration(ExpressGatewayServiceNetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<ExpressGatewayServiceNetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((ExpressGatewayServiceNetworkConfiguration)((ExpressGatewayServiceNetworkConfiguration.Builder)ExpressGatewayServiceNetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder cpu(String var1);

        public Builder memory(String var1);

        public Builder scalingTarget(ExpressGatewayScalingTarget var1);

        default public Builder scalingTarget(Consumer<ExpressGatewayScalingTarget.Builder> scalingTarget) {
            return this.scalingTarget((ExpressGatewayScalingTarget)((ExpressGatewayScalingTarget.Builder)ExpressGatewayScalingTarget.builder().applyMutation(scalingTarget)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

