/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.ManagedDraining;
import software.amazon.awssdk.services.ecs.model.ManagedScaling;
import software.amazon.awssdk.services.ecs.model.ManagedTerminationProtection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingGroupProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingGroupProvider> {
    private static final SdkField<String> AUTO_SCALING_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoScalingGroupArn").getter(AutoScalingGroupProvider.getter(AutoScalingGroupProvider::autoScalingGroupArn)).setter(AutoScalingGroupProvider.setter(Builder::autoScalingGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupArn").build()}).build();
    private static final SdkField<ManagedScaling> MANAGED_SCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("managedScaling").getter(AutoScalingGroupProvider.getter(AutoScalingGroupProvider::managedScaling)).setter(AutoScalingGroupProvider.setter(Builder::managedScaling)).constructor(ManagedScaling::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedScaling").build()}).build();
    private static final SdkField<String> MANAGED_TERMINATION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedTerminationProtection").getter(AutoScalingGroupProvider.getter(AutoScalingGroupProvider::managedTerminationProtectionAsString)).setter(AutoScalingGroupProvider.setter(Builder::managedTerminationProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedTerminationProtection").build()}).build();
    private static final SdkField<String> MANAGED_DRAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedDraining").getter(AutoScalingGroupProvider.getter(AutoScalingGroupProvider::managedDrainingAsString)).setter(AutoScalingGroupProvider.setter(Builder::managedDraining)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDraining").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_ARN_FIELD, MANAGED_SCALING_FIELD, MANAGED_TERMINATION_PROTECTION_FIELD, MANAGED_DRAINING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoScalingGroupProvider.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String autoScalingGroupArn;
    private final ManagedScaling managedScaling;
    private final String managedTerminationProtection;
    private final String managedDraining;

    private AutoScalingGroupProvider(BuilderImpl builder) {
        this.autoScalingGroupArn = builder.autoScalingGroupArn;
        this.managedScaling = builder.managedScaling;
        this.managedTerminationProtection = builder.managedTerminationProtection;
        this.managedDraining = builder.managedDraining;
    }

    public final String autoScalingGroupArn() {
        return this.autoScalingGroupArn;
    }

    public final ManagedScaling managedScaling() {
        return this.managedScaling;
    }

    public final ManagedTerminationProtection managedTerminationProtection() {
        return ManagedTerminationProtection.fromValue(this.managedTerminationProtection);
    }

    public final String managedTerminationProtectionAsString() {
        return this.managedTerminationProtection;
    }

    public final ManagedDraining managedDraining() {
        return ManagedDraining.fromValue(this.managedDraining);
    }

    public final String managedDrainingAsString() {
        return this.managedDraining;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedScaling());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedTerminationProtectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedDrainingAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroupProvider)) {
            return false;
        }
        AutoScalingGroupProvider other = (AutoScalingGroupProvider)obj;
        return Objects.equals(this.autoScalingGroupArn(), other.autoScalingGroupArn()) && Objects.equals(this.managedScaling(), other.managedScaling()) && Objects.equals(this.managedTerminationProtectionAsString(), other.managedTerminationProtectionAsString()) && Objects.equals(this.managedDrainingAsString(), other.managedDrainingAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingGroupProvider").add("AutoScalingGroupArn", (Object)this.autoScalingGroupArn()).add("ManagedScaling", (Object)this.managedScaling()).add("ManagedTerminationProtection", (Object)this.managedTerminationProtectionAsString()).add("ManagedDraining", (Object)this.managedDrainingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autoScalingGroupArn": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupArn()));
            }
            case "managedScaling": {
                return Optional.ofNullable(clazz.cast(this.managedScaling()));
            }
            case "managedTerminationProtection": {
                return Optional.ofNullable(clazz.cast(this.managedTerminationProtectionAsString()));
            }
            case "managedDraining": {
                return Optional.ofNullable(clazz.cast(this.managedDrainingAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("autoScalingGroupArn", AUTO_SCALING_GROUP_ARN_FIELD);
        map.put("managedScaling", MANAGED_SCALING_FIELD);
        map.put("managedTerminationProtection", MANAGED_TERMINATION_PROTECTION_FIELD);
        map.put("managedDraining", MANAGED_DRAINING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroupProvider, T> g) {
        return obj -> g.apply((AutoScalingGroupProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupArn;
        private ManagedScaling managedScaling;
        private String managedTerminationProtection;
        private String managedDraining;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroupProvider model) {
            this.autoScalingGroupArn(model.autoScalingGroupArn);
            this.managedScaling(model.managedScaling);
            this.managedTerminationProtection(model.managedTerminationProtection);
            this.managedDraining(model.managedDraining);
        }

        public final String getAutoScalingGroupArn() {
            return this.autoScalingGroupArn;
        }

        public final void setAutoScalingGroupArn(String autoScalingGroupArn) {
            this.autoScalingGroupArn = autoScalingGroupArn;
        }

        @Override
        public final Builder autoScalingGroupArn(String autoScalingGroupArn) {
            this.autoScalingGroupArn = autoScalingGroupArn;
            return this;
        }

        public final ManagedScaling.Builder getManagedScaling() {
            return this.managedScaling != null ? this.managedScaling.toBuilder() : null;
        }

        public final void setManagedScaling(ManagedScaling.BuilderImpl managedScaling) {
            this.managedScaling = managedScaling != null ? managedScaling.build() : null;
        }

        @Override
        public final Builder managedScaling(ManagedScaling managedScaling) {
            this.managedScaling = managedScaling;
            return this;
        }

        public final String getManagedTerminationProtection() {
            return this.managedTerminationProtection;
        }

        public final void setManagedTerminationProtection(String managedTerminationProtection) {
            this.managedTerminationProtection = managedTerminationProtection;
        }

        @Override
        public final Builder managedTerminationProtection(String managedTerminationProtection) {
            this.managedTerminationProtection = managedTerminationProtection;
            return this;
        }

        @Override
        public final Builder managedTerminationProtection(ManagedTerminationProtection managedTerminationProtection) {
            this.managedTerminationProtection(managedTerminationProtection == null ? null : managedTerminationProtection.toString());
            return this;
        }

        public final String getManagedDraining() {
            return this.managedDraining;
        }

        public final void setManagedDraining(String managedDraining) {
            this.managedDraining = managedDraining;
        }

        @Override
        public final Builder managedDraining(String managedDraining) {
            this.managedDraining = managedDraining;
            return this;
        }

        @Override
        public final Builder managedDraining(ManagedDraining managedDraining) {
            this.managedDraining(managedDraining == null ? null : managedDraining.toString());
            return this;
        }

        public AutoScalingGroupProvider build() {
            return new AutoScalingGroupProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingGroupProvider> {
        public Builder autoScalingGroupArn(String var1);

        public Builder managedScaling(ManagedScaling var1);

        default public Builder managedScaling(Consumer<ManagedScaling.Builder> managedScaling) {
            return this.managedScaling((ManagedScaling)((ManagedScaling.Builder)ManagedScaling.builder().applyMutation(managedScaling)).build());
        }

        public Builder managedTerminationProtection(String var1);

        public Builder managedTerminationProtection(ManagedTerminationProtection var1);

        public Builder managedDraining(String var1);

        public Builder managedDraining(ManagedDraining var1);
    }
}

