/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdvancedConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdvancedConfiguration> {
    private static final SdkField<String> ALTERNATE_TARGET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alternateTargetGroupArn").getter(AdvancedConfiguration.getter(AdvancedConfiguration::alternateTargetGroupArn)).setter(AdvancedConfiguration.setter(Builder::alternateTargetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alternateTargetGroupArn").build()}).build();
    private static final SdkField<String> PRODUCTION_LISTENER_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("productionListenerRule").getter(AdvancedConfiguration.getter(AdvancedConfiguration::productionListenerRule)).setter(AdvancedConfiguration.setter(Builder::productionListenerRule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productionListenerRule").build()}).build();
    private static final SdkField<String> TEST_LISTENER_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testListenerRule").getter(AdvancedConfiguration.getter(AdvancedConfiguration::testListenerRule)).setter(AdvancedConfiguration.setter(Builder::testListenerRule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testListenerRule").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(AdvancedConfiguration.getter(AdvancedConfiguration::roleArn)).setter(AdvancedConfiguration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALTERNATE_TARGET_GROUP_ARN_FIELD, PRODUCTION_LISTENER_RULE_FIELD, TEST_LISTENER_RULE_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AdvancedConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alternateTargetGroupArn;
    private final String productionListenerRule;
    private final String testListenerRule;
    private final String roleArn;

    private AdvancedConfiguration(BuilderImpl builder) {
        this.alternateTargetGroupArn = builder.alternateTargetGroupArn;
        this.productionListenerRule = builder.productionListenerRule;
        this.testListenerRule = builder.testListenerRule;
        this.roleArn = builder.roleArn;
    }

    public final String alternateTargetGroupArn() {
        return this.alternateTargetGroupArn;
    }

    public final String productionListenerRule() {
        return this.productionListenerRule;
    }

    public final String testListenerRule() {
        return this.testListenerRule;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alternateTargetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.productionListenerRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.testListenerRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedConfiguration)) {
            return false;
        }
        AdvancedConfiguration other = (AdvancedConfiguration)obj;
        return Objects.equals(this.alternateTargetGroupArn(), other.alternateTargetGroupArn()) && Objects.equals(this.productionListenerRule(), other.productionListenerRule()) && Objects.equals(this.testListenerRule(), other.testListenerRule()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"AdvancedConfiguration").add("AlternateTargetGroupArn", (Object)this.alternateTargetGroupArn()).add("ProductionListenerRule", (Object)this.productionListenerRule()).add("TestListenerRule", (Object)this.testListenerRule()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alternateTargetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.alternateTargetGroupArn()));
            }
            case "productionListenerRule": {
                return Optional.ofNullable(clazz.cast(this.productionListenerRule()));
            }
            case "testListenerRule": {
                return Optional.ofNullable(clazz.cast(this.testListenerRule()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("alternateTargetGroupArn", ALTERNATE_TARGET_GROUP_ARN_FIELD);
        map.put("productionListenerRule", PRODUCTION_LISTENER_RULE_FIELD);
        map.put("testListenerRule", TEST_LISTENER_RULE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdvancedConfiguration, T> g) {
        return obj -> g.apply((AdvancedConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alternateTargetGroupArn;
        private String productionListenerRule;
        private String testListenerRule;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedConfiguration model) {
            this.alternateTargetGroupArn(model.alternateTargetGroupArn);
            this.productionListenerRule(model.productionListenerRule);
            this.testListenerRule(model.testListenerRule);
            this.roleArn(model.roleArn);
        }

        public final String getAlternateTargetGroupArn() {
            return this.alternateTargetGroupArn;
        }

        public final void setAlternateTargetGroupArn(String alternateTargetGroupArn) {
            this.alternateTargetGroupArn = alternateTargetGroupArn;
        }

        @Override
        public final Builder alternateTargetGroupArn(String alternateTargetGroupArn) {
            this.alternateTargetGroupArn = alternateTargetGroupArn;
            return this;
        }

        public final String getProductionListenerRule() {
            return this.productionListenerRule;
        }

        public final void setProductionListenerRule(String productionListenerRule) {
            this.productionListenerRule = productionListenerRule;
        }

        @Override
        public final Builder productionListenerRule(String productionListenerRule) {
            this.productionListenerRule = productionListenerRule;
            return this;
        }

        public final String getTestListenerRule() {
            return this.testListenerRule;
        }

        public final void setTestListenerRule(String testListenerRule) {
            this.testListenerRule = testListenerRule;
        }

        @Override
        public final Builder testListenerRule(String testListenerRule) {
            this.testListenerRule = testListenerRule;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public AdvancedConfiguration build() {
            return new AdvancedConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdvancedConfiguration> {
        public Builder alternateTargetGroupArn(String var1);

        public Builder productionListenerRule(String var1);

        public Builder testListenerRule(String var1);

        public Builder roleArn(String var1);
    }
}

