/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceRegistry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceRegistry> {
    private static final SdkField<String> REGISTRY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryArn").getter(ServiceRegistry.getter(ServiceRegistry::registryArn)).setter(ServiceRegistry.setter(Builder::registryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryArn").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(ServiceRegistry.getter(ServiceRegistry::port)).setter(ServiceRegistry.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerName").getter(ServiceRegistry.getter(ServiceRegistry::containerName)).setter(ServiceRegistry.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()}).build();
    private static final SdkField<Integer> CONTAINER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("containerPort").getter(ServiceRegistry.getter(ServiceRegistry::containerPort)).setter(ServiceRegistry.setter(Builder::containerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ARN_FIELD, PORT_FIELD, CONTAINER_NAME_FIELD, CONTAINER_PORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceRegistry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String registryArn;
    private final Integer port;
    private final String containerName;
    private final Integer containerPort;

    private ServiceRegistry(BuilderImpl builder) {
        this.registryArn = builder.registryArn;
        this.port = builder.port;
        this.containerName = builder.containerName;
        this.containerPort = builder.containerPort;
    }

    public final String registryArn() {
        return this.registryArn;
    }

    public final Integer port() {
        return this.port;
    }

    public final String containerName() {
        return this.containerName;
    }

    public final Integer containerPort() {
        return this.containerPort;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceRegistry)) {
            return false;
        }
        ServiceRegistry other = (ServiceRegistry)obj;
        return Objects.equals(this.registryArn(), other.registryArn()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.containerPort(), other.containerPort());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceRegistry").add("RegistryArn", (Object)this.registryArn()).add("Port", (Object)this.port()).add("ContainerName", (Object)this.containerName()).add("ContainerPort", (Object)this.containerPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryArn": {
                return Optional.ofNullable(clazz.cast(this.registryArn()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "containerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "containerPort": {
                return Optional.ofNullable(clazz.cast(this.containerPort()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("registryArn", REGISTRY_ARN_FIELD);
        map.put("port", PORT_FIELD);
        map.put("containerName", CONTAINER_NAME_FIELD);
        map.put("containerPort", CONTAINER_PORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceRegistry, T> g) {
        return obj -> g.apply((ServiceRegistry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String registryArn;
        private Integer port;
        private String containerName;
        private Integer containerPort;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceRegistry model) {
            this.registryArn(model.registryArn);
            this.port(model.port);
            this.containerName(model.containerName);
            this.containerPort(model.containerPort);
        }

        public final String getRegistryArn() {
            return this.registryArn;
        }

        public final void setRegistryArn(String registryArn) {
            this.registryArn = registryArn;
        }

        @Override
        public final Builder registryArn(String registryArn) {
            this.registryArn = registryArn;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getContainerName() {
            return this.containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final Integer getContainerPort() {
            return this.containerPort;
        }

        public final void setContainerPort(Integer containerPort) {
            this.containerPort = containerPort;
        }

        @Override
        public final Builder containerPort(Integer containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        public ServiceRegistry build() {
            return new ServiceRegistry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceRegistry> {
        public Builder registryArn(String var1);

        public Builder port(Integer var1);

        public Builder containerName(String var1);

        public Builder containerPort(Integer var1);
    }
}

