/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration that controls how Amazon ECS optimizes your infrastructure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InfrastructureOptimization implements SdkPojo, Serializable,
        ToCopyableBuilder<InfrastructureOptimization.Builder, InfrastructureOptimization> {
    private static final SdkField<Integer> SCALE_IN_AFTER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("scaleInAfter").getter(getter(InfrastructureOptimization::scaleInAfter))
            .setter(setter(Builder::scaleInAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleInAfter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALE_IN_AFTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer scaleInAfter;

    private InfrastructureOptimization(BuilderImpl builder) {
        this.scaleInAfter = builder.scaleInAfter;
    }

    /**
     * <p>
     * This parameter defines the number of seconds Amazon ECS Managed Instances waits before optimizing EC2 instances
     * that have become idle or underutilized. A longer delay increases the likelihood of placing new tasks on idle or
     * underutilized instances instances, reducing startup time. A shorter delay helps reduce infrastructure costs by
     * optimizing idle or underutilized instances,instances more quickly.
     * </p>
     * <p>
     * Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>null</code> - Uses the default optimization behavior.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>-1</code> - Disables automatic infrastructure optimization.
     * </p>
     * </li>
     * <li>
     * <p>
     * A value between <code>0</code> and <code>3600</code> (inclusive) - Specifies the number of seconds to wait before
     * optimizing instances.
     * </p>
     * </li>
     * </ul>
     * 
     * @return This parameter defines the number of seconds Amazon ECS Managed Instances waits before optimizing EC2
     *         instances that have become idle or underutilized. A longer delay increases the likelihood of placing new
     *         tasks on idle or underutilized instances instances, reducing startup time. A shorter delay helps reduce
     *         infrastructure costs by optimizing idle or underutilized instances,instances more quickly.</p>
     *         <p>
     *         Valid values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>null</code> - Uses the default optimization behavior.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>-1</code> - Disables automatic infrastructure optimization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A value between <code>0</code> and <code>3600</code> (inclusive) - Specifies the number of seconds to
     *         wait before optimizing instances.
     *         </p>
     *         </li>
     */
    public final Integer scaleInAfter() {
        return scaleInAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scaleInAfter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InfrastructureOptimization)) {
            return false;
        }
        InfrastructureOptimization other = (InfrastructureOptimization) obj;
        return Objects.equals(scaleInAfter(), other.scaleInAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InfrastructureOptimization").add("ScaleInAfter", scaleInAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scaleInAfter":
            return Optional.ofNullable(clazz.cast(scaleInAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scaleInAfter", SCALE_IN_AFTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InfrastructureOptimization, T> g) {
        return obj -> g.apply((InfrastructureOptimization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InfrastructureOptimization> {
        /**
         * <p>
         * This parameter defines the number of seconds Amazon ECS Managed Instances waits before optimizing EC2
         * instances that have become idle or underutilized. A longer delay increases the likelihood of placing new
         * tasks on idle or underutilized instances instances, reducing startup time. A shorter delay helps reduce
         * infrastructure costs by optimizing idle or underutilized instances,instances more quickly.
         * </p>
         * <p>
         * Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>null</code> - Uses the default optimization behavior.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>-1</code> - Disables automatic infrastructure optimization.
         * </p>
         * </li>
         * <li>
         * <p>
         * A value between <code>0</code> and <code>3600</code> (inclusive) - Specifies the number of seconds to wait
         * before optimizing instances.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scaleInAfter
         *        This parameter defines the number of seconds Amazon ECS Managed Instances waits before optimizing EC2
         *        instances that have become idle or underutilized. A longer delay increases the likelihood of placing
         *        new tasks on idle or underutilized instances instances, reducing startup time. A shorter delay helps
         *        reduce infrastructure costs by optimizing idle or underutilized instances,instances more quickly.</p>
         *        <p>
         *        Valid values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>null</code> - Uses the default optimization behavior.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>-1</code> - Disables automatic infrastructure optimization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A value between <code>0</code> and <code>3600</code> (inclusive) - Specifies the number of seconds to
         *        wait before optimizing instances.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleInAfter(Integer scaleInAfter);
    }

    static final class BuilderImpl implements Builder {
        private Integer scaleInAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(InfrastructureOptimization model) {
            scaleInAfter(model.scaleInAfter);
        }

        public final Integer getScaleInAfter() {
            return scaleInAfter;
        }

        public final void setScaleInAfter(Integer scaleInAfter) {
            this.scaleInAfter = scaleInAfter;
        }

        @Override
        public final Builder scaleInAfter(Integer scaleInAfter) {
            this.scaleInAfter = scaleInAfter;
            return this;
        }

        @Override
        public InfrastructureOptimization build() {
            return new InfrastructureOptimization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
