/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for linear deployment strategy that shifts production traffic in equal percentage increments with
 * configurable wait times between each step until 100% of traffic is shifted to the new service revision. This is only
 * valid when you run <code>CreateService</code> or <code>UpdateService</code> with <code>deploymentController</code>
 * set to <code>ECS</code> and a <code>deploymentConfiguration</code> with a strategy set to <code>LINEAR</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LinearConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LinearConfiguration.Builder, LinearConfiguration> {
    private static final SdkField<Double> STEP_PERCENT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("stepPercent").getter(getter(LinearConfiguration::stepPercent)).setter(setter(Builder::stepPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepPercent").build()).build();

    private static final SdkField<Integer> STEP_BAKE_TIME_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("stepBakeTimeInMinutes").getter(getter(LinearConfiguration::stepBakeTimeInMinutes))
            .setter(setter(Builder::stepBakeTimeInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepBakeTimeInMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_PERCENT_FIELD,
            STEP_BAKE_TIME_IN_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double stepPercent;

    private final Integer stepBakeTimeInMinutes;

    private LinearConfiguration(BuilderImpl builder) {
        this.stepPercent = builder.stepPercent;
        this.stepBakeTimeInMinutes = builder.stepBakeTimeInMinutes;
    }

    /**
     * <p>
     * The percentage of production traffic to shift in each step during a linear deployment. Valid values are multiples
     * of 0.1 from 3.0 to 100.0. The default value is 10.0.
     * </p>
     * 
     * @return The percentage of production traffic to shift in each step during a linear deployment. Valid values are
     *         multiples of 0.1 from 3.0 to 100.0. The default value is 10.0.
     */
    public final Double stepPercent() {
        return stepPercent;
    }

    /**
     * <p>
     * The amount of time in minutes to wait between each traffic shifting step during a linear deployment. Valid values
     * are 0 to 1440 minutes (24 hours). The default value is 6. This bake time is not applied after reaching 100
     * percent traffic.
     * </p>
     * 
     * @return The amount of time in minutes to wait between each traffic shifting step during a linear deployment.
     *         Valid values are 0 to 1440 minutes (24 hours). The default value is 6. This bake time is not applied
     *         after reaching 100 percent traffic.
     */
    public final Integer stepBakeTimeInMinutes() {
        return stepBakeTimeInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepPercent());
        hashCode = 31 * hashCode + Objects.hashCode(stepBakeTimeInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinearConfiguration)) {
            return false;
        }
        LinearConfiguration other = (LinearConfiguration) obj;
        return Objects.equals(stepPercent(), other.stepPercent())
                && Objects.equals(stepBakeTimeInMinutes(), other.stepBakeTimeInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LinearConfiguration").add("StepPercent", stepPercent())
                .add("StepBakeTimeInMinutes", stepBakeTimeInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepPercent":
            return Optional.ofNullable(clazz.cast(stepPercent()));
        case "stepBakeTimeInMinutes":
            return Optional.ofNullable(clazz.cast(stepBakeTimeInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stepPercent", STEP_PERCENT_FIELD);
        map.put("stepBakeTimeInMinutes", STEP_BAKE_TIME_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LinearConfiguration, T> g) {
        return obj -> g.apply((LinearConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LinearConfiguration> {
        /**
         * <p>
         * The percentage of production traffic to shift in each step during a linear deployment. Valid values are
         * multiples of 0.1 from 3.0 to 100.0. The default value is 10.0.
         * </p>
         * 
         * @param stepPercent
         *        The percentage of production traffic to shift in each step during a linear deployment. Valid values
         *        are multiples of 0.1 from 3.0 to 100.0. The default value is 10.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepPercent(Double stepPercent);

        /**
         * <p>
         * The amount of time in minutes to wait between each traffic shifting step during a linear deployment. Valid
         * values are 0 to 1440 minutes (24 hours). The default value is 6. This bake time is not applied after reaching
         * 100 percent traffic.
         * </p>
         * 
         * @param stepBakeTimeInMinutes
         *        The amount of time in minutes to wait between each traffic shifting step during a linear deployment.
         *        Valid values are 0 to 1440 minutes (24 hours). The default value is 6. This bake time is not applied
         *        after reaching 100 percent traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepBakeTimeInMinutes(Integer stepBakeTimeInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Double stepPercent;

        private Integer stepBakeTimeInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(LinearConfiguration model) {
            stepPercent(model.stepPercent);
            stepBakeTimeInMinutes(model.stepBakeTimeInMinutes);
        }

        public final Double getStepPercent() {
            return stepPercent;
        }

        public final void setStepPercent(Double stepPercent) {
            this.stepPercent = stepPercent;
        }

        @Override
        public final Builder stepPercent(Double stepPercent) {
            this.stepPercent = stepPercent;
            return this;
        }

        public final Integer getStepBakeTimeInMinutes() {
            return stepBakeTimeInMinutes;
        }

        public final void setStepBakeTimeInMinutes(Integer stepBakeTimeInMinutes) {
            this.stepBakeTimeInMinutes = stepBakeTimeInMinutes;
        }

        @Override
        public final Builder stepBakeTimeInMinutes(Integer stepBakeTimeInMinutes) {
            this.stepBakeTimeInMinutes = stepBakeTimeInMinutes;
            return this;
        }

        @Override
        public LinearConfiguration build() {
            return new LinearConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
