/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EBSTagSpecification;
import software.amazon.awssdk.services.ecs.model.EBSTagSpecificationsCopier;
import software.amazon.awssdk.services.ecs.model.TaskFilesystemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceManagedEBSVolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceManagedEBSVolumeConfiguration> {
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("encrypted").getter(ServiceManagedEBSVolumeConfiguration.getter(ServiceManagedEBSVolumeConfiguration::encrypted)).setter(ServiceManagedEBSVolumeConfiguration.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(ServiceManagedEBSVolumeConfiguration.getter(ServiceManagedEBSVolumeConfiguration::kmsKeyId)).setter(ServiceManagedEBSVolumeConfiguration.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeType").getter(ServiceManagedEBSVolumeConfiguration.getter(ServiceManagedEBSVolumeConfiguration::volumeType)).setter(ServiceManagedEBSVolumeConfiguration.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeType").build()}).build();
    private static final SdkField<Integer> SIZE_IN_GIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("sizeInGiB").getter(ServiceManagedEBSVolumeConfiguration.getter(ServiceManagedEBSVolumeConfiguration::sizeInGiB)).setter(ServiceManagedEBSVolumeConfiguration.setter(Builder::sizeInGiB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGiB").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotId").getter(ServiceManagedEBSVolumeConfiguration.getter(ServiceManagedEBSVolumeConfiguration::snapshotId)).setter(ServiceManagedEBSVolumeConfiguration.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotId").build()}).build();
    private static final SdkField<Integer> VOLUME_INITIALIZATION_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("volumeInitializationRate").getter(ServiceManagedEBSVolumeConfiguration.getter(ServiceManagedEBSVolumeConfiguration::volumeInitializationRate)).setter(ServiceManagedEBSVolumeConfiguration.setter(Builder::volumeInitializationRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeInitializationRate").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("iops").getter(ServiceManagedEBSVolumeConfiguration.getter(ServiceManagedEBSVolumeConfiguration::iops)).setter(ServiceManagedEBSVolumeConfiguration.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iops").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("throughput").getter(ServiceManagedEBSVolumeConfiguration.getter(ServiceManagedEBSVolumeConfiguration::throughput)).setter(ServiceManagedEBSVolumeConfiguration.setter(Builder::throughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throughput").build()}).build();
    private static final SdkField<List<EBSTagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tagSpecifications").getter(ServiceManagedEBSVolumeConfiguration.getter(ServiceManagedEBSVolumeConfiguration::tagSpecifications)).setter(ServiceManagedEBSVolumeConfiguration.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagSpecifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EBSTagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(ServiceManagedEBSVolumeConfiguration.getter(ServiceManagedEBSVolumeConfiguration::roleArn)).setter(ServiceManagedEBSVolumeConfiguration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> FILESYSTEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filesystemType").getter(ServiceManagedEBSVolumeConfiguration.getter(ServiceManagedEBSVolumeConfiguration::filesystemTypeAsString)).setter(ServiceManagedEBSVolumeConfiguration.setter(Builder::filesystemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filesystemType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, VOLUME_TYPE_FIELD, SIZE_IN_GIB_FIELD, SNAPSHOT_ID_FIELD, VOLUME_INITIALIZATION_RATE_FIELD, IOPS_FIELD, THROUGHPUT_FIELD, TAG_SPECIFICATIONS_FIELD, ROLE_ARN_FIELD, FILESYSTEM_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceManagedEBSVolumeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final String volumeType;
    private final Integer sizeInGiB;
    private final String snapshotId;
    private final Integer volumeInitializationRate;
    private final Integer iops;
    private final Integer throughput;
    private final List<EBSTagSpecification> tagSpecifications;
    private final String roleArn;
    private final String filesystemType;

    private ServiceManagedEBSVolumeConfiguration(BuilderImpl builder) {
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.volumeType = builder.volumeType;
        this.sizeInGiB = builder.sizeInGiB;
        this.snapshotId = builder.snapshotId;
        this.volumeInitializationRate = builder.volumeInitializationRate;
        this.iops = builder.iops;
        this.throughput = builder.throughput;
        this.tagSpecifications = builder.tagSpecifications;
        this.roleArn = builder.roleArn;
        this.filesystemType = builder.filesystemType;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String volumeType() {
        return this.volumeType;
    }

    public final Integer sizeInGiB() {
        return this.sizeInGiB;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final Integer volumeInitializationRate() {
        return this.volumeInitializationRate;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final Integer throughput() {
        return this.throughput;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<EBSTagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final TaskFilesystemType filesystemType() {
        return TaskFilesystemType.fromValue(this.filesystemType);
    }

    public final String filesystemTypeAsString() {
        return this.filesystemType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGiB());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeInitializationRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.filesystemTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceManagedEBSVolumeConfiguration)) {
            return false;
        }
        ServiceManagedEBSVolumeConfiguration other = (ServiceManagedEBSVolumeConfiguration)obj;
        return Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.volumeType(), other.volumeType()) && Objects.equals(this.sizeInGiB(), other.sizeInGiB()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.volumeInitializationRate(), other.volumeInitializationRate()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.throughput(), other.throughput()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.filesystemTypeAsString(), other.filesystemTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceManagedEBSVolumeConfiguration").add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("VolumeType", (Object)this.volumeType()).add("SizeInGiB", (Object)this.sizeInGiB()).add("SnapshotId", (Object)this.snapshotId()).add("VolumeInitializationRate", (Object)this.volumeInitializationRate()).add("Iops", (Object)this.iops()).add("Throughput", (Object)this.throughput()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("RoleArn", (Object)this.roleArn()).add("FilesystemType", (Object)this.filesystemTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "volumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeType()));
            }
            case "sizeInGiB": {
                return Optional.ofNullable(clazz.cast(this.sizeInGiB()));
            }
            case "snapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "volumeInitializationRate": {
                return Optional.ofNullable(clazz.cast(this.volumeInitializationRate()));
            }
            case "iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "throughput": {
                return Optional.ofNullable(clazz.cast(this.throughput()));
            }
            case "tagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "filesystemType": {
                return Optional.ofNullable(clazz.cast(this.filesystemTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("encrypted", ENCRYPTED_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("volumeType", VOLUME_TYPE_FIELD);
        map.put("sizeInGiB", SIZE_IN_GIB_FIELD);
        map.put("snapshotId", SNAPSHOT_ID_FIELD);
        map.put("volumeInitializationRate", VOLUME_INITIALIZATION_RATE_FIELD);
        map.put("iops", IOPS_FIELD);
        map.put("throughput", THROUGHPUT_FIELD);
        map.put("tagSpecifications", TAG_SPECIFICATIONS_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("filesystemType", FILESYSTEM_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceManagedEBSVolumeConfiguration, T> g) {
        return obj -> g.apply((ServiceManagedEBSVolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean encrypted;
        private String kmsKeyId;
        private String volumeType;
        private Integer sizeInGiB;
        private String snapshotId;
        private Integer volumeInitializationRate;
        private Integer iops;
        private Integer throughput;
        private List<EBSTagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private String filesystemType;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceManagedEBSVolumeConfiguration model) {
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.volumeType(model.volumeType);
            this.sizeInGiB(model.sizeInGiB);
            this.snapshotId(model.snapshotId);
            this.volumeInitializationRate(model.volumeInitializationRate);
            this.iops(model.iops);
            this.throughput(model.throughput);
            this.tagSpecifications(model.tagSpecifications);
            this.roleArn(model.roleArn);
            this.filesystemType(model.filesystemType);
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final Integer getSizeInGiB() {
            return this.sizeInGiB;
        }

        public final void setSizeInGiB(Integer sizeInGiB) {
            this.sizeInGiB = sizeInGiB;
        }

        @Override
        public final Builder sizeInGiB(Integer sizeInGiB) {
            this.sizeInGiB = sizeInGiB;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Integer getVolumeInitializationRate() {
            return this.volumeInitializationRate;
        }

        public final void setVolumeInitializationRate(Integer volumeInitializationRate) {
            this.volumeInitializationRate = volumeInitializationRate;
        }

        @Override
        public final Builder volumeInitializationRate(Integer volumeInitializationRate) {
            this.volumeInitializationRate = volumeInitializationRate;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getThroughput() {
            return this.throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public final List<EBSTagSpecification.Builder> getTagSpecifications() {
            List<EBSTagSpecification.Builder> result = EBSTagSpecificationsCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<EBSTagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = EBSTagSpecificationsCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<EBSTagSpecification> tagSpecifications) {
            this.tagSpecifications = EBSTagSpecificationsCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(EBSTagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<EBSTagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (EBSTagSpecification)((EBSTagSpecification.Builder)EBSTagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getFilesystemType() {
            return this.filesystemType;
        }

        public final void setFilesystemType(String filesystemType) {
            this.filesystemType = filesystemType;
        }

        @Override
        public final Builder filesystemType(String filesystemType) {
            this.filesystemType = filesystemType;
            return this;
        }

        @Override
        public final Builder filesystemType(TaskFilesystemType filesystemType) {
            this.filesystemType(filesystemType == null ? null : filesystemType.toString());
            return this;
        }

        public ServiceManagedEBSVolumeConfiguration build() {
            return new ServiceManagedEBSVolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceManagedEBSVolumeConfiguration> {
        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder volumeType(String var1);

        public Builder sizeInGiB(Integer var1);

        public Builder snapshotId(String var1);

        public Builder volumeInitializationRate(Integer var1);

        public Builder iops(Integer var1);

        public Builder throughput(Integer var1);

        public Builder tagSpecifications(Collection<EBSTagSpecification> var1);

        public Builder tagSpecifications(EBSTagSpecification ... var1);

        public Builder tagSpecifications(Consumer<EBSTagSpecification.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder filesystemType(String var1);

        public Builder filesystemType(TaskFilesystemType var1);
    }
}

