/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCapacityProviderRequest extends EcsRequest implements
        ToCopyableBuilder<UpdateCapacityProviderRequest.Builder, UpdateCapacityProviderRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateCapacityProviderRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(UpdateCapacityProviderRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<AutoScalingGroupProviderUpdate> AUTO_SCALING_GROUP_PROVIDER_FIELD = SdkField
            .<AutoScalingGroupProviderUpdate> builder(MarshallingType.SDK_POJO).memberName("autoScalingGroupProvider")
            .getter(getter(UpdateCapacityProviderRequest::autoScalingGroupProvider))
            .setter(setter(Builder::autoScalingGroupProvider)).constructor(AutoScalingGroupProviderUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupProvider").build())
            .build();

    private static final SdkField<UpdateManagedInstancesProviderConfiguration> MANAGED_INSTANCES_PROVIDER_FIELD = SdkField
            .<UpdateManagedInstancesProviderConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("managedInstancesProvider").getter(getter(UpdateCapacityProviderRequest::managedInstancesProvider))
            .setter(setter(Builder::managedInstancesProvider)).constructor(UpdateManagedInstancesProviderConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedInstancesProvider").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CLUSTER_FIELD,
            AUTO_SCALING_GROUP_PROVIDER_FIELD, MANAGED_INSTANCES_PROVIDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String cluster;

    private final AutoScalingGroupProviderUpdate autoScalingGroupProvider;

    private final UpdateManagedInstancesProviderConfiguration managedInstancesProvider;

    private UpdateCapacityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.cluster = builder.cluster;
        this.autoScalingGroupProvider = builder.autoScalingGroupProvider;
        this.managedInstancesProvider = builder.managedInstancesProvider;
    }

    /**
     * <p>
     * The name of the capacity provider to update.
     * </p>
     * 
     * @return The name of the capacity provider to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the cluster that contains the capacity provider to update. Managed instances capacity providers are
     * cluster-scoped and can only be updated within their associated cluster.
     * </p>
     * 
     * @return The name of the cluster that contains the capacity provider to update. Managed instances capacity
     *         providers are cluster-scoped and can only be updated within their associated cluster.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * An object that represent the parameters to update for the Auto Scaling group capacity provider.
     * </p>
     * 
     * @return An object that represent the parameters to update for the Auto Scaling group capacity provider.
     */
    public final AutoScalingGroupProviderUpdate autoScalingGroupProvider() {
        return autoScalingGroupProvider;
    }

    /**
     * <p>
     * The updated configuration for the Amazon ECS Managed Instances provider. You can modify the infrastructure role,
     * instance launch template, and tag propagation settings. Changes take effect for new instances launched after the
     * update.
     * </p>
     * 
     * @return The updated configuration for the Amazon ECS Managed Instances provider. You can modify the
     *         infrastructure role, instance launch template, and tag propagation settings. Changes take effect for new
     *         instances launched after the update.
     */
    public final UpdateManagedInstancesProviderConfiguration managedInstancesProvider() {
        return managedInstancesProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupProvider());
        hashCode = 31 * hashCode + Objects.hashCode(managedInstancesProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCapacityProviderRequest)) {
            return false;
        }
        UpdateCapacityProviderRequest other = (UpdateCapacityProviderRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(cluster(), other.cluster())
                && Objects.equals(autoScalingGroupProvider(), other.autoScalingGroupProvider())
                && Objects.equals(managedInstancesProvider(), other.managedInstancesProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCapacityProviderRequest").add("Name", name()).add("Cluster", cluster())
                .add("AutoScalingGroupProvider", autoScalingGroupProvider())
                .add("ManagedInstancesProvider", managedInstancesProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "autoScalingGroupProvider":
            return Optional.ofNullable(clazz.cast(autoScalingGroupProvider()));
        case "managedInstancesProvider":
            return Optional.ofNullable(clazz.cast(managedInstancesProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("cluster", CLUSTER_FIELD);
        map.put("autoScalingGroupProvider", AUTO_SCALING_GROUP_PROVIDER_FIELD);
        map.put("managedInstancesProvider", MANAGED_INSTANCES_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCapacityProviderRequest, T> g) {
        return obj -> g.apply((UpdateCapacityProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCapacityProviderRequest> {
        /**
         * <p>
         * The name of the capacity provider to update.
         * </p>
         * 
         * @param name
         *        The name of the capacity provider to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the cluster that contains the capacity provider to update. Managed instances capacity providers
         * are cluster-scoped and can only be updated within their associated cluster.
         * </p>
         * 
         * @param cluster
         *        The name of the cluster that contains the capacity provider to update. Managed instances capacity
         *        providers are cluster-scoped and can only be updated within their associated cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * An object that represent the parameters to update for the Auto Scaling group capacity provider.
         * </p>
         * 
         * @param autoScalingGroupProvider
         *        An object that represent the parameters to update for the Auto Scaling group capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupProvider(AutoScalingGroupProviderUpdate autoScalingGroupProvider);

        /**
         * <p>
         * An object that represent the parameters to update for the Auto Scaling group capacity provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScalingGroupProviderUpdate.Builder}
         * avoiding the need to create one manually via {@link AutoScalingGroupProviderUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoScalingGroupProviderUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #autoScalingGroupProvider(AutoScalingGroupProviderUpdate)}.
         * 
         * @param autoScalingGroupProvider
         *        a consumer that will call methods on {@link AutoScalingGroupProviderUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingGroupProvider(AutoScalingGroupProviderUpdate)
         */
        default Builder autoScalingGroupProvider(Consumer<AutoScalingGroupProviderUpdate.Builder> autoScalingGroupProvider) {
            return autoScalingGroupProvider(AutoScalingGroupProviderUpdate.builder().applyMutation(autoScalingGroupProvider)
                    .build());
        }

        /**
         * <p>
         * The updated configuration for the Amazon ECS Managed Instances provider. You can modify the infrastructure
         * role, instance launch template, and tag propagation settings. Changes take effect for new instances launched
         * after the update.
         * </p>
         * 
         * @param managedInstancesProvider
         *        The updated configuration for the Amazon ECS Managed Instances provider. You can modify the
         *        infrastructure role, instance launch template, and tag propagation settings. Changes take effect for
         *        new instances launched after the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedInstancesProvider(UpdateManagedInstancesProviderConfiguration managedInstancesProvider);

        /**
         * <p>
         * The updated configuration for the Amazon ECS Managed Instances provider. You can modify the infrastructure
         * role, instance launch template, and tag propagation settings. Changes take effect for new instances launched
         * after the update.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateManagedInstancesProviderConfiguration.Builder} avoiding the need to create one manually via
         * {@link UpdateManagedInstancesProviderConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateManagedInstancesProviderConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #managedInstancesProvider(UpdateManagedInstancesProviderConfiguration)}.
         * 
         * @param managedInstancesProvider
         *        a consumer that will call methods on {@link UpdateManagedInstancesProviderConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedInstancesProvider(UpdateManagedInstancesProviderConfiguration)
         */
        default Builder managedInstancesProvider(
                Consumer<UpdateManagedInstancesProviderConfiguration.Builder> managedInstancesProvider) {
            return managedInstancesProvider(UpdateManagedInstancesProviderConfiguration.builder()
                    .applyMutation(managedInstancesProvider).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String name;

        private String cluster;

        private AutoScalingGroupProviderUpdate autoScalingGroupProvider;

        private UpdateManagedInstancesProviderConfiguration managedInstancesProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCapacityProviderRequest model) {
            super(model);
            name(model.name);
            cluster(model.cluster);
            autoScalingGroupProvider(model.autoScalingGroupProvider);
            managedInstancesProvider(model.managedInstancesProvider);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final AutoScalingGroupProviderUpdate.Builder getAutoScalingGroupProvider() {
            return autoScalingGroupProvider != null ? autoScalingGroupProvider.toBuilder() : null;
        }

        public final void setAutoScalingGroupProvider(AutoScalingGroupProviderUpdate.BuilderImpl autoScalingGroupProvider) {
            this.autoScalingGroupProvider = autoScalingGroupProvider != null ? autoScalingGroupProvider.build() : null;
        }

        @Override
        public final Builder autoScalingGroupProvider(AutoScalingGroupProviderUpdate autoScalingGroupProvider) {
            this.autoScalingGroupProvider = autoScalingGroupProvider;
            return this;
        }

        public final UpdateManagedInstancesProviderConfiguration.Builder getManagedInstancesProvider() {
            return managedInstancesProvider != null ? managedInstancesProvider.toBuilder() : null;
        }

        public final void setManagedInstancesProvider(
                UpdateManagedInstancesProviderConfiguration.BuilderImpl managedInstancesProvider) {
            this.managedInstancesProvider = managedInstancesProvider != null ? managedInstancesProvider.build() : null;
        }

        @Override
        public final Builder managedInstancesProvider(UpdateManagedInstancesProviderConfiguration managedInstancesProvider) {
            this.managedInstancesProvider = managedInstancesProvider;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCapacityProviderRequest build() {
            return new UpdateCapacityProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
