/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The advanced settings for a load balancer used in blue/green deployments. Specify the alternate target group,
 * listener rules, and IAM role required for traffic shifting during blue/green deployments. For more information, see
 * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/blue-green-deployment-implementation.html">
 * Required resources for Amazon ECS blue/green deployments</a> in the <i>Amazon Elastic Container Service Developer
 * Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdvancedConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AdvancedConfiguration.Builder, AdvancedConfiguration> {
    private static final SdkField<String> ALTERNATE_TARGET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alternateTargetGroupArn").getter(getter(AdvancedConfiguration::alternateTargetGroupArn))
            .setter(setter(Builder::alternateTargetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alternateTargetGroupArn").build())
            .build();

    private static final SdkField<String> PRODUCTION_LISTENER_RULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("productionListenerRule").getter(getter(AdvancedConfiguration::productionListenerRule))
            .setter(setter(Builder::productionListenerRule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productionListenerRule").build())
            .build();

    private static final SdkField<String> TEST_LISTENER_RULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testListenerRule").getter(getter(AdvancedConfiguration::testListenerRule))
            .setter(setter(Builder::testListenerRule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testListenerRule").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(AdvancedConfiguration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ALTERNATE_TARGET_GROUP_ARN_FIELD, PRODUCTION_LISTENER_RULE_FIELD, TEST_LISTENER_RULE_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String alternateTargetGroupArn;

    private final String productionListenerRule;

    private final String testListenerRule;

    private final String roleArn;

    private AdvancedConfiguration(BuilderImpl builder) {
        this.alternateTargetGroupArn = builder.alternateTargetGroupArn;
        this.productionListenerRule = builder.productionListenerRule;
        this.testListenerRule = builder.testListenerRule;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the alternate target group for Amazon ECS blue/green deployments.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the alternate target group for Amazon ECS blue/green deployments.
     */
    public final String alternateTargetGroupArn() {
        return alternateTargetGroupArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that that identifies the production listener rule (in the case of an Application
     * Load Balancer) or listener (in the case for an Network Load Balancer) for routing production traffic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that that identifies the production listener rule (in the case of an
     *         Application Load Balancer) or listener (in the case for an Network Load Balancer) for routing production
     *         traffic.
     */
    public final String productionListenerRule() {
        return productionListenerRule;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies ) that identifies the test listener rule (in the case of an
     * Application Load Balancer) or listener (in the case for an Network Load Balancer) for routing test traffic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies ) that identifies the test listener rule (in the case of
     *         an Application Load Balancer) or listener (in the case for an Network Load Balancer) for routing test
     *         traffic.
     */
    public final String testListenerRule() {
        return testListenerRule;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that grants Amazon ECS permission to call the Elastic Load
     * Balancing APIs for you.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that grants Amazon ECS permission to call the Elastic Load
     *         Balancing APIs for you.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alternateTargetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(productionListenerRule());
        hashCode = 31 * hashCode + Objects.hashCode(testListenerRule());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedConfiguration)) {
            return false;
        }
        AdvancedConfiguration other = (AdvancedConfiguration) obj;
        return Objects.equals(alternateTargetGroupArn(), other.alternateTargetGroupArn())
                && Objects.equals(productionListenerRule(), other.productionListenerRule())
                && Objects.equals(testListenerRule(), other.testListenerRule()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdvancedConfiguration").add("AlternateTargetGroupArn", alternateTargetGroupArn())
                .add("ProductionListenerRule", productionListenerRule()).add("TestListenerRule", testListenerRule())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alternateTargetGroupArn":
            return Optional.ofNullable(clazz.cast(alternateTargetGroupArn()));
        case "productionListenerRule":
            return Optional.ofNullable(clazz.cast(productionListenerRule()));
        case "testListenerRule":
            return Optional.ofNullable(clazz.cast(testListenerRule()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("alternateTargetGroupArn", ALTERNATE_TARGET_GROUP_ARN_FIELD);
        map.put("productionListenerRule", PRODUCTION_LISTENER_RULE_FIELD);
        map.put("testListenerRule", TEST_LISTENER_RULE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdvancedConfiguration, T> g) {
        return obj -> g.apply((AdvancedConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdvancedConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the alternate target group for Amazon ECS blue/green deployments.
         * </p>
         * 
         * @param alternateTargetGroupArn
         *        The Amazon Resource Name (ARN) of the alternate target group for Amazon ECS blue/green deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternateTargetGroupArn(String alternateTargetGroupArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that that identifies the production listener rule (in the case of an
         * Application Load Balancer) or listener (in the case for an Network Load Balancer) for routing production
         * traffic.
         * </p>
         * 
         * @param productionListenerRule
         *        The Amazon Resource Name (ARN) that that identifies the production listener rule (in the case of an
         *        Application Load Balancer) or listener (in the case for an Network Load Balancer) for routing
         *        production traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionListenerRule(String productionListenerRule);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies ) that identifies the test listener rule (in the case of an
         * Application Load Balancer) or listener (in the case for an Network Load Balancer) for routing test traffic.
         * </p>
         * 
         * @param testListenerRule
         *        The Amazon Resource Name (ARN) that identifies ) that identifies the test listener rule (in the case
         *        of an Application Load Balancer) or listener (in the case for an Network Load Balancer) for routing
         *        test traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testListenerRule(String testListenerRule);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that grants Amazon ECS permission to call the Elastic Load
         * Balancing APIs for you.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that grants Amazon ECS permission to call the Elastic
         *        Load Balancing APIs for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String alternateTargetGroupArn;

        private String productionListenerRule;

        private String testListenerRule;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedConfiguration model) {
            alternateTargetGroupArn(model.alternateTargetGroupArn);
            productionListenerRule(model.productionListenerRule);
            testListenerRule(model.testListenerRule);
            roleArn(model.roleArn);
        }

        public final String getAlternateTargetGroupArn() {
            return alternateTargetGroupArn;
        }

        public final void setAlternateTargetGroupArn(String alternateTargetGroupArn) {
            this.alternateTargetGroupArn = alternateTargetGroupArn;
        }

        @Override
        public final Builder alternateTargetGroupArn(String alternateTargetGroupArn) {
            this.alternateTargetGroupArn = alternateTargetGroupArn;
            return this;
        }

        public final String getProductionListenerRule() {
            return productionListenerRule;
        }

        public final void setProductionListenerRule(String productionListenerRule) {
            this.productionListenerRule = productionListenerRule;
        }

        @Override
        public final Builder productionListenerRule(String productionListenerRule) {
            this.productionListenerRule = productionListenerRule;
            return this;
        }

        public final String getTestListenerRule() {
            return testListenerRule;
        }

        public final void setTestListenerRule(String testListenerRule) {
            this.testListenerRule = testListenerRule;
        }

        @Override
        public final Builder testListenerRule(String testListenerRule) {
            this.testListenerRule = testListenerRule;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public AdvancedConfiguration build() {
            return new AdvancedConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
