/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.EcsResponse;
import software.amazon.awssdk.services.ecs.model.Session;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteCommandResponse
extends EcsResponse
implements ToCopyableBuilder<Builder, ExecuteCommandResponse> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterArn").getter(ExecuteCommandResponse.getter(ExecuteCommandResponse::clusterArn)).setter(ExecuteCommandResponse.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CONTAINER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerArn").getter(ExecuteCommandResponse.getter(ExecuteCommandResponse::containerArn)).setter(ExecuteCommandResponse.setter(Builder::containerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerArn").build()}).build();
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerName").getter(ExecuteCommandResponse.getter(ExecuteCommandResponse::containerName)).setter(ExecuteCommandResponse.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()}).build();
    private static final SdkField<Boolean> INTERACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("interactive").getter(ExecuteCommandResponse.getter(ExecuteCommandResponse::interactive)).setter(ExecuteCommandResponse.setter(Builder::interactive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interactive").build()}).build();
    private static final SdkField<Session> SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("session").getter(ExecuteCommandResponse.getter(ExecuteCommandResponse::session)).setter(ExecuteCommandResponse.setter(Builder::session)).constructor(Session::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("session").build()}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskArn").getter(ExecuteCommandResponse.getter(ExecuteCommandResponse::taskArn)).setter(ExecuteCommandResponse.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CONTAINER_ARN_FIELD, CONTAINER_NAME_FIELD, INTERACTIVE_FIELD, SESSION_FIELD, TASK_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecuteCommandResponse.memberNameToFieldInitializer();
    private final String clusterArn;
    private final String containerArn;
    private final String containerName;
    private final Boolean interactive;
    private final Session session;
    private final String taskArn;

    private ExecuteCommandResponse(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.containerArn = builder.containerArn;
        this.containerName = builder.containerName;
        this.interactive = builder.interactive;
        this.session = builder.session;
        this.taskArn = builder.taskArn;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String containerArn() {
        return this.containerArn;
    }

    public final String containerName() {
        return this.containerName;
    }

    public final Boolean interactive() {
        return this.interactive;
    }

    public final Session session() {
        return this.session;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.interactive());
        hashCode = 31 * hashCode + Objects.hashCode(this.session());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteCommandResponse)) {
            return false;
        }
        ExecuteCommandResponse other = (ExecuteCommandResponse)((Object)obj);
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.containerArn(), other.containerArn()) && Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.interactive(), other.interactive()) && Objects.equals(this.session(), other.session()) && Objects.equals(this.taskArn(), other.taskArn());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteCommandResponse").add("ClusterArn", (Object)this.clusterArn()).add("ContainerArn", (Object)this.containerArn()).add("ContainerName", (Object)this.containerName()).add("Interactive", (Object)this.interactive()).add("Session", (Object)this.session()).add("TaskArn", (Object)this.taskArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "containerArn": {
                return Optional.ofNullable(clazz.cast(this.containerArn()));
            }
            case "containerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "interactive": {
                return Optional.ofNullable(clazz.cast(this.interactive()));
            }
            case "session": {
                return Optional.ofNullable(clazz.cast(this.session()));
            }
            case "taskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("containerArn", CONTAINER_ARN_FIELD);
        map.put("containerName", CONTAINER_NAME_FIELD);
        map.put("interactive", INTERACTIVE_FIELD);
        map.put("session", SESSION_FIELD);
        map.put("taskArn", TASK_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteCommandResponse, T> g) {
        return obj -> g.apply((ExecuteCommandResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsResponse.BuilderImpl
    implements Builder {
        private String clusterArn;
        private String containerArn;
        private String containerName;
        private Boolean interactive;
        private Session session;
        private String taskArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteCommandResponse model) {
            super(model);
            this.clusterArn(model.clusterArn);
            this.containerArn(model.containerArn);
            this.containerName(model.containerName);
            this.interactive(model.interactive);
            this.session(model.session);
            this.taskArn(model.taskArn);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getContainerArn() {
            return this.containerArn;
        }

        public final void setContainerArn(String containerArn) {
            this.containerArn = containerArn;
        }

        @Override
        public final Builder containerArn(String containerArn) {
            this.containerArn = containerArn;
            return this;
        }

        public final String getContainerName() {
            return this.containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final Boolean getInteractive() {
            return this.interactive;
        }

        public final void setInteractive(Boolean interactive) {
            this.interactive = interactive;
        }

        @Override
        public final Builder interactive(Boolean interactive) {
            this.interactive = interactive;
            return this;
        }

        public final Session.Builder getSession() {
            return this.session != null ? this.session.toBuilder() : null;
        }

        public final void setSession(Session.BuilderImpl session) {
            this.session = session != null ? session.build() : null;
        }

        @Override
        public final Builder session(Session session) {
            this.session = session;
            return this;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        @Override
        public ExecuteCommandResponse build() {
            return new ExecuteCommandResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteCommandResponse> {
        public Builder clusterArn(String var1);

        public Builder containerArn(String var1);

        public Builder containerName(String var1);

        public Builder interactive(Boolean var1);

        public Builder session(Session var1);

        default public Builder session(Consumer<Session.Builder> session) {
            return this.session((Session)((Session.Builder)Session.builder().applyMutation(session)).build());
        }

        public Builder taskArn(String var1);
    }
}

