/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyCopier;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem;
import software.amazon.awssdk.services.ecs.model.DeploymentConfiguration;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.LoadBalancer;
import software.amazon.awssdk.services.ecs.model.LoadBalancersCopier;
import software.amazon.awssdk.services.ecs.model.NetworkConfiguration;
import software.amazon.awssdk.services.ecs.model.PlacementConstraint;
import software.amazon.awssdk.services.ecs.model.PlacementConstraintsCopier;
import software.amazon.awssdk.services.ecs.model.PlacementStrategiesCopier;
import software.amazon.awssdk.services.ecs.model.PlacementStrategy;
import software.amazon.awssdk.services.ecs.model.PropagateTags;
import software.amazon.awssdk.services.ecs.model.ServiceConnectConfiguration;
import software.amazon.awssdk.services.ecs.model.ServiceRegistriesCopier;
import software.amazon.awssdk.services.ecs.model.ServiceRegistry;
import software.amazon.awssdk.services.ecs.model.ServiceVolumeConfiguration;
import software.amazon.awssdk.services.ecs.model.ServiceVolumeConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServiceRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, UpdateServiceRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(UpdateServiceRequest.getter(UpdateServiceRequest::cluster)).setter(UpdateServiceRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("service").getter(UpdateServiceRequest.getter(UpdateServiceRequest::service)).setter(UpdateServiceRequest.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()}).build();
    private static final SdkField<Integer> DESIRED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("desiredCount").getter(UpdateServiceRequest.getter(UpdateServiceRequest::desiredCount)).setter(UpdateServiceRequest.setter(Builder::desiredCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCount").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskDefinition").getter(UpdateServiceRequest.getter(UpdateServiceRequest::taskDefinition)).setter(UpdateServiceRequest.setter(Builder::taskDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()}).build();
    private static final SdkField<List<CapacityProviderStrategyItem>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capacityProviderStrategy").getter(UpdateServiceRequest.getter(UpdateServiceRequest::capacityProviderStrategy)).setter(UpdateServiceRequest.setter(Builder::capacityProviderStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityProviderStrategyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentConfiguration").getter(UpdateServiceRequest.getter(UpdateServiceRequest::deploymentConfiguration)).setter(UpdateServiceRequest.setter(Builder::deploymentConfiguration)).constructor(DeploymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(UpdateServiceRequest.getter(UpdateServiceRequest::networkConfiguration)).setter(UpdateServiceRequest.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<List<PlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("placementConstraints").getter(UpdateServiceRequest.getter(UpdateServiceRequest::placementConstraints)).setter(UpdateServiceRequest.setter(Builder::placementConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PlacementStrategy>> PLACEMENT_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("placementStrategy").getter(UpdateServiceRequest.getter(UpdateServiceRequest::placementStrategy)).setter(UpdateServiceRequest.setter(Builder::placementStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformVersion").getter(UpdateServiceRequest.getter(UpdateServiceRequest::platformVersion)).setter(UpdateServiceRequest.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<Boolean> FORCE_NEW_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("forceNewDeployment").getter(UpdateServiceRequest.getter(UpdateServiceRequest::forceNewDeployment)).setter(UpdateServiceRequest.setter(Builder::forceNewDeployment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceNewDeployment").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("healthCheckGracePeriodSeconds").getter(UpdateServiceRequest.getter(UpdateServiceRequest::healthCheckGracePeriodSeconds)).setter(UpdateServiceRequest.setter(Builder::healthCheckGracePeriodSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckGracePeriodSeconds").build()}).build();
    private static final SdkField<Boolean> ENABLE_EXECUTE_COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableExecuteCommand").getter(UpdateServiceRequest.getter(UpdateServiceRequest::enableExecuteCommand)).setter(UpdateServiceRequest.setter(Builder::enableExecuteCommand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableExecuteCommand").build()}).build();
    private static final SdkField<Boolean> ENABLE_ECS_MANAGED_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableECSManagedTags").getter(UpdateServiceRequest.getter(UpdateServiceRequest::enableECSManagedTags)).setter(UpdateServiceRequest.setter(Builder::enableECSManagedTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableECSManagedTags").build()}).build();
    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("loadBalancers").getter(UpdateServiceRequest.getter(UpdateServiceRequest::loadBalancers)).setter(UpdateServiceRequest.setter(Builder::loadBalancers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBalancer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propagateTags").getter(UpdateServiceRequest.getter(UpdateServiceRequest::propagateTagsAsString)).setter(UpdateServiceRequest.setter(Builder::propagateTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()}).build();
    private static final SdkField<List<ServiceRegistry>> SERVICE_REGISTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceRegistries").getter(UpdateServiceRequest.getter(UpdateServiceRequest::serviceRegistries)).setter(UpdateServiceRequest.setter(Builder::serviceRegistries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRegistries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceRegistry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ServiceConnectConfiguration> SERVICE_CONNECT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceConnectConfiguration").getter(UpdateServiceRequest.getter(UpdateServiceRequest::serviceConnectConfiguration)).setter(UpdateServiceRequest.setter(Builder::serviceConnectConfiguration)).constructor(ServiceConnectConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceConnectConfiguration").build()}).build();
    private static final SdkField<List<ServiceVolumeConfiguration>> VOLUME_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumeConfigurations").getter(UpdateServiceRequest.getter(UpdateServiceRequest::volumeConfigurations)).setter(UpdateServiceRequest.setter(Builder::volumeConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceVolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, SERVICE_FIELD, DESIRED_COUNT_FIELD, TASK_DEFINITION_FIELD, CAPACITY_PROVIDER_STRATEGY_FIELD, DEPLOYMENT_CONFIGURATION_FIELD, NETWORK_CONFIGURATION_FIELD, PLACEMENT_CONSTRAINTS_FIELD, PLACEMENT_STRATEGY_FIELD, PLATFORM_VERSION_FIELD, FORCE_NEW_DEPLOYMENT_FIELD, HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD, ENABLE_EXECUTE_COMMAND_FIELD, ENABLE_ECS_MANAGED_TAGS_FIELD, LOAD_BALANCERS_FIELD, PROPAGATE_TAGS_FIELD, SERVICE_REGISTRIES_FIELD, SERVICE_CONNECT_CONFIGURATION_FIELD, VOLUME_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cluster", CLUSTER_FIELD);
            this.put("service", SERVICE_FIELD);
            this.put("desiredCount", DESIRED_COUNT_FIELD);
            this.put("taskDefinition", TASK_DEFINITION_FIELD);
            this.put("capacityProviderStrategy", CAPACITY_PROVIDER_STRATEGY_FIELD);
            this.put("deploymentConfiguration", DEPLOYMENT_CONFIGURATION_FIELD);
            this.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
            this.put("placementConstraints", PLACEMENT_CONSTRAINTS_FIELD);
            this.put("placementStrategy", PLACEMENT_STRATEGY_FIELD);
            this.put("platformVersion", PLATFORM_VERSION_FIELD);
            this.put("forceNewDeployment", FORCE_NEW_DEPLOYMENT_FIELD);
            this.put("healthCheckGracePeriodSeconds", HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD);
            this.put("enableExecuteCommand", ENABLE_EXECUTE_COMMAND_FIELD);
            this.put("enableECSManagedTags", ENABLE_ECS_MANAGED_TAGS_FIELD);
            this.put("loadBalancers", LOAD_BALANCERS_FIELD);
            this.put("propagateTags", PROPAGATE_TAGS_FIELD);
            this.put("serviceRegistries", SERVICE_REGISTRIES_FIELD);
            this.put("serviceConnectConfiguration", SERVICE_CONNECT_CONFIGURATION_FIELD);
            this.put("volumeConfigurations", VOLUME_CONFIGURATIONS_FIELD);
        }
    });
    private final String cluster;
    private final String service;
    private final Integer desiredCount;
    private final String taskDefinition;
    private final List<CapacityProviderStrategyItem> capacityProviderStrategy;
    private final DeploymentConfiguration deploymentConfiguration;
    private final NetworkConfiguration networkConfiguration;
    private final List<PlacementConstraint> placementConstraints;
    private final List<PlacementStrategy> placementStrategy;
    private final String platformVersion;
    private final Boolean forceNewDeployment;
    private final Integer healthCheckGracePeriodSeconds;
    private final Boolean enableExecuteCommand;
    private final Boolean enableECSManagedTags;
    private final List<LoadBalancer> loadBalancers;
    private final String propagateTags;
    private final List<ServiceRegistry> serviceRegistries;
    private final ServiceConnectConfiguration serviceConnectConfiguration;
    private final List<ServiceVolumeConfiguration> volumeConfigurations;

    private UpdateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.service = builder.service;
        this.desiredCount = builder.desiredCount;
        this.taskDefinition = builder.taskDefinition;
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.networkConfiguration = builder.networkConfiguration;
        this.placementConstraints = builder.placementConstraints;
        this.placementStrategy = builder.placementStrategy;
        this.platformVersion = builder.platformVersion;
        this.forceNewDeployment = builder.forceNewDeployment;
        this.healthCheckGracePeriodSeconds = builder.healthCheckGracePeriodSeconds;
        this.enableExecuteCommand = builder.enableExecuteCommand;
        this.enableECSManagedTags = builder.enableECSManagedTags;
        this.loadBalancers = builder.loadBalancers;
        this.propagateTags = builder.propagateTags;
        this.serviceRegistries = builder.serviceRegistries;
        this.serviceConnectConfiguration = builder.serviceConnectConfiguration;
        this.volumeConfigurations = builder.volumeConfigurations;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final String service() {
        return this.service;
    }

    public final Integer desiredCount() {
        return this.desiredCount;
    }

    public final String taskDefinition() {
        return this.taskDefinition;
    }

    public final boolean hasCapacityProviderStrategy() {
        return this.capacityProviderStrategy != null && !(this.capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    public final List<CapacityProviderStrategyItem> capacityProviderStrategy() {
        return this.capacityProviderStrategy;
    }

    public final DeploymentConfiguration deploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final boolean hasPlacementConstraints() {
        return this.placementConstraints != null && !(this.placementConstraints instanceof SdkAutoConstructList);
    }

    public final List<PlacementConstraint> placementConstraints() {
        return this.placementConstraints;
    }

    public final boolean hasPlacementStrategy() {
        return this.placementStrategy != null && !(this.placementStrategy instanceof SdkAutoConstructList);
    }

    public final List<PlacementStrategy> placementStrategy() {
        return this.placementStrategy;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final Boolean forceNewDeployment() {
        return this.forceNewDeployment;
    }

    public final Integer healthCheckGracePeriodSeconds() {
        return this.healthCheckGracePeriodSeconds;
    }

    public final Boolean enableExecuteCommand() {
        return this.enableExecuteCommand;
    }

    public final Boolean enableECSManagedTags() {
        return this.enableECSManagedTags;
    }

    public final boolean hasLoadBalancers() {
        return this.loadBalancers != null && !(this.loadBalancers instanceof SdkAutoConstructList);
    }

    public final List<LoadBalancer> loadBalancers() {
        return this.loadBalancers;
    }

    public final PropagateTags propagateTags() {
        return PropagateTags.fromValue(this.propagateTags);
    }

    public final String propagateTagsAsString() {
        return this.propagateTags;
    }

    public final boolean hasServiceRegistries() {
        return this.serviceRegistries != null && !(this.serviceRegistries instanceof SdkAutoConstructList);
    }

    public final List<ServiceRegistry> serviceRegistries() {
        return this.serviceRegistries;
    }

    public final ServiceConnectConfiguration serviceConnectConfiguration() {
        return this.serviceConnectConfiguration;
    }

    public final boolean hasVolumeConfigurations() {
        return this.volumeConfigurations != null && !(this.volumeConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ServiceVolumeConfiguration> volumeConfigurations() {
        return this.volumeConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityProviderStrategy() ? this.capacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlacementConstraints() ? this.placementConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlacementStrategy() ? this.placementStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceNewDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckGracePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableExecuteCommand());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableECSManagedTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancers() ? this.loadBalancers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.propagateTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceRegistries() ? this.serviceRegistries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceConnectConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumeConfigurations() ? this.volumeConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceRequest)) {
            return false;
        }
        UpdateServiceRequest other = (UpdateServiceRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.desiredCount(), other.desiredCount()) && Objects.equals(this.taskDefinition(), other.taskDefinition()) && this.hasCapacityProviderStrategy() == other.hasCapacityProviderStrategy() && Objects.equals(this.capacityProviderStrategy(), other.capacityProviderStrategy()) && Objects.equals(this.deploymentConfiguration(), other.deploymentConfiguration()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && this.hasPlacementConstraints() == other.hasPlacementConstraints() && Objects.equals(this.placementConstraints(), other.placementConstraints()) && this.hasPlacementStrategy() == other.hasPlacementStrategy() && Objects.equals(this.placementStrategy(), other.placementStrategy()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.forceNewDeployment(), other.forceNewDeployment()) && Objects.equals(this.healthCheckGracePeriodSeconds(), other.healthCheckGracePeriodSeconds()) && Objects.equals(this.enableExecuteCommand(), other.enableExecuteCommand()) && Objects.equals(this.enableECSManagedTags(), other.enableECSManagedTags()) && this.hasLoadBalancers() == other.hasLoadBalancers() && Objects.equals(this.loadBalancers(), other.loadBalancers()) && Objects.equals(this.propagateTagsAsString(), other.propagateTagsAsString()) && this.hasServiceRegistries() == other.hasServiceRegistries() && Objects.equals(this.serviceRegistries(), other.serviceRegistries()) && Objects.equals(this.serviceConnectConfiguration(), other.serviceConnectConfiguration()) && this.hasVolumeConfigurations() == other.hasVolumeConfigurations() && Objects.equals(this.volumeConfigurations(), other.volumeConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateServiceRequest").add("Cluster", (Object)this.cluster()).add("Service", (Object)this.service()).add("DesiredCount", (Object)this.desiredCount()).add("TaskDefinition", (Object)this.taskDefinition()).add("CapacityProviderStrategy", this.hasCapacityProviderStrategy() ? this.capacityProviderStrategy() : null).add("DeploymentConfiguration", (Object)this.deploymentConfiguration()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("PlacementConstraints", this.hasPlacementConstraints() ? this.placementConstraints() : null).add("PlacementStrategy", this.hasPlacementStrategy() ? this.placementStrategy() : null).add("PlatformVersion", (Object)this.platformVersion()).add("ForceNewDeployment", (Object)this.forceNewDeployment()).add("HealthCheckGracePeriodSeconds", (Object)this.healthCheckGracePeriodSeconds()).add("EnableExecuteCommand", (Object)this.enableExecuteCommand()).add("EnableECSManagedTags", (Object)this.enableECSManagedTags()).add("LoadBalancers", this.hasLoadBalancers() ? this.loadBalancers() : null).add("PropagateTags", (Object)this.propagateTagsAsString()).add("ServiceRegistries", this.hasServiceRegistries() ? this.serviceRegistries() : null).add("ServiceConnectConfiguration", (Object)this.serviceConnectConfiguration()).add("VolumeConfigurations", this.hasVolumeConfigurations() ? this.volumeConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "desiredCount": {
                return Optional.ofNullable(clazz.cast(this.desiredCount()));
            }
            case "taskDefinition": {
                return Optional.ofNullable(clazz.cast(this.taskDefinition()));
            }
            case "capacityProviderStrategy": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderStrategy()));
            }
            case "deploymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfiguration()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "placementConstraints": {
                return Optional.ofNullable(clazz.cast(this.placementConstraints()));
            }
            case "placementStrategy": {
                return Optional.ofNullable(clazz.cast(this.placementStrategy()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "forceNewDeployment": {
                return Optional.ofNullable(clazz.cast(this.forceNewDeployment()));
            }
            case "healthCheckGracePeriodSeconds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckGracePeriodSeconds()));
            }
            case "enableExecuteCommand": {
                return Optional.ofNullable(clazz.cast(this.enableExecuteCommand()));
            }
            case "enableECSManagedTags": {
                return Optional.ofNullable(clazz.cast(this.enableECSManagedTags()));
            }
            case "loadBalancers": {
                return Optional.ofNullable(clazz.cast(this.loadBalancers()));
            }
            case "propagateTags": {
                return Optional.ofNullable(clazz.cast(this.propagateTagsAsString()));
            }
            case "serviceRegistries": {
                return Optional.ofNullable(clazz.cast(this.serviceRegistries()));
            }
            case "serviceConnectConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serviceConnectConfiguration()));
            }
            case "volumeConfigurations": {
                return Optional.ofNullable(clazz.cast(this.volumeConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceRequest, T> g) {
        return obj -> g.apply((UpdateServiceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private String service;
        private Integer desiredCount;
        private String taskDefinition;
        private List<CapacityProviderStrategyItem> capacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();
        private DeploymentConfiguration deploymentConfiguration;
        private NetworkConfiguration networkConfiguration;
        private List<PlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();
        private List<PlacementStrategy> placementStrategy = DefaultSdkAutoConstructList.getInstance();
        private String platformVersion;
        private Boolean forceNewDeployment;
        private Integer healthCheckGracePeriodSeconds;
        private Boolean enableExecuteCommand;
        private Boolean enableECSManagedTags;
        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();
        private String propagateTags;
        private List<ServiceRegistry> serviceRegistries = DefaultSdkAutoConstructList.getInstance();
        private ServiceConnectConfiguration serviceConnectConfiguration;
        private List<ServiceVolumeConfiguration> volumeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.service(model.service);
            this.desiredCount(model.desiredCount);
            this.taskDefinition(model.taskDefinition);
            this.capacityProviderStrategy(model.capacityProviderStrategy);
            this.deploymentConfiguration(model.deploymentConfiguration);
            this.networkConfiguration(model.networkConfiguration);
            this.placementConstraints(model.placementConstraints);
            this.placementStrategy(model.placementStrategy);
            this.platformVersion(model.platformVersion);
            this.forceNewDeployment(model.forceNewDeployment);
            this.healthCheckGracePeriodSeconds(model.healthCheckGracePeriodSeconds);
            this.enableExecuteCommand(model.enableExecuteCommand);
            this.enableECSManagedTags(model.enableECSManagedTags);
            this.loadBalancers(model.loadBalancers);
            this.propagateTags(model.propagateTags);
            this.serviceRegistries(model.serviceRegistries);
            this.serviceConnectConfiguration(model.serviceConnectConfiguration);
            this.volumeConfigurations(model.volumeConfigurations);
        }

        public final String getCluster() {
            return this.cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Integer getDesiredCount() {
            return this.desiredCount;
        }

        public final void setDesiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
        }

        @Override
        public final Builder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final String getTaskDefinition() {
            return this.taskDefinition;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final List<CapacityProviderStrategyItem.Builder> getCapacityProviderStrategy() {
            List<CapacityProviderStrategyItem.Builder> result = CapacityProviderStrategyCopier.copyToBuilder(this.capacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityProviderStrategy(Collection<CapacityProviderStrategyItem.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(capacityProviderStrategy);
        }

        @Override
        public final Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(CapacityProviderStrategyItem ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Stream.of(capacityProviderStrategy).map(c -> (CapacityProviderStrategyItem)((CapacityProviderStrategyItem.Builder)CapacityProviderStrategyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return this.deploymentConfiguration != null ? this.deploymentConfiguration.toBuilder() : null;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final List<PlacementConstraint.Builder> getPlacementConstraints() {
            List<PlacementConstraint.Builder> result = PlacementConstraintsCopier.copyToBuilder(this.placementConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementConstraints(Collection<PlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        @Override
        public final Builder placementConstraints(Collection<PlacementConstraint> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(PlacementConstraint ... placementConstraints) {
            this.placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<PlacementConstraint.Builder> ... placementConstraints) {
            this.placementConstraints(Stream.of(placementConstraints).map(c -> (PlacementConstraint)((PlacementConstraint.Builder)PlacementConstraint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PlacementStrategy.Builder> getPlacementStrategy() {
            List<PlacementStrategy.Builder> result = PlacementStrategiesCopier.copyToBuilder(this.placementStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementStrategy(Collection<PlacementStrategy.BuilderImpl> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copyFromBuilder(placementStrategy);
        }

        @Override
        public final Builder placementStrategy(Collection<PlacementStrategy> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copy(placementStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(PlacementStrategy ... placementStrategy) {
            this.placementStrategy(Arrays.asList(placementStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(Consumer<PlacementStrategy.Builder> ... placementStrategy) {
            this.placementStrategy(Stream.of(placementStrategy).map(c -> (PlacementStrategy)((PlacementStrategy.Builder)PlacementStrategy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final Boolean getForceNewDeployment() {
            return this.forceNewDeployment;
        }

        public final void setForceNewDeployment(Boolean forceNewDeployment) {
            this.forceNewDeployment = forceNewDeployment;
        }

        @Override
        public final Builder forceNewDeployment(Boolean forceNewDeployment) {
            this.forceNewDeployment = forceNewDeployment;
            return this;
        }

        public final Integer getHealthCheckGracePeriodSeconds() {
            return this.healthCheckGracePeriodSeconds;
        }

        public final void setHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
        }

        @Override
        public final Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
            return this;
        }

        public final Boolean getEnableExecuteCommand() {
            return this.enableExecuteCommand;
        }

        public final void setEnableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
        }

        @Override
        public final Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        public final Boolean getEnableECSManagedTags() {
            return this.enableECSManagedTags;
        }

        public final void setEnableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
        }

        @Override
        public final Builder enableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
            return this;
        }

        public final List<LoadBalancer.Builder> getLoadBalancers() {
            List<LoadBalancer.Builder> result = LoadBalancersCopier.copyToBuilder(this.loadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer ... loadBalancers) {
            this.loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder> ... loadBalancers) {
            this.loadBalancers(Stream.of(loadBalancers).map(c -> (LoadBalancer)((LoadBalancer.Builder)LoadBalancer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPropagateTags() {
            return this.propagateTags;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(PropagateTags propagateTags) {
            this.propagateTags(propagateTags == null ? null : propagateTags.toString());
            return this;
        }

        public final List<ServiceRegistry.Builder> getServiceRegistries() {
            List<ServiceRegistry.Builder> result = ServiceRegistriesCopier.copyToBuilder(this.serviceRegistries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceRegistries(Collection<ServiceRegistry.BuilderImpl> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copyFromBuilder(serviceRegistries);
        }

        @Override
        public final Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copy(serviceRegistries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(ServiceRegistry ... serviceRegistries) {
            this.serviceRegistries(Arrays.asList(serviceRegistries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(Consumer<ServiceRegistry.Builder> ... serviceRegistries) {
            this.serviceRegistries(Stream.of(serviceRegistries).map(c -> (ServiceRegistry)((ServiceRegistry.Builder)ServiceRegistry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ServiceConnectConfiguration.Builder getServiceConnectConfiguration() {
            return this.serviceConnectConfiguration != null ? this.serviceConnectConfiguration.toBuilder() : null;
        }

        public final void setServiceConnectConfiguration(ServiceConnectConfiguration.BuilderImpl serviceConnectConfiguration) {
            this.serviceConnectConfiguration = serviceConnectConfiguration != null ? serviceConnectConfiguration.build() : null;
        }

        @Override
        public final Builder serviceConnectConfiguration(ServiceConnectConfiguration serviceConnectConfiguration) {
            this.serviceConnectConfiguration = serviceConnectConfiguration;
            return this;
        }

        public final List<ServiceVolumeConfiguration.Builder> getVolumeConfigurations() {
            List<ServiceVolumeConfiguration.Builder> result = ServiceVolumeConfigurationsCopier.copyToBuilder(this.volumeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumeConfigurations(Collection<ServiceVolumeConfiguration.BuilderImpl> volumeConfigurations) {
            this.volumeConfigurations = ServiceVolumeConfigurationsCopier.copyFromBuilder(volumeConfigurations);
        }

        @Override
        public final Builder volumeConfigurations(Collection<ServiceVolumeConfiguration> volumeConfigurations) {
            this.volumeConfigurations = ServiceVolumeConfigurationsCopier.copy(volumeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(ServiceVolumeConfiguration ... volumeConfigurations) {
            this.volumeConfigurations(Arrays.asList(volumeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(Consumer<ServiceVolumeConfiguration.Builder> ... volumeConfigurations) {
            this.volumeConfigurations(Stream.of(volumeConfigurations).map(c -> (ServiceVolumeConfiguration)((ServiceVolumeConfiguration.Builder)ServiceVolumeConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceRequest build() {
            return new UpdateServiceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServiceRequest> {
        public Builder cluster(String var1);

        public Builder service(String var1);

        public Builder desiredCount(Integer var1);

        public Builder taskDefinition(String var1);

        public Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> var1);

        public Builder capacityProviderStrategy(CapacityProviderStrategyItem ... var1);

        public Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... var1);

        public Builder deploymentConfiguration(DeploymentConfiguration var1);

        default public Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return this.deploymentConfiguration((DeploymentConfiguration)((DeploymentConfiguration.Builder)DeploymentConfiguration.builder().applyMutation(deploymentConfiguration)).build());
        }

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder placementConstraints(Collection<PlacementConstraint> var1);

        public Builder placementConstraints(PlacementConstraint ... var1);

        public Builder placementConstraints(Consumer<PlacementConstraint.Builder> ... var1);

        public Builder placementStrategy(Collection<PlacementStrategy> var1);

        public Builder placementStrategy(PlacementStrategy ... var1);

        public Builder placementStrategy(Consumer<PlacementStrategy.Builder> ... var1);

        public Builder platformVersion(String var1);

        public Builder forceNewDeployment(Boolean var1);

        public Builder healthCheckGracePeriodSeconds(Integer var1);

        public Builder enableExecuteCommand(Boolean var1);

        public Builder enableECSManagedTags(Boolean var1);

        public Builder loadBalancers(Collection<LoadBalancer> var1);

        public Builder loadBalancers(LoadBalancer ... var1);

        public Builder loadBalancers(Consumer<LoadBalancer.Builder> ... var1);

        public Builder propagateTags(String var1);

        public Builder propagateTags(PropagateTags var1);

        public Builder serviceRegistries(Collection<ServiceRegistry> var1);

        public Builder serviceRegistries(ServiceRegistry ... var1);

        public Builder serviceRegistries(Consumer<ServiceRegistry.Builder> ... var1);

        public Builder serviceConnectConfiguration(ServiceConnectConfiguration var1);

        default public Builder serviceConnectConfiguration(Consumer<ServiceConnectConfiguration.Builder> serviceConnectConfiguration) {
            return this.serviceConnectConfiguration((ServiceConnectConfiguration)((ServiceConnectConfiguration.Builder)ServiceConnectConfiguration.builder().applyMutation(serviceConnectConfiguration)).build());
        }

        public Builder volumeConfigurations(Collection<ServiceVolumeConfiguration> var1);

        public Builder volumeConfigurations(ServiceVolumeConfiguration ... var1);

        public Builder volumeConfigurations(Consumer<ServiceVolumeConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

