/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.AutoScalingGroupProvider;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStatus;
import software.amazon.awssdk.services.ecs.model.CapacityProviderUpdateStatus;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityProvider> {
    private static final SdkField<String> CAPACITY_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capacityProviderArn").getter(CapacityProvider.getter(CapacityProvider::capacityProviderArn)).setter(CapacityProvider.setter(Builder::capacityProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CapacityProvider.getter(CapacityProvider::name)).setter(CapacityProvider.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CapacityProvider.getter(CapacityProvider::statusAsString)).setter(CapacityProvider.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<AutoScalingGroupProvider> AUTO_SCALING_GROUP_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoScalingGroupProvider").getter(CapacityProvider.getter(CapacityProvider::autoScalingGroupProvider)).setter(CapacityProvider.setter(Builder::autoScalingGroupProvider)).constructor(AutoScalingGroupProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupProvider").build()}).build();
    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateStatus").getter(CapacityProvider.getter(CapacityProvider::updateStatusAsString)).setter(CapacityProvider.setter(Builder::updateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateStatus").build()}).build();
    private static final SdkField<String> UPDATE_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateStatusReason").getter(CapacityProvider.getter(CapacityProvider::updateStatusReason)).setter(CapacityProvider.setter(Builder::updateStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateStatusReason").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CapacityProvider.getter(CapacityProvider::tags)).setter(CapacityProvider.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDER_ARN_FIELD, NAME_FIELD, STATUS_FIELD, AUTO_SCALING_GROUP_PROVIDER_FIELD, UPDATE_STATUS_FIELD, UPDATE_STATUS_REASON_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("capacityProviderArn", CAPACITY_PROVIDER_ARN_FIELD);
            this.put("name", NAME_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("autoScalingGroupProvider", AUTO_SCALING_GROUP_PROVIDER_FIELD);
            this.put("updateStatus", UPDATE_STATUS_FIELD);
            this.put("updateStatusReason", UPDATE_STATUS_REASON_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String capacityProviderArn;
    private final String name;
    private final String status;
    private final AutoScalingGroupProvider autoScalingGroupProvider;
    private final String updateStatus;
    private final String updateStatusReason;
    private final List<Tag> tags;

    private CapacityProvider(BuilderImpl builder) {
        this.capacityProviderArn = builder.capacityProviderArn;
        this.name = builder.name;
        this.status = builder.status;
        this.autoScalingGroupProvider = builder.autoScalingGroupProvider;
        this.updateStatus = builder.updateStatus;
        this.updateStatusReason = builder.updateStatusReason;
        this.tags = builder.tags;
    }

    public final String capacityProviderArn() {
        return this.capacityProviderArn;
    }

    public final String name() {
        return this.name;
    }

    public final CapacityProviderStatus status() {
        return CapacityProviderStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final AutoScalingGroupProvider autoScalingGroupProvider() {
        return this.autoScalingGroupProvider;
    }

    public final CapacityProviderUpdateStatus updateStatus() {
        return CapacityProviderUpdateStatus.fromValue(this.updateStatus);
    }

    public final String updateStatusAsString() {
        return this.updateStatus;
    }

    public final String updateStatusReason() {
        return this.updateStatusReason;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityProvider)) {
            return false;
        }
        CapacityProvider other = (CapacityProvider)obj;
        return Objects.equals(this.capacityProviderArn(), other.capacityProviderArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.autoScalingGroupProvider(), other.autoScalingGroupProvider()) && Objects.equals(this.updateStatusAsString(), other.updateStatusAsString()) && Objects.equals(this.updateStatusReason(), other.updateStatusReason()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityProvider").add("CapacityProviderArn", (Object)this.capacityProviderArn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("AutoScalingGroupProvider", (Object)this.autoScalingGroupProvider()).add("UpdateStatus", (Object)this.updateStatusAsString()).add("UpdateStatusReason", (Object)this.updateStatusReason()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "capacityProviderArn": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "autoScalingGroupProvider": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupProvider()));
            }
            case "updateStatus": {
                return Optional.ofNullable(clazz.cast(this.updateStatusAsString()));
            }
            case "updateStatusReason": {
                return Optional.ofNullable(clazz.cast(this.updateStatusReason()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CapacityProvider, T> g) {
        return obj -> g.apply((CapacityProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityProviderArn;
        private String name;
        private String status;
        private AutoScalingGroupProvider autoScalingGroupProvider;
        private String updateStatus;
        private String updateStatusReason;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityProvider model) {
            this.capacityProviderArn(model.capacityProviderArn);
            this.name(model.name);
            this.status(model.status);
            this.autoScalingGroupProvider(model.autoScalingGroupProvider);
            this.updateStatus(model.updateStatus);
            this.updateStatusReason(model.updateStatusReason);
            this.tags(model.tags);
        }

        public final String getCapacityProviderArn() {
            return this.capacityProviderArn;
        }

        public final void setCapacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
        }

        @Override
        public final Builder capacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CapacityProviderStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final AutoScalingGroupProvider.Builder getAutoScalingGroupProvider() {
            return this.autoScalingGroupProvider != null ? this.autoScalingGroupProvider.toBuilder() : null;
        }

        public final void setAutoScalingGroupProvider(AutoScalingGroupProvider.BuilderImpl autoScalingGroupProvider) {
            this.autoScalingGroupProvider = autoScalingGroupProvider != null ? autoScalingGroupProvider.build() : null;
        }

        @Override
        public final Builder autoScalingGroupProvider(AutoScalingGroupProvider autoScalingGroupProvider) {
            this.autoScalingGroupProvider = autoScalingGroupProvider;
            return this;
        }

        public final String getUpdateStatus() {
            return this.updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(CapacityProviderUpdateStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public final String getUpdateStatusReason() {
            return this.updateStatusReason;
        }

        public final void setUpdateStatusReason(String updateStatusReason) {
            this.updateStatusReason = updateStatusReason;
        }

        @Override
        public final Builder updateStatusReason(String updateStatusReason) {
            this.updateStatusReason = updateStatusReason;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CapacityProvider build() {
            return new CapacityProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityProvider> {
        public Builder capacityProviderArn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(CapacityProviderStatus var1);

        public Builder autoScalingGroupProvider(AutoScalingGroupProvider var1);

        default public Builder autoScalingGroupProvider(Consumer<AutoScalingGroupProvider.Builder> autoScalingGroupProvider) {
            return this.autoScalingGroupProvider((AutoScalingGroupProvider)((AutoScalingGroupProvider.Builder)AutoScalingGroupProvider.builder().applyMutation(autoScalingGroupProvider)).build());
        }

        public Builder updateStatus(String var1);

        public Builder updateStatus(CapacityProviderUpdateStatus var1);

        public Builder updateStatusReason(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

