/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.CreatedAt;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.ServiceDeploymentStatus;
import software.amazon.awssdk.services.ecs.model.ServiceDeploymentStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceDeploymentsRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, ListServiceDeploymentsRequest> {
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("service").getter(ListServiceDeploymentsRequest.getter(ListServiceDeploymentsRequest::service)).setter(ListServiceDeploymentsRequest.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()}).build();
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(ListServiceDeploymentsRequest.getter(ListServiceDeploymentsRequest::cluster)).setter(ListServiceDeploymentsRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<List<String>> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("status").getter(ListServiceDeploymentsRequest.getter(ListServiceDeploymentsRequest::statusAsStrings)).setter(ListServiceDeploymentsRequest.setter(Builder::statusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CreatedAt> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("createdAt").getter(ListServiceDeploymentsRequest.getter(ListServiceDeploymentsRequest::createdAt)).setter(ListServiceDeploymentsRequest.setter(Builder::createdAt)).constructor(CreatedAt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListServiceDeploymentsRequest.getter(ListServiceDeploymentsRequest::nextToken)).setter(ListServiceDeploymentsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListServiceDeploymentsRequest.getter(ListServiceDeploymentsRequest::maxResults)).setter(ListServiceDeploymentsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, CLUSTER_FIELD, STATUS_FIELD, CREATED_AT_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String service;
    private final String cluster;
    private final List<String> status;
    private final CreatedAt createdAt;
    private final String nextToken;
    private final Integer maxResults;

    private ListServiceDeploymentsRequest(BuilderImpl builder) {
        super(builder);
        this.service = builder.service;
        this.cluster = builder.cluster;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String service() {
        return this.service;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final List<ServiceDeploymentStatus> status() {
        return ServiceDeploymentStatusListCopier.copyStringToEnum(this.status);
    }

    public final boolean hasStatus() {
        return this.status != null && !(this.status instanceof SdkAutoConstructList);
    }

    public final List<String> statusAsStrings() {
        return this.status;
    }

    public final CreatedAt createdAt() {
        return this.createdAt;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatus() ? this.statusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceDeploymentsRequest)) {
            return false;
        }
        ListServiceDeploymentsRequest other = (ListServiceDeploymentsRequest)((Object)obj);
        return Objects.equals(this.service(), other.service()) && Objects.equals(this.cluster(), other.cluster()) && this.hasStatus() == other.hasStatus() && Objects.equals(this.statusAsStrings(), other.statusAsStrings()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListServiceDeploymentsRequest").add("Service", (Object)this.service()).add("Cluster", (Object)this.cluster()).add("Status", this.hasStatus() ? this.statusAsStrings() : null).add("CreatedAt", (Object)this.createdAt()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsStrings()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceDeploymentsRequest, T> g) {
        return obj -> g.apply((ListServiceDeploymentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String service;
        private String cluster;
        private List<String> status = DefaultSdkAutoConstructList.getInstance();
        private CreatedAt createdAt;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceDeploymentsRequest model) {
            super(model);
            this.service(model.service);
            this.cluster(model.cluster);
            this.statusWithStrings(model.status);
            this.createdAt(model.createdAt);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final String getCluster() {
            return this.cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final Collection<String> getStatus() {
            if (this.status instanceof SdkAutoConstructList) {
                return null;
            }
            return this.status;
        }

        public final void setStatus(Collection<String> status) {
            this.status = ServiceDeploymentStatusListCopier.copy(status);
        }

        @Override
        public final Builder statusWithStrings(Collection<String> status) {
            this.status = ServiceDeploymentStatusListCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusWithStrings(String ... status) {
            this.statusWithStrings(Arrays.asList(status));
            return this;
        }

        @Override
        public final Builder status(Collection<ServiceDeploymentStatus> status) {
            this.status = ServiceDeploymentStatusListCopier.copyEnumToString(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(ServiceDeploymentStatus ... status) {
            this.status(Arrays.asList(status));
            return this;
        }

        public final CreatedAt.Builder getCreatedAt() {
            return this.createdAt != null ? this.createdAt.toBuilder() : null;
        }

        public final void setCreatedAt(CreatedAt.BuilderImpl createdAt) {
            this.createdAt = createdAt != null ? createdAt.build() : null;
        }

        @Override
        public final Builder createdAt(CreatedAt createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServiceDeploymentsRequest build() {
            return new ListServiceDeploymentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceDeploymentsRequest> {
        public Builder service(String var1);

        public Builder cluster(String var1);

        public Builder statusWithStrings(Collection<String> var1);

        public Builder statusWithStrings(String ... var1);

        public Builder status(Collection<ServiceDeploymentStatus> var1);

        public Builder status(ServiceDeploymentStatus ... var1);

        public Builder createdAt(CreatedAt var1);

        default public Builder createdAt(Consumer<CreatedAt.Builder> createdAt) {
            return this.createdAt((CreatedAt)((CreatedAt.Builder)CreatedAt.builder().applyMutation(createdAt)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

