/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TaskFilesystemType {
    EXT3("ext3"),
    EXT4("ext4"),
    XFS("xfs"),
    NTFS("ntfs"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TaskFilesystemType> VALUE_MAP;
    private final String value;

    private TaskFilesystemType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TaskFilesystemType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TaskFilesystemType> knownValues() {
        EnumSet<TaskFilesystemType> knownValues = EnumSet.allOf(TaskFilesystemType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TaskFilesystemType.class, TaskFilesystemType::toString);
    }
}

