/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.Attachment;
import software.amazon.awssdk.services.ecs.model.AttachmentsCopier;
import software.amazon.awssdk.services.ecs.model.Attribute;
import software.amazon.awssdk.services.ecs.model.AttributesCopier;
import software.amazon.awssdk.services.ecs.model.Connectivity;
import software.amazon.awssdk.services.ecs.model.Container;
import software.amazon.awssdk.services.ecs.model.ContainersCopier;
import software.amazon.awssdk.services.ecs.model.HealthStatus;
import software.amazon.awssdk.services.ecs.model.InferenceAccelerator;
import software.amazon.awssdk.services.ecs.model.InferenceAcceleratorsCopier;
import software.amazon.awssdk.services.ecs.model.LaunchType;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.services.ecs.model.TaskOverride;
import software.amazon.awssdk.services.ecs.model.TaskStopCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Task
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Task> {
    private static final SdkField<List<Attachment>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attachments").getter(Task.getter(Task::attachments)).setter(Task.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributes").getter(Task.getter(Task::attributes)).setter(Task.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(Task.getter(Task::availabilityZone)).setter(Task.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> CAPACITY_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capacityProviderName").getter(Task.getter(Task::capacityProviderName)).setter(Task.setter(Builder::capacityProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderName").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterArn").getter(Task.getter(Task::clusterArn)).setter(Task.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CONNECTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectivity").getter(Task.getter(Task::connectivityAsString)).setter(Task.setter(Builder::connectivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectivity").build()}).build();
    private static final SdkField<Instant> CONNECTIVITY_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("connectivityAt").getter(Task.getter(Task::connectivityAt)).setter(Task.setter(Builder::connectivityAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectivityAt").build()}).build();
    private static final SdkField<String> CONTAINER_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerInstanceArn").getter(Task.getter(Task::containerInstanceArn)).setter(Task.setter(Builder::containerInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstanceArn").build()}).build();
    private static final SdkField<List<Container>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containers").getter(Task.getter(Task::containers)).setter(Task.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Container::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cpu").getter(Task.getter(Task::cpu)).setter(Task.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Task.getter(Task::createdAt)).setter(Task.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DESIRED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("desiredStatus").getter(Task.getter(Task::desiredStatus)).setter(Task.setter(Builder::desiredStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredStatus").build()}).build();
    private static final SdkField<Instant> EXECUTION_STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("executionStoppedAt").getter(Task.getter(Task::executionStoppedAt)).setter(Task.setter(Builder::executionStoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStoppedAt").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("group").getter(Task.getter(Task::group)).setter(Task.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("healthStatus").getter(Task.getter(Task::healthStatusAsString)).setter(Task.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthStatus").build()}).build();
    private static final SdkField<List<InferenceAccelerator>> INFERENCE_ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inferenceAccelerators").getter(Task.getter(Task::inferenceAccelerators)).setter(Task.setter(Builder::inferenceAccelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceAccelerators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InferenceAccelerator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastStatus").getter(Task.getter(Task::lastStatus)).setter(Task.setter(Builder::lastStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchType").getter(Task.getter(Task::launchTypeAsString)).setter(Task.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()}).build();
    private static final SdkField<String> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memory").getter(Task.getter(Task::memory)).setter(Task.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<TaskOverride> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("overrides").getter(Task.getter(Task::overrides)).setter(Task.setter(Builder::overrides)).constructor(TaskOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformVersion").getter(Task.getter(Task::platformVersion)).setter(Task.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<Instant> PULL_STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("pullStartedAt").getter(Task.getter(Task::pullStartedAt)).setter(Task.setter(Builder::pullStartedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullStartedAt").build()}).build();
    private static final SdkField<Instant> PULL_STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("pullStoppedAt").getter(Task.getter(Task::pullStoppedAt)).setter(Task.setter(Builder::pullStoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullStoppedAt").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(Task.getter(Task::startedAt)).setter(Task.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<String> STARTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startedBy").getter(Task.getter(Task::startedBy)).setter(Task.setter(Builder::startedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()}).build();
    private static final SdkField<String> STOP_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stopCode").getter(Task.getter(Task::stopCodeAsString)).setter(Task.setter(Builder::stopCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopCode").build()}).build();
    private static final SdkField<Instant> STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stoppedAt").getter(Task.getter(Task::stoppedAt)).setter(Task.setter(Builder::stoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()}).build();
    private static final SdkField<String> STOPPED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stoppedReason").getter(Task.getter(Task::stoppedReason)).setter(Task.setter(Builder::stoppedReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedReason").build()}).build();
    private static final SdkField<Instant> STOPPING_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stoppingAt").getter(Task.getter(Task::stoppingAt)).setter(Task.setter(Builder::stoppingAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppingAt").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(Task.getter(Task::tags)).setter(Task.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskArn").getter(Task.getter(Task::taskArn)).setter(Task.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskDefinitionArn").getter(Task.getter(Task::taskDefinitionArn)).setter(Task.setter(Builder::taskDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinitionArn").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("version").getter(Task.getter(Task::version)).setter(Task.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENTS_FIELD, ATTRIBUTES_FIELD, AVAILABILITY_ZONE_FIELD, CAPACITY_PROVIDER_NAME_FIELD, CLUSTER_ARN_FIELD, CONNECTIVITY_FIELD, CONNECTIVITY_AT_FIELD, CONTAINER_INSTANCE_ARN_FIELD, CONTAINERS_FIELD, CPU_FIELD, CREATED_AT_FIELD, DESIRED_STATUS_FIELD, EXECUTION_STOPPED_AT_FIELD, GROUP_FIELD, HEALTH_STATUS_FIELD, INFERENCE_ACCELERATORS_FIELD, LAST_STATUS_FIELD, LAUNCH_TYPE_FIELD, MEMORY_FIELD, OVERRIDES_FIELD, PLATFORM_VERSION_FIELD, PULL_STARTED_AT_FIELD, PULL_STOPPED_AT_FIELD, STARTED_AT_FIELD, STARTED_BY_FIELD, STOP_CODE_FIELD, STOPPED_AT_FIELD, STOPPED_REASON_FIELD, STOPPING_AT_FIELD, TAGS_FIELD, TASK_ARN_FIELD, TASK_DEFINITION_ARN_FIELD, VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Attachment> attachments;
    private final List<Attribute> attributes;
    private final String availabilityZone;
    private final String capacityProviderName;
    private final String clusterArn;
    private final String connectivity;
    private final Instant connectivityAt;
    private final String containerInstanceArn;
    private final List<Container> containers;
    private final String cpu;
    private final Instant createdAt;
    private final String desiredStatus;
    private final Instant executionStoppedAt;
    private final String group;
    private final String healthStatus;
    private final List<InferenceAccelerator> inferenceAccelerators;
    private final String lastStatus;
    private final String launchType;
    private final String memory;
    private final TaskOverride overrides;
    private final String platformVersion;
    private final Instant pullStartedAt;
    private final Instant pullStoppedAt;
    private final Instant startedAt;
    private final String startedBy;
    private final String stopCode;
    private final Instant stoppedAt;
    private final String stoppedReason;
    private final Instant stoppingAt;
    private final List<Tag> tags;
    private final String taskArn;
    private final String taskDefinitionArn;
    private final Long version;

    private Task(BuilderImpl builder) {
        this.attachments = builder.attachments;
        this.attributes = builder.attributes;
        this.availabilityZone = builder.availabilityZone;
        this.capacityProviderName = builder.capacityProviderName;
        this.clusterArn = builder.clusterArn;
        this.connectivity = builder.connectivity;
        this.connectivityAt = builder.connectivityAt;
        this.containerInstanceArn = builder.containerInstanceArn;
        this.containers = builder.containers;
        this.cpu = builder.cpu;
        this.createdAt = builder.createdAt;
        this.desiredStatus = builder.desiredStatus;
        this.executionStoppedAt = builder.executionStoppedAt;
        this.group = builder.group;
        this.healthStatus = builder.healthStatus;
        this.inferenceAccelerators = builder.inferenceAccelerators;
        this.lastStatus = builder.lastStatus;
        this.launchType = builder.launchType;
        this.memory = builder.memory;
        this.overrides = builder.overrides;
        this.platformVersion = builder.platformVersion;
        this.pullStartedAt = builder.pullStartedAt;
        this.pullStoppedAt = builder.pullStoppedAt;
        this.startedAt = builder.startedAt;
        this.startedBy = builder.startedBy;
        this.stopCode = builder.stopCode;
        this.stoppedAt = builder.stoppedAt;
        this.stoppedReason = builder.stoppedReason;
        this.stoppingAt = builder.stoppingAt;
        this.tags = builder.tags;
        this.taskArn = builder.taskArn;
        this.taskDefinitionArn = builder.taskDefinitionArn;
        this.version = builder.version;
    }

    public final boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public final List<Attachment> attachments() {
        return this.attachments;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<Attribute> attributes() {
        return this.attributes;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String capacityProviderName() {
        return this.capacityProviderName;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final Connectivity connectivity() {
        return Connectivity.fromValue(this.connectivity);
    }

    public final String connectivityAsString() {
        return this.connectivity;
    }

    public final Instant connectivityAt() {
        return this.connectivityAt;
    }

    public final String containerInstanceArn() {
        return this.containerInstanceArn;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public final List<Container> containers() {
        return this.containers;
    }

    public final String cpu() {
        return this.cpu;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String desiredStatus() {
        return this.desiredStatus;
    }

    public final Instant executionStoppedAt() {
        return this.executionStoppedAt;
    }

    public final String group() {
        return this.group;
    }

    public final HealthStatus healthStatus() {
        return HealthStatus.fromValue(this.healthStatus);
    }

    public final String healthStatusAsString() {
        return this.healthStatus;
    }

    public final boolean hasInferenceAccelerators() {
        return this.inferenceAccelerators != null && !(this.inferenceAccelerators instanceof SdkAutoConstructList);
    }

    public final List<InferenceAccelerator> inferenceAccelerators() {
        return this.inferenceAccelerators;
    }

    public final String lastStatus() {
        return this.lastStatus;
    }

    public final LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public final String launchTypeAsString() {
        return this.launchType;
    }

    public final String memory() {
        return this.memory;
    }

    public final TaskOverride overrides() {
        return this.overrides;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final Instant pullStartedAt() {
        return this.pullStartedAt;
    }

    public final Instant pullStoppedAt() {
        return this.pullStoppedAt;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final String startedBy() {
        return this.startedBy;
    }

    public final TaskStopCode stopCode() {
        return TaskStopCode.fromValue(this.stopCode);
    }

    public final String stopCodeAsString() {
        return this.stopCode;
    }

    public final Instant stoppedAt() {
        return this.stoppedAt;
    }

    public final String stoppedReason() {
        return this.stoppedReason;
    }

    public final Instant stoppingAt() {
        return this.stoppingAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final String taskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public final Long version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments() ? this.attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectivityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectivityAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferenceAccelerators() ? this.inferenceAccelerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullStartedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullStoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Task)) {
            return false;
        }
        Task other = (Task)obj;
        return this.hasAttachments() == other.hasAttachments() && Objects.equals(this.attachments(), other.attachments()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.capacityProviderName(), other.capacityProviderName()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.connectivityAsString(), other.connectivityAsString()) && Objects.equals(this.connectivityAt(), other.connectivityAt()) && Objects.equals(this.containerInstanceArn(), other.containerInstanceArn()) && this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers()) && Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.desiredStatus(), other.desiredStatus()) && Objects.equals(this.executionStoppedAt(), other.executionStoppedAt()) && Objects.equals(this.group(), other.group()) && Objects.equals(this.healthStatusAsString(), other.healthStatusAsString()) && this.hasInferenceAccelerators() == other.hasInferenceAccelerators() && Objects.equals(this.inferenceAccelerators(), other.inferenceAccelerators()) && Objects.equals(this.lastStatus(), other.lastStatus()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.overrides(), other.overrides()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.pullStartedAt(), other.pullStartedAt()) && Objects.equals(this.pullStoppedAt(), other.pullStoppedAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.startedBy(), other.startedBy()) && Objects.equals(this.stopCodeAsString(), other.stopCodeAsString()) && Objects.equals(this.stoppedAt(), other.stoppedAt()) && Objects.equals(this.stoppedReason(), other.stoppedReason()) && Objects.equals(this.stoppingAt(), other.stoppingAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.taskDefinitionArn(), other.taskDefinitionArn()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"Task").add("Attachments", this.hasAttachments() ? this.attachments() : null).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("AvailabilityZone", (Object)this.availabilityZone()).add("CapacityProviderName", (Object)this.capacityProviderName()).add("ClusterArn", (Object)this.clusterArn()).add("Connectivity", (Object)this.connectivityAsString()).add("ConnectivityAt", (Object)this.connectivityAt()).add("ContainerInstanceArn", (Object)this.containerInstanceArn()).add("Containers", this.hasContainers() ? this.containers() : null).add("Cpu", (Object)this.cpu()).add("CreatedAt", (Object)this.createdAt()).add("DesiredStatus", (Object)this.desiredStatus()).add("ExecutionStoppedAt", (Object)this.executionStoppedAt()).add("Group", (Object)this.group()).add("HealthStatus", (Object)this.healthStatusAsString()).add("InferenceAccelerators", this.hasInferenceAccelerators() ? this.inferenceAccelerators() : null).add("LastStatus", (Object)this.lastStatus()).add("LaunchType", (Object)this.launchTypeAsString()).add("Memory", (Object)this.memory()).add("Overrides", (Object)this.overrides()).add("PlatformVersion", (Object)this.platformVersion()).add("PullStartedAt", (Object)this.pullStartedAt()).add("PullStoppedAt", (Object)this.pullStoppedAt()).add("StartedAt", (Object)this.startedAt()).add("StartedBy", (Object)this.startedBy()).add("StopCode", (Object)this.stopCodeAsString()).add("StoppedAt", (Object)this.stoppedAt()).add("StoppedReason", (Object)this.stoppedReason()).add("StoppingAt", (Object)this.stoppingAt()).add("Tags", this.hasTags() ? this.tags() : null).add("TaskArn", (Object)this.taskArn()).add("TaskDefinitionArn", (Object)this.taskDefinitionArn()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "capacityProviderName": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderName()));
            }
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "connectivity": {
                return Optional.ofNullable(clazz.cast(this.connectivityAsString()));
            }
            case "connectivityAt": {
                return Optional.ofNullable(clazz.cast(this.connectivityAt()));
            }
            case "containerInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.containerInstanceArn()));
            }
            case "containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "desiredStatus": {
                return Optional.ofNullable(clazz.cast(this.desiredStatus()));
            }
            case "executionStoppedAt": {
                return Optional.ofNullable(clazz.cast(this.executionStoppedAt()));
            }
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "healthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatusAsString()));
            }
            case "inferenceAccelerators": {
                return Optional.ofNullable(clazz.cast(this.inferenceAccelerators()));
            }
            case "lastStatus": {
                return Optional.ofNullable(clazz.cast(this.lastStatus()));
            }
            case "launchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "pullStartedAt": {
                return Optional.ofNullable(clazz.cast(this.pullStartedAt()));
            }
            case "pullStoppedAt": {
                return Optional.ofNullable(clazz.cast(this.pullStoppedAt()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "startedBy": {
                return Optional.ofNullable(clazz.cast(this.startedBy()));
            }
            case "stopCode": {
                return Optional.ofNullable(clazz.cast(this.stopCodeAsString()));
            }
            case "stoppedAt": {
                return Optional.ofNullable(clazz.cast(this.stoppedAt()));
            }
            case "stoppedReason": {
                return Optional.ofNullable(clazz.cast(this.stoppedReason()));
            }
            case "stoppingAt": {
                return Optional.ofNullable(clazz.cast(this.stoppingAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "taskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "taskDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.taskDefinitionArn()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Task, T> g) {
        return obj -> g.apply((Task)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Attachment> attachments = DefaultSdkAutoConstructList.getInstance();
        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZone;
        private String capacityProviderName;
        private String clusterArn;
        private String connectivity;
        private Instant connectivityAt;
        private String containerInstanceArn;
        private List<Container> containers = DefaultSdkAutoConstructList.getInstance();
        private String cpu;
        private Instant createdAt;
        private String desiredStatus;
        private Instant executionStoppedAt;
        private String group;
        private String healthStatus;
        private List<InferenceAccelerator> inferenceAccelerators = DefaultSdkAutoConstructList.getInstance();
        private String lastStatus;
        private String launchType;
        private String memory;
        private TaskOverride overrides;
        private String platformVersion;
        private Instant pullStartedAt;
        private Instant pullStoppedAt;
        private Instant startedAt;
        private String startedBy;
        private String stopCode;
        private Instant stoppedAt;
        private String stoppedReason;
        private Instant stoppingAt;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String taskArn;
        private String taskDefinitionArn;
        private Long version;

        private BuilderImpl() {
        }

        private BuilderImpl(Task model) {
            this.attachments(model.attachments);
            this.attributes(model.attributes);
            this.availabilityZone(model.availabilityZone);
            this.capacityProviderName(model.capacityProviderName);
            this.clusterArn(model.clusterArn);
            this.connectivity(model.connectivity);
            this.connectivityAt(model.connectivityAt);
            this.containerInstanceArn(model.containerInstanceArn);
            this.containers(model.containers);
            this.cpu(model.cpu);
            this.createdAt(model.createdAt);
            this.desiredStatus(model.desiredStatus);
            this.executionStoppedAt(model.executionStoppedAt);
            this.group(model.group);
            this.healthStatus(model.healthStatus);
            this.inferenceAccelerators(model.inferenceAccelerators);
            this.lastStatus(model.lastStatus);
            this.launchType(model.launchType);
            this.memory(model.memory);
            this.overrides(model.overrides);
            this.platformVersion(model.platformVersion);
            this.pullStartedAt(model.pullStartedAt);
            this.pullStoppedAt(model.pullStoppedAt);
            this.startedAt(model.startedAt);
            this.startedBy(model.startedBy);
            this.stopCode(model.stopCode);
            this.stoppedAt(model.stoppedAt);
            this.stoppedReason(model.stoppedReason);
            this.stoppingAt(model.stoppingAt);
            this.tags(model.tags);
            this.taskArn(model.taskArn);
            this.taskDefinitionArn(model.taskDefinitionArn);
            this.version(model.version);
        }

        public final Collection<Attachment.Builder> getAttachments() {
            if (this.attachments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attachments != null ? (Collection)this.attachments.stream().map(Attachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachments(Collection<Attachment> attachments) {
            this.attachments = AttachmentsCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Attachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<Attachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (Attachment)((Attachment.Builder)Attachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachments(Collection<Attachment.BuilderImpl> attachments) {
            this.attachments = AttachmentsCopier.copyFromBuilder(attachments);
        }

        public final Collection<Attribute.Builder> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributes != null ? (Collection)this.attributes.stream().map(Attribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributesCopier.copyFromBuilder(attributes);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getCapacityProviderName() {
            return this.capacityProviderName;
        }

        @Override
        public final Builder capacityProviderName(String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
            return this;
        }

        public final void setCapacityProviderName(String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final String getConnectivity() {
            return this.connectivity;
        }

        @Override
        public final Builder connectivity(String connectivity) {
            this.connectivity = connectivity;
            return this;
        }

        @Override
        public final Builder connectivity(Connectivity connectivity) {
            this.connectivity(connectivity == null ? null : connectivity.toString());
            return this;
        }

        public final void setConnectivity(String connectivity) {
            this.connectivity = connectivity;
        }

        public final Instant getConnectivityAt() {
            return this.connectivityAt;
        }

        @Override
        public final Builder connectivityAt(Instant connectivityAt) {
            this.connectivityAt = connectivityAt;
            return this;
        }

        public final void setConnectivityAt(Instant connectivityAt) {
            this.connectivityAt = connectivityAt;
        }

        public final String getContainerInstanceArn() {
            return this.containerInstanceArn;
        }

        @Override
        public final Builder containerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
            return this;
        }

        public final void setContainerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
        }

        public final Collection<Container.Builder> getContainers() {
            if (this.containers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containers != null ? (Collection)this.containers.stream().map(Container::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder containers(Collection<Container> containers) {
            this.containers = ContainersCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Container ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<Container.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (Container)((Container.Builder)Container.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContainers(Collection<Container.BuilderImpl> containers) {
            this.containers = ContainersCopier.copyFromBuilder(containers);
        }

        public final String getCpu() {
            return this.cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDesiredStatus() {
            return this.desiredStatus;
        }

        @Override
        public final Builder desiredStatus(String desiredStatus) {
            this.desiredStatus = desiredStatus;
            return this;
        }

        public final void setDesiredStatus(String desiredStatus) {
            this.desiredStatus = desiredStatus;
        }

        public final Instant getExecutionStoppedAt() {
            return this.executionStoppedAt;
        }

        @Override
        public final Builder executionStoppedAt(Instant executionStoppedAt) {
            this.executionStoppedAt = executionStoppedAt;
            return this;
        }

        public final void setExecutionStoppedAt(Instant executionStoppedAt) {
            this.executionStoppedAt = executionStoppedAt;
        }

        public final String getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(HealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final Collection<InferenceAccelerator.Builder> getInferenceAccelerators() {
            if (this.inferenceAccelerators instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inferenceAccelerators != null ? (Collection)this.inferenceAccelerators.stream().map(InferenceAccelerator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inferenceAccelerators(Collection<InferenceAccelerator> inferenceAccelerators) {
            this.inferenceAccelerators = InferenceAcceleratorsCopier.copy(inferenceAccelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAccelerators(InferenceAccelerator ... inferenceAccelerators) {
            this.inferenceAccelerators(Arrays.asList(inferenceAccelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAccelerators(Consumer<InferenceAccelerator.Builder> ... inferenceAccelerators) {
            this.inferenceAccelerators(Stream.of(inferenceAccelerators).map(c -> (InferenceAccelerator)((InferenceAccelerator.Builder)InferenceAccelerator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInferenceAccelerators(Collection<InferenceAccelerator.BuilderImpl> inferenceAccelerators) {
            this.inferenceAccelerators = InferenceAcceleratorsCopier.copyFromBuilder(inferenceAccelerators);
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final String getLaunchType() {
            return this.launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        public final String getMemory() {
            return this.memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        public final TaskOverride.Builder getOverrides() {
            return this.overrides != null ? this.overrides.toBuilder() : null;
        }

        @Override
        public final Builder overrides(TaskOverride overrides) {
            this.overrides = overrides;
            return this;
        }

        public final void setOverrides(TaskOverride.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final Instant getPullStartedAt() {
            return this.pullStartedAt;
        }

        @Override
        public final Builder pullStartedAt(Instant pullStartedAt) {
            this.pullStartedAt = pullStartedAt;
            return this;
        }

        public final void setPullStartedAt(Instant pullStartedAt) {
            this.pullStartedAt = pullStartedAt;
        }

        public final Instant getPullStoppedAt() {
            return this.pullStoppedAt;
        }

        @Override
        public final Builder pullStoppedAt(Instant pullStoppedAt) {
            this.pullStoppedAt = pullStoppedAt;
            return this;
        }

        public final void setPullStoppedAt(Instant pullStoppedAt) {
            this.pullStoppedAt = pullStoppedAt;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        public final String getStartedBy() {
            return this.startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        public final String getStopCode() {
            return this.stopCode;
        }

        @Override
        public final Builder stopCode(String stopCode) {
            this.stopCode = stopCode;
            return this;
        }

        @Override
        public final Builder stopCode(TaskStopCode stopCode) {
            this.stopCode(stopCode == null ? null : stopCode.toString());
            return this;
        }

        public final void setStopCode(String stopCode) {
            this.stopCode = stopCode;
        }

        public final Instant getStoppedAt() {
            return this.stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Instant stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final void setStoppedAt(Instant stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        public final String getStoppedReason() {
            return this.stoppedReason;
        }

        @Override
        public final Builder stoppedReason(String stoppedReason) {
            this.stoppedReason = stoppedReason;
            return this;
        }

        public final void setStoppedReason(String stoppedReason) {
            this.stoppedReason = stoppedReason;
        }

        public final Instant getStoppingAt() {
            return this.stoppingAt;
        }

        @Override
        public final Builder stoppingAt(Instant stoppingAt) {
            this.stoppingAt = stoppingAt;
            return this;
        }

        public final void setStoppingAt(Instant stoppingAt) {
            this.stoppingAt = stoppingAt;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getTaskDefinitionArn() {
            return this.taskDefinitionArn;
        }

        @Override
        public final Builder taskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
            return this;
        }

        public final void setTaskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
        }

        public final Long getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public Task build() {
            return new Task(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Task> {
        public Builder attachments(Collection<Attachment> var1);

        public Builder attachments(Attachment ... var1);

        public Builder attachments(Consumer<Attachment.Builder> ... var1);

        public Builder attributes(Collection<Attribute> var1);

        public Builder attributes(Attribute ... var1);

        public Builder attributes(Consumer<Attribute.Builder> ... var1);

        public Builder availabilityZone(String var1);

        public Builder capacityProviderName(String var1);

        public Builder clusterArn(String var1);

        public Builder connectivity(String var1);

        public Builder connectivity(Connectivity var1);

        public Builder connectivityAt(Instant var1);

        public Builder containerInstanceArn(String var1);

        public Builder containers(Collection<Container> var1);

        public Builder containers(Container ... var1);

        public Builder containers(Consumer<Container.Builder> ... var1);

        public Builder cpu(String var1);

        public Builder createdAt(Instant var1);

        public Builder desiredStatus(String var1);

        public Builder executionStoppedAt(Instant var1);

        public Builder group(String var1);

        public Builder healthStatus(String var1);

        public Builder healthStatus(HealthStatus var1);

        public Builder inferenceAccelerators(Collection<InferenceAccelerator> var1);

        public Builder inferenceAccelerators(InferenceAccelerator ... var1);

        public Builder inferenceAccelerators(Consumer<InferenceAccelerator.Builder> ... var1);

        public Builder lastStatus(String var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder memory(String var1);

        public Builder overrides(TaskOverride var1);

        default public Builder overrides(Consumer<TaskOverride.Builder> overrides) {
            return this.overrides((TaskOverride)((TaskOverride.Builder)TaskOverride.builder().applyMutation(overrides)).build());
        }

        public Builder platformVersion(String var1);

        public Builder pullStartedAt(Instant var1);

        public Builder pullStoppedAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder startedBy(String var1);

        public Builder stopCode(String var1);

        public Builder stopCode(TaskStopCode var1);

        public Builder stoppedAt(Instant var1);

        public Builder stoppedReason(String var1);

        public Builder stoppingAt(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder taskArn(String var1);

        public Builder taskDefinitionArn(String var1);

        public Builder version(Long var1);
    }
}

