/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceRequest extends EcsRequest implements
        ToCopyableBuilder<UpdateServiceRequest.Builder, UpdateServiceRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(UpdateServiceRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("service")
            .getter(getter(UpdateServiceRequest::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<Integer> DESIRED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("desiredCount").getter(getter(UpdateServiceRequest::desiredCount)).setter(setter(Builder::desiredCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCount").build()).build();

    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskDefinition").getter(getter(UpdateServiceRequest::taskDefinition))
            .setter(setter(Builder::taskDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()).build();

    private static final SdkField<List<CapacityProviderStrategyItem>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField
            .<List<CapacityProviderStrategyItem>> builder(MarshallingType.LIST)
            .memberName("capacityProviderStrategy")
            .getter(getter(UpdateServiceRequest::capacityProviderStrategy))
            .setter(setter(Builder::capacityProviderStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderStrategy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapacityProviderStrategyItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityProviderStrategyItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<DeploymentConfiguration> builder(MarshallingType.SDK_POJO).memberName("deploymentConfiguration")
            .getter(getter(UpdateServiceRequest::deploymentConfiguration)).setter(setter(Builder::deploymentConfiguration))
            .constructor(DeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build())
            .build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(UpdateServiceRequest::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<List<PlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField
            .<List<PlacementConstraint>> builder(MarshallingType.LIST)
            .memberName("placementConstraints")
            .getter(getter(UpdateServiceRequest::placementConstraints))
            .setter(setter(Builder::placementConstraints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementConstraint> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementConstraint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PlacementStrategy>> PLACEMENT_STRATEGY_FIELD = SdkField
            .<List<PlacementStrategy>> builder(MarshallingType.LIST)
            .memberName("placementStrategy")
            .getter(getter(UpdateServiceRequest::placementStrategy))
            .setter(setter(Builder::placementStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementStrategy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementStrategy> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementStrategy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformVersion").getter(getter(UpdateServiceRequest::platformVersion))
            .setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()).build();

    private static final SdkField<Boolean> FORCE_NEW_DEPLOYMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("forceNewDeployment").getter(getter(UpdateServiceRequest::forceNewDeployment))
            .setter(setter(Builder::forceNewDeployment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceNewDeployment").build())
            .build();

    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("healthCheckGracePeriodSeconds")
            .getter(getter(UpdateServiceRequest::healthCheckGracePeriodSeconds))
            .setter(setter(Builder::healthCheckGracePeriodSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckGracePeriodSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, SERVICE_FIELD,
            DESIRED_COUNT_FIELD, TASK_DEFINITION_FIELD, CAPACITY_PROVIDER_STRATEGY_FIELD, DEPLOYMENT_CONFIGURATION_FIELD,
            NETWORK_CONFIGURATION_FIELD, PLACEMENT_CONSTRAINTS_FIELD, PLACEMENT_STRATEGY_FIELD, PLATFORM_VERSION_FIELD,
            FORCE_NEW_DEPLOYMENT_FIELD, HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD));

    private final String cluster;

    private final String service;

    private final Integer desiredCount;

    private final String taskDefinition;

    private final List<CapacityProviderStrategyItem> capacityProviderStrategy;

    private final DeploymentConfiguration deploymentConfiguration;

    private final NetworkConfiguration networkConfiguration;

    private final List<PlacementConstraint> placementConstraints;

    private final List<PlacementStrategy> placementStrategy;

    private final String platformVersion;

    private final Boolean forceNewDeployment;

    private final Integer healthCheckGracePeriodSeconds;

    private UpdateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.service = builder.service;
        this.desiredCount = builder.desiredCount;
        this.taskDefinition = builder.taskDefinition;
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.networkConfiguration = builder.networkConfiguration;
        this.placementConstraints = builder.placementConstraints;
        this.placementStrategy = builder.placementStrategy;
        this.platformVersion = builder.platformVersion;
        this.forceNewDeployment = builder.forceNewDeployment;
        this.healthCheckGracePeriodSeconds = builder.healthCheckGracePeriodSeconds;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that your service is running on. If you do not
     * specify a cluster, the default cluster is assumed.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that your service is running on. If you
     *         do not specify a cluster, the default cluster is assumed.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The name of the service to update.
     * </p>
     * 
     * @return The name of the service to update.
     */
    public final String service() {
        return service;
    }

    /**
     * <p>
     * The number of instantiations of the task to place and keep running in your service.
     * </p>
     * 
     * @return The number of instantiations of the task to place and keep running in your service.
     */
    public final Integer desiredCount() {
        return desiredCount;
    }

    /**
     * <p>
     * The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task
     * definition to run in your service. If a <code>revision</code> is not specified, the latest <code>ACTIVE</code>
     * revision is used. If you modify the task definition with <code>UpdateService</code>, Amazon ECS spawns a task
     * with the new version of the task definition and then stops an old task after the new version is running.
     * </p>
     * 
     * @return The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task
     *         definition to run in your service. If a <code>revision</code> is not specified, the latest
     *         <code>ACTIVE</code> revision is used. If you modify the task definition with <code>UpdateService</code>,
     *         Amazon ECS spawns a task with the new version of the task definition and then stops an old task after the
     *         new version is running.
     */
    public final String taskDefinition() {
        return taskDefinition;
    }

    /**
     * Returns true if the CapacityProviderStrategy property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCapacityProviderStrategy() {
        return capacityProviderStrategy != null && !(capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capacity provider strategy to update the service to use.
     * </p>
     * <p>
     * If the service is using the default capacity provider strategy for the cluster, the service can be updated to use
     * one or more capacity providers as opposed to the default capacity provider strategy. However, when a service is
     * using a capacity provider strategy that is not the default capacity provider strategy, the service cannot be
     * updated to use the cluster's default capacity provider strategy.
     * </p>
     * <p>
     * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and
     * <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a
     * capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a capacity provider
     * with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
     * </p>
     * <p>
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created.
     * New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
     * </p>
     * <p>
     * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
     * capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be
     * associated with a cluster to be used.
     * </p>
     * <p>
     * The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity providers
     * for a cluster after the cluster is created.
     * </p>
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCapacityProviderStrategy()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The capacity provider strategy to update the service to use.</p>
     *         <p>
     *         If the service is using the default capacity provider strategy for the cluster, the service can be
     *         updated to use one or more capacity providers as opposed to the default capacity provider strategy.
     *         However, when a service is using a capacity provider strategy that is not the default capacity provider
     *         strategy, the service cannot be updated to use the cluster's default capacity provider strategy.
     *         </p>
     *         <p>
     *         A capacity provider strategy consists of one or more capacity providers along with the <code>base</code>
     *         and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be
     *         used in a capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a
     *         capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or
     *         <code>UPDATING</code> status can be used.
     *         </p>
     *         <p>
     *         If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
     *         created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
     *         </p>
     *         <p>
     *         To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or
     *         <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all
     *         accounts and only need to be associated with a cluster to be used.
     *         </p>
     *         <p>
     *         The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
     *         providers for a cluster after the cluster is created.
     *         </p>
     */
    public final List<CapacityProviderStrategyItem> capacityProviderStrategy() {
        return capacityProviderStrategy;
    }

    /**
     * <p>
     * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping
     * and starting tasks.
     * </p>
     * 
     * @return Optional deployment parameters that control how many tasks run during the deployment and the ordering of
     *         stopping and starting tasks.
     */
    public final DeploymentConfiguration deploymentConfiguration() {
        return deploymentConfiguration;
    }

    /**
     * Returns the value of the NetworkConfiguration property for this object.
     * 
     * @return The value of the NetworkConfiguration property for this object.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * Returns true if the PlacementConstraints property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPlacementConstraints() {
        return placementConstraints != null && !(placementConstraints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of task placement constraint objects to update the service to use. If no value is specified, the
     * existing placement constraints for the service will remain unchanged. If this value is specified, it will
     * override any existing placement constraints defined for the service. To remove all existing placement
     * constraints, specify an empty array.
     * </p>
     * <p>
     * You can specify a maximum of 10 constraints per task (this limit includes constraints in the task definition and
     * those specified at runtime).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPlacementConstraints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of task placement constraint objects to update the service to use. If no value is specified, the
     *         existing placement constraints for the service will remain unchanged. If this value is specified, it will
     *         override any existing placement constraints defined for the service. To remove all existing placement
     *         constraints, specify an empty array.</p>
     *         <p>
     *         You can specify a maximum of 10 constraints per task (this limit includes constraints in the task
     *         definition and those specified at runtime).
     */
    public final List<PlacementConstraint> placementConstraints() {
        return placementConstraints;
    }

    /**
     * Returns true if the PlacementStrategy property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPlacementStrategy() {
        return placementStrategy != null && !(placementStrategy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The task placement strategy objects to update the service to use. If no value is specified, the existing
     * placement strategy for the service will remain unchanged. If this value is specified, it will override the
     * existing placement strategy defined for the service. To remove an existing placement strategy, specify an empty
     * object.
     * </p>
     * <p>
     * You can specify a maximum of five strategy rules per service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPlacementStrategy()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The task placement strategy objects to update the service to use. If no value is specified, the existing
     *         placement strategy for the service will remain unchanged. If this value is specified, it will override
     *         the existing placement strategy defined for the service. To remove an existing placement strategy,
     *         specify an empty object.</p>
     *         <p>
     *         You can specify a maximum of five strategy rules per service.
     */
    public final List<PlacementStrategy> placementStrategy() {
        return placementStrategy;
    }

    /**
     * <p>
     * The platform version on which your tasks in the service are running. A platform version is only specified for
     * tasks using the Fargate launch type. If a platform version is not specified, the <code>LATEST</code> platform
     * version is used by default. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform
     * Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The platform version on which your tasks in the service are running. A platform version is only specified
     *         for tasks using the Fargate launch type. If a platform version is not specified, the <code>LATEST</code>
     *         platform version is used by default. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate
     *         Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * Whether to force a new deployment of the service. Deployments are not forced by default. You can use this option
     * to trigger a new deployment with no service definition changes. For example, you can update a service's tasks to
     * use a newer Docker image with the same image/tag combination (<code>my_image:latest</code>) or to roll Fargate
     * tasks onto a newer platform version.
     * </p>
     * 
     * @return Whether to force a new deployment of the service. Deployments are not forced by default. You can use this
     *         option to trigger a new deployment with no service definition changes. For example, you can update a
     *         service's tasks to use a newer Docker image with the same image/tag combination (
     *         <code>my_image:latest</code>) or to roll Fargate tasks onto a newer platform version.
     */
    public final Boolean forceNewDeployment() {
        return forceNewDeployment;
    }

    /**
     * <p>
     * The period of time, in seconds, that the Amazon ECS service scheduler should ignore unhealthy Elastic Load
     * Balancing target health checks after a task has first started. This is only valid if your service is configured
     * to use a load balancer. If your service's tasks take a while to start and respond to Elastic Load Balancing
     * health checks, you can specify a health check grace period of up to 2,147,483,647 seconds. During that time, the
     * Amazon ECS service scheduler ignores the Elastic Load Balancing health check status. This grace period can
     * prevent the ECS service scheduler from marking tasks as unhealthy and stopping them before they have time to come
     * up.
     * </p>
     * 
     * @return The period of time, in seconds, that the Amazon ECS service scheduler should ignore unhealthy Elastic
     *         Load Balancing target health checks after a task has first started. This is only valid if your service is
     *         configured to use a load balancer. If your service's tasks take a while to start and respond to Elastic
     *         Load Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds.
     *         During that time, the Amazon ECS service scheduler ignores the Elastic Load Balancing health check
     *         status. This grace period can prevent the ECS service scheduler from marking tasks as unhealthy and
     *         stopping them before they have time to come up.
     */
    public final Integer healthCheckGracePeriodSeconds() {
        return healthCheckGracePeriodSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityProviderStrategy() ? capacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementConstraints() ? placementConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementStrategy() ? placementStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(forceNewDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckGracePeriodSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceRequest)) {
            return false;
        }
        UpdateServiceRequest other = (UpdateServiceRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(service(), other.service())
                && Objects.equals(desiredCount(), other.desiredCount())
                && Objects.equals(taskDefinition(), other.taskDefinition())
                && hasCapacityProviderStrategy() == other.hasCapacityProviderStrategy()
                && Objects.equals(capacityProviderStrategy(), other.capacityProviderStrategy())
                && Objects.equals(deploymentConfiguration(), other.deploymentConfiguration())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && hasPlacementConstraints() == other.hasPlacementConstraints()
                && Objects.equals(placementConstraints(), other.placementConstraints())
                && hasPlacementStrategy() == other.hasPlacementStrategy()
                && Objects.equals(placementStrategy(), other.placementStrategy())
                && Objects.equals(platformVersion(), other.platformVersion())
                && Objects.equals(forceNewDeployment(), other.forceNewDeployment())
                && Objects.equals(healthCheckGracePeriodSeconds(), other.healthCheckGracePeriodSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceRequest").add("Cluster", cluster()).add("Service", service())
                .add("DesiredCount", desiredCount()).add("TaskDefinition", taskDefinition())
                .add("CapacityProviderStrategy", hasCapacityProviderStrategy() ? capacityProviderStrategy() : null)
                .add("DeploymentConfiguration", deploymentConfiguration()).add("NetworkConfiguration", networkConfiguration())
                .add("PlacementConstraints", hasPlacementConstraints() ? placementConstraints() : null)
                .add("PlacementStrategy", hasPlacementStrategy() ? placementStrategy() : null)
                .add("PlatformVersion", platformVersion()).add("ForceNewDeployment", forceNewDeployment())
                .add("HealthCheckGracePeriodSeconds", healthCheckGracePeriodSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        case "desiredCount":
            return Optional.ofNullable(clazz.cast(desiredCount()));
        case "taskDefinition":
            return Optional.ofNullable(clazz.cast(taskDefinition()));
        case "capacityProviderStrategy":
            return Optional.ofNullable(clazz.cast(capacityProviderStrategy()));
        case "deploymentConfiguration":
            return Optional.ofNullable(clazz.cast(deploymentConfiguration()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "placementConstraints":
            return Optional.ofNullable(clazz.cast(placementConstraints()));
        case "placementStrategy":
            return Optional.ofNullable(clazz.cast(placementStrategy()));
        case "platformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "forceNewDeployment":
            return Optional.ofNullable(clazz.cast(forceNewDeployment()));
        case "healthCheckGracePeriodSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckGracePeriodSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceRequest, T> g) {
        return obj -> g.apply((UpdateServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServiceRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that your service is running on. If you do
         * not specify a cluster, the default cluster is assumed.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that your service is running on. If
         *        you do not specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The name of the service to update.
         * </p>
         * 
         * @param service
         *        The name of the service to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * The number of instantiations of the task to place and keep running in your service.
         * </p>
         * 
         * @param desiredCount
         *        The number of instantiations of the task to place and keep running in your service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCount(Integer desiredCount);

        /**
         * <p>
         * The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task
         * definition to run in your service. If a <code>revision</code> is not specified, the latest
         * <code>ACTIVE</code> revision is used. If you modify the task definition with <code>UpdateService</code>,
         * Amazon ECS spawns a task with the new version of the task definition and then stops an old task after the new
         * version is running.
         * </p>
         * 
         * @param taskDefinition
         *        The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the
         *        task definition to run in your service. If a <code>revision</code> is not specified, the latest
         *        <code>ACTIVE</code> revision is used. If you modify the task definition with
         *        <code>UpdateService</code>, Amazon ECS spawns a task with the new version of the task definition and
         *        then stops an old task after the new version is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinition(String taskDefinition);

        /**
         * <p>
         * The capacity provider strategy to update the service to use.
         * </p>
         * <p>
         * If the service is using the default capacity provider strategy for the cluster, the service can be updated to
         * use one or more capacity providers as opposed to the default capacity provider strategy. However, when a
         * service is using a capacity provider strategy that is not the default capacity provider strategy, the service
         * cannot be updated to use the cluster's default capacity provider strategy.
         * </p>
         * <p>
         * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and
         * <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in
         * a capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a capacity
         * provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status
         * can be used.
         * </p>
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
         * created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
         * </p>
         * <p>
         * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
         * capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be
         * associated with a cluster to be used.
         * </p>
         * <p>
         * The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
         * providers for a cluster after the cluster is created.
         * </p>
         * <p/>
         * 
         * @param capacityProviderStrategy
         *        The capacity provider strategy to update the service to use.
         *        </p>
         *        <p>
         *        If the service is using the default capacity provider strategy for the cluster, the service can be
         *        updated to use one or more capacity providers as opposed to the default capacity provider strategy.
         *        However, when a service is using a capacity provider strategy that is not the default capacity
         *        provider strategy, the service cannot be updated to use the cluster's default capacity provider
         *        strategy.
         *        </p>
         *        <p>
         *        A capacity provider strategy consists of one or more capacity providers along with the
         *        <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated
         *        with the cluster to be used in a capacity provider strategy. The <a>PutClusterCapacityProviders</a>
         *        API is used to associate a capacity provider with a cluster. Only capacity providers with an
         *        <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
         *        </p>
         *        <p>
         *        If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already
         *        be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API
         *        operation.
         *        </p>
         *        <p>
         *        To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or
         *        <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all
         *        accounts and only need to be associated with a cluster to be used.
         *        </p>
         *        <p>
         *        The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
         *        providers for a cluster after the cluster is created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy);

        /**
         * <p>
         * The capacity provider strategy to update the service to use.
         * </p>
         * <p>
         * If the service is using the default capacity provider strategy for the cluster, the service can be updated to
         * use one or more capacity providers as opposed to the default capacity provider strategy. However, when a
         * service is using a capacity provider strategy that is not the default capacity provider strategy, the service
         * cannot be updated to use the cluster's default capacity provider strategy.
         * </p>
         * <p>
         * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and
         * <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in
         * a capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a capacity
         * provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status
         * can be used.
         * </p>
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
         * created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
         * </p>
         * <p>
         * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
         * capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be
         * associated with a cluster to be used.
         * </p>
         * <p>
         * The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
         * providers for a cluster after the cluster is created.
         * </p>
         * <p/>
         * 
         * @param capacityProviderStrategy
         *        The capacity provider strategy to update the service to use.
         *        </p>
         *        <p>
         *        If the service is using the default capacity provider strategy for the cluster, the service can be
         *        updated to use one or more capacity providers as opposed to the default capacity provider strategy.
         *        However, when a service is using a capacity provider strategy that is not the default capacity
         *        provider strategy, the service cannot be updated to use the cluster's default capacity provider
         *        strategy.
         *        </p>
         *        <p>
         *        A capacity provider strategy consists of one or more capacity providers along with the
         *        <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated
         *        with the cluster to be used in a capacity provider strategy. The <a>PutClusterCapacityProviders</a>
         *        API is used to associate a capacity provider with a cluster. Only capacity providers with an
         *        <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
         *        </p>
         *        <p>
         *        If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already
         *        be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API
         *        operation.
         *        </p>
         *        <p>
         *        To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or
         *        <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all
         *        accounts and only need to be associated with a cluster to be used.
         *        </p>
         *        <p>
         *        The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
         *        providers for a cluster after the cluster is created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderStrategy(CapacityProviderStrategyItem... capacityProviderStrategy);

        /**
         * <p>
         * The capacity provider strategy to update the service to use.
         * </p>
         * <p>
         * If the service is using the default capacity provider strategy for the cluster, the service can be updated to
         * use one or more capacity providers as opposed to the default capacity provider strategy. However, when a
         * service is using a capacity provider strategy that is not the default capacity provider strategy, the service
         * cannot be updated to use the cluster's default capacity provider strategy.
         * </p>
         * <p>
         * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and
         * <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in
         * a capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a capacity
         * provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status
         * can be used.
         * </p>
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
         * created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
         * </p>
         * <p>
         * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
         * capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be
         * associated with a cluster to be used.
         * </p>
         * <p>
         * The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
         * providers for a cluster after the cluster is created.
         * </p>
         * <p/>
         * This is a convenience that creates an instance of the {@link List<CapacityProviderStrategyItem>.Builder}
         * avoiding the need to create one manually via {@link List<CapacityProviderStrategyItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CapacityProviderStrategyItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #capacityProviderStrategy(List<CapacityProviderStrategyItem>)}.
         * 
         * @param capacityProviderStrategy
         *        a consumer that will call methods on {@link List<CapacityProviderStrategyItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityProviderStrategy(List<CapacityProviderStrategyItem>)
         */
        Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder>... capacityProviderStrategy);

        /**
         * <p>
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of
         * stopping and starting tasks.
         * </p>
         * 
         * @param deploymentConfiguration
         *        Optional deployment parameters that control how many tasks run during the deployment and the ordering
         *        of stopping and starting tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration);

        /**
         * <p>
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of
         * stopping and starting tasks.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentConfiguration.Builder} avoiding the
         * need to create one manually via {@link DeploymentConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #deploymentConfiguration(DeploymentConfiguration)}.
         * 
         * @param deploymentConfiguration
         *        a consumer that will call methods on {@link DeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfiguration(DeploymentConfiguration)
         */
        default Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return deploymentConfiguration(DeploymentConfiguration.builder().applyMutation(deploymentConfiguration).build());
        }

        /**
         * Sets the value of the NetworkConfiguration property for this object.
         *
         * @param networkConfiguration
         *        The new value for the NetworkConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * Sets the value of the NetworkConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link NetworkConfiguration.Builder} avoiding the need
         * to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * An array of task placement constraint objects to update the service to use. If no value is specified, the
         * existing placement constraints for the service will remain unchanged. If this value is specified, it will
         * override any existing placement constraints defined for the service. To remove all existing placement
         * constraints, specify an empty array.
         * </p>
         * <p>
         * You can specify a maximum of 10 constraints per task (this limit includes constraints in the task definition
         * and those specified at runtime).
         * </p>
         * 
         * @param placementConstraints
         *        An array of task placement constraint objects to update the service to use. If no value is specified,
         *        the existing placement constraints for the service will remain unchanged. If this value is specified,
         *        it will override any existing placement constraints defined for the service. To remove all existing
         *        placement constraints, specify an empty array.</p>
         *        <p>
         *        You can specify a maximum of 10 constraints per task (this limit includes constraints in the task
         *        definition and those specified at runtime).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(Collection<PlacementConstraint> placementConstraints);

        /**
         * <p>
         * An array of task placement constraint objects to update the service to use. If no value is specified, the
         * existing placement constraints for the service will remain unchanged. If this value is specified, it will
         * override any existing placement constraints defined for the service. To remove all existing placement
         * constraints, specify an empty array.
         * </p>
         * <p>
         * You can specify a maximum of 10 constraints per task (this limit includes constraints in the task definition
         * and those specified at runtime).
         * </p>
         * 
         * @param placementConstraints
         *        An array of task placement constraint objects to update the service to use. If no value is specified,
         *        the existing placement constraints for the service will remain unchanged. If this value is specified,
         *        it will override any existing placement constraints defined for the service. To remove all existing
         *        placement constraints, specify an empty array.</p>
         *        <p>
         *        You can specify a maximum of 10 constraints per task (this limit includes constraints in the task
         *        definition and those specified at runtime).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(PlacementConstraint... placementConstraints);

        /**
         * <p>
         * An array of task placement constraint objects to update the service to use. If no value is specified, the
         * existing placement constraints for the service will remain unchanged. If this value is specified, it will
         * override any existing placement constraints defined for the service. To remove all existing placement
         * constraints, specify an empty array.
         * </p>
         * <p>
         * You can specify a maximum of 10 constraints per task (this limit includes constraints in the task definition
         * and those specified at runtime).
         * </p>
         * This is a convenience that creates an instance of the {@link List<PlacementConstraint>.Builder} avoiding the
         * need to create one manually via {@link List<PlacementConstraint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PlacementConstraint>.Builder#build()} is called immediately
         * and its result is passed to {@link #placementConstraints(List<PlacementConstraint>)}.
         * 
         * @param placementConstraints
         *        a consumer that will call methods on {@link List<PlacementConstraint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementConstraints(List<PlacementConstraint>)
         */
        Builder placementConstraints(Consumer<PlacementConstraint.Builder>... placementConstraints);

        /**
         * <p>
         * The task placement strategy objects to update the service to use. If no value is specified, the existing
         * placement strategy for the service will remain unchanged. If this value is specified, it will override the
         * existing placement strategy defined for the service. To remove an existing placement strategy, specify an
         * empty object.
         * </p>
         * <p>
         * You can specify a maximum of five strategy rules per service.
         * </p>
         * 
         * @param placementStrategy
         *        The task placement strategy objects to update the service to use. If no value is specified, the
         *        existing placement strategy for the service will remain unchanged. If this value is specified, it will
         *        override the existing placement strategy defined for the service. To remove an existing placement
         *        strategy, specify an empty object.</p>
         *        <p>
         *        You can specify a maximum of five strategy rules per service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStrategy(Collection<PlacementStrategy> placementStrategy);

        /**
         * <p>
         * The task placement strategy objects to update the service to use. If no value is specified, the existing
         * placement strategy for the service will remain unchanged. If this value is specified, it will override the
         * existing placement strategy defined for the service. To remove an existing placement strategy, specify an
         * empty object.
         * </p>
         * <p>
         * You can specify a maximum of five strategy rules per service.
         * </p>
         * 
         * @param placementStrategy
         *        The task placement strategy objects to update the service to use. If no value is specified, the
         *        existing placement strategy for the service will remain unchanged. If this value is specified, it will
         *        override the existing placement strategy defined for the service. To remove an existing placement
         *        strategy, specify an empty object.</p>
         *        <p>
         *        You can specify a maximum of five strategy rules per service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStrategy(PlacementStrategy... placementStrategy);

        /**
         * <p>
         * The task placement strategy objects to update the service to use. If no value is specified, the existing
         * placement strategy for the service will remain unchanged. If this value is specified, it will override the
         * existing placement strategy defined for the service. To remove an existing placement strategy, specify an
         * empty object.
         * </p>
         * <p>
         * You can specify a maximum of five strategy rules per service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PlacementStrategy>.Builder} avoiding the
         * need to create one manually via {@link List<PlacementStrategy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PlacementStrategy>.Builder#build()} is called immediately
         * and its result is passed to {@link #placementStrategy(List<PlacementStrategy>)}.
         * 
         * @param placementStrategy
         *        a consumer that will call methods on {@link List<PlacementStrategy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementStrategy(List<PlacementStrategy>)
         */
        Builder placementStrategy(Consumer<PlacementStrategy.Builder>... placementStrategy);

        /**
         * <p>
         * The platform version on which your tasks in the service are running. A platform version is only specified for
         * tasks using the Fargate launch type. If a platform version is not specified, the <code>LATEST</code> platform
         * version is used by default. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate
         * Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param platformVersion
         *        The platform version on which your tasks in the service are running. A platform version is only
         *        specified for tasks using the Fargate launch type. If a platform version is not specified, the
         *        <code>LATEST</code> platform version is used by default. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate
         *        Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * Whether to force a new deployment of the service. Deployments are not forced by default. You can use this
         * option to trigger a new deployment with no service definition changes. For example, you can update a
         * service's tasks to use a newer Docker image with the same image/tag combination (<code>my_image:latest</code>
         * ) or to roll Fargate tasks onto a newer platform version.
         * </p>
         * 
         * @param forceNewDeployment
         *        Whether to force a new deployment of the service. Deployments are not forced by default. You can use
         *        this option to trigger a new deployment with no service definition changes. For example, you can
         *        update a service's tasks to use a newer Docker image with the same image/tag combination (
         *        <code>my_image:latest</code>) or to roll Fargate tasks onto a newer platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceNewDeployment(Boolean forceNewDeployment);

        /**
         * <p>
         * The period of time, in seconds, that the Amazon ECS service scheduler should ignore unhealthy Elastic Load
         * Balancing target health checks after a task has first started. This is only valid if your service is
         * configured to use a load balancer. If your service's tasks take a while to start and respond to Elastic Load
         * Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds. During
         * that time, the Amazon ECS service scheduler ignores the Elastic Load Balancing health check status. This
         * grace period can prevent the ECS service scheduler from marking tasks as unhealthy and stopping them before
         * they have time to come up.
         * </p>
         * 
         * @param healthCheckGracePeriodSeconds
         *        The period of time, in seconds, that the Amazon ECS service scheduler should ignore unhealthy Elastic
         *        Load Balancing target health checks after a task has first started. This is only valid if your service
         *        is configured to use a load balancer. If your service's tasks take a while to start and respond to
         *        Elastic Load Balancing health checks, you can specify a health check grace period of up to
         *        2,147,483,647 seconds. During that time, the Amazon ECS service scheduler ignores the Elastic Load
         *        Balancing health check status. This grace period can prevent the ECS service scheduler from marking
         *        tasks as unhealthy and stopping them before they have time to come up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String service;

        private Integer desiredCount;

        private String taskDefinition;

        private List<CapacityProviderStrategyItem> capacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();

        private DeploymentConfiguration deploymentConfiguration;

        private NetworkConfiguration networkConfiguration;

        private List<PlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();

        private List<PlacementStrategy> placementStrategy = DefaultSdkAutoConstructList.getInstance();

        private String platformVersion;

        private Boolean forceNewDeployment;

        private Integer healthCheckGracePeriodSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceRequest model) {
            super(model);
            cluster(model.cluster);
            service(model.service);
            desiredCount(model.desiredCount);
            taskDefinition(model.taskDefinition);
            capacityProviderStrategy(model.capacityProviderStrategy);
            deploymentConfiguration(model.deploymentConfiguration);
            networkConfiguration(model.networkConfiguration);
            placementConstraints(model.placementConstraints);
            placementStrategy(model.placementStrategy);
            platformVersion(model.platformVersion);
            forceNewDeployment(model.forceNewDeployment);
            healthCheckGracePeriodSeconds(model.healthCheckGracePeriodSeconds);
        }

        public final String getCluster() {
            return cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getService() {
            return service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final Integer getDesiredCount() {
            return desiredCount;
        }

        @Override
        public final Builder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final void setDesiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
        }

        public final String getTaskDefinition() {
            return taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        public final Collection<CapacityProviderStrategyItem.Builder> getCapacityProviderStrategy() {
            if (capacityProviderStrategy instanceof SdkAutoConstructList) {
                return null;
            }
            return capacityProviderStrategy != null ? capacityProviderStrategy.stream()
                    .map(CapacityProviderStrategyItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(CapacityProviderStrategyItem... capacityProviderStrategy) {
            capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder>... capacityProviderStrategy) {
            capacityProviderStrategy(Stream.of(capacityProviderStrategy)
                    .map(c -> CapacityProviderStrategyItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCapacityProviderStrategy(
                Collection<CapacityProviderStrategyItem.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(capacityProviderStrategy);
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return deploymentConfiguration != null ? deploymentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final Collection<PlacementConstraint.Builder> getPlacementConstraints() {
            if (placementConstraints instanceof SdkAutoConstructList) {
                return null;
            }
            return placementConstraints != null ? placementConstraints.stream().map(PlacementConstraint::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementConstraints(Collection<PlacementConstraint> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(PlacementConstraint... placementConstraints) {
            placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<PlacementConstraint.Builder>... placementConstraints) {
            placementConstraints(Stream.of(placementConstraints).map(c -> PlacementConstraint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementConstraints(Collection<PlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        public final Collection<PlacementStrategy.Builder> getPlacementStrategy() {
            if (placementStrategy instanceof SdkAutoConstructList) {
                return null;
            }
            return placementStrategy != null ? placementStrategy.stream().map(PlacementStrategy::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementStrategy(Collection<PlacementStrategy> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copy(placementStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(PlacementStrategy... placementStrategy) {
            placementStrategy(Arrays.asList(placementStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(Consumer<PlacementStrategy.Builder>... placementStrategy) {
            placementStrategy(Stream.of(placementStrategy).map(c -> PlacementStrategy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementStrategy(Collection<PlacementStrategy.BuilderImpl> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copyFromBuilder(placementStrategy);
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final Boolean getForceNewDeployment() {
            return forceNewDeployment;
        }

        @Override
        public final Builder forceNewDeployment(Boolean forceNewDeployment) {
            this.forceNewDeployment = forceNewDeployment;
            return this;
        }

        public final void setForceNewDeployment(Boolean forceNewDeployment) {
            this.forceNewDeployment = forceNewDeployment;
        }

        public final Integer getHealthCheckGracePeriodSeconds() {
            return healthCheckGracePeriodSeconds;
        }

        @Override
        public final Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
            return this;
        }

        public final void setHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceRequest build() {
            return new UpdateServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
