/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a change in state for a container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerStateChange implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerStateChange.Builder, ContainerStateChange> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerName").getter(getter(ContainerStateChange::containerName))
            .setter(setter(Builder::containerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()).build();

    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageDigest").getter(getter(ContainerStateChange::imageDigest)).setter(setter(Builder::imageDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()).build();

    private static final SdkField<String> RUNTIME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runtimeId").getter(getter(ContainerStateChange::runtimeId)).setter(setter(Builder::runtimeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeId").build()).build();

    private static final SdkField<Integer> EXIT_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("exitCode").getter(getter(ContainerStateChange::exitCode)).setter(setter(Builder::exitCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exitCode").build()).build();

    private static final SdkField<List<NetworkBinding>> NETWORK_BINDINGS_FIELD = SdkField
            .<List<NetworkBinding>> builder(MarshallingType.LIST)
            .memberName("networkBindings")
            .getter(getter(ContainerStateChange::networkBindings))
            .setter(setter(Builder::networkBindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkBindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkBinding> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkBinding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(ContainerStateChange::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ContainerStateChange::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD,
            IMAGE_DIGEST_FIELD, RUNTIME_ID_FIELD, EXIT_CODE_FIELD, NETWORK_BINDINGS_FIELD, REASON_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String containerName;

    private final String imageDigest;

    private final String runtimeId;

    private final Integer exitCode;

    private final List<NetworkBinding> networkBindings;

    private final String reason;

    private final String status;

    private ContainerStateChange(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.imageDigest = builder.imageDigest;
        this.runtimeId = builder.runtimeId;
        this.exitCode = builder.exitCode;
        this.networkBindings = builder.networkBindings;
        this.reason = builder.reason;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the container.
     * </p>
     * 
     * @return The name of the container.
     */
    public final String containerName() {
        return containerName;
    }

    /**
     * <p>
     * The container image SHA 256 digest.
     * </p>
     * 
     * @return The container image SHA 256 digest.
     */
    public final String imageDigest() {
        return imageDigest;
    }

    /**
     * <p>
     * The ID of the Docker container.
     * </p>
     * 
     * @return The ID of the Docker container.
     */
    public final String runtimeId() {
        return runtimeId;
    }

    /**
     * <p>
     * The exit code for the container, if the state change is a result of the container exiting.
     * </p>
     * 
     * @return The exit code for the container, if the state change is a result of the container exiting.
     */
    public final Integer exitCode() {
        return exitCode;
    }

    /**
     * Returns true if the NetworkBindings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasNetworkBindings() {
        return networkBindings != null && !(networkBindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any network bindings associated with the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkBindings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any network bindings associated with the container.
     */
    public final List<NetworkBinding> networkBindings() {
        return networkBindings;
    }

    /**
     * <p>
     * The reason for the state change.
     * </p>
     * 
     * @return The reason for the state change.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * The status of the container.
     * </p>
     * 
     * @return The status of the container.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerName());
        hashCode = 31 * hashCode + Objects.hashCode(imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeId());
        hashCode = 31 * hashCode + Objects.hashCode(exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkBindings() ? networkBindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerStateChange)) {
            return false;
        }
        ContainerStateChange other = (ContainerStateChange) obj;
        return Objects.equals(containerName(), other.containerName()) && Objects.equals(imageDigest(), other.imageDigest())
                && Objects.equals(runtimeId(), other.runtimeId()) && Objects.equals(exitCode(), other.exitCode())
                && hasNetworkBindings() == other.hasNetworkBindings()
                && Objects.equals(networkBindings(), other.networkBindings()) && Objects.equals(reason(), other.reason())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerStateChange").add("ContainerName", containerName()).add("ImageDigest", imageDigest())
                .add("RuntimeId", runtimeId()).add("ExitCode", exitCode())
                .add("NetworkBindings", hasNetworkBindings() ? networkBindings() : null).add("Reason", reason())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerName":
            return Optional.ofNullable(clazz.cast(containerName()));
        case "imageDigest":
            return Optional.ofNullable(clazz.cast(imageDigest()));
        case "runtimeId":
            return Optional.ofNullable(clazz.cast(runtimeId()));
        case "exitCode":
            return Optional.ofNullable(clazz.cast(exitCode()));
        case "networkBindings":
            return Optional.ofNullable(clazz.cast(networkBindings()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerStateChange, T> g) {
        return obj -> g.apply((ContainerStateChange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerStateChange> {
        /**
         * <p>
         * The name of the container.
         * </p>
         * 
         * @param containerName
         *        The name of the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerName(String containerName);

        /**
         * <p>
         * The container image SHA 256 digest.
         * </p>
         * 
         * @param imageDigest
         *        The container image SHA 256 digest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageDigest(String imageDigest);

        /**
         * <p>
         * The ID of the Docker container.
         * </p>
         * 
         * @param runtimeId
         *        The ID of the Docker container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeId(String runtimeId);

        /**
         * <p>
         * The exit code for the container, if the state change is a result of the container exiting.
         * </p>
         * 
         * @param exitCode
         *        The exit code for the container, if the state change is a result of the container exiting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exitCode(Integer exitCode);

        /**
         * <p>
         * Any network bindings associated with the container.
         * </p>
         * 
         * @param networkBindings
         *        Any network bindings associated with the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkBindings(Collection<NetworkBinding> networkBindings);

        /**
         * <p>
         * Any network bindings associated with the container.
         * </p>
         * 
         * @param networkBindings
         *        Any network bindings associated with the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkBindings(NetworkBinding... networkBindings);

        /**
         * <p>
         * Any network bindings associated with the container.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkBinding>.Builder} avoiding the need
         * to create one manually via {@link List<NetworkBinding>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkBinding>.Builder#build()} is called immediately and
         * its result is passed to {@link #networkBindings(List<NetworkBinding>)}.
         * 
         * @param networkBindings
         *        a consumer that will call methods on {@link List<NetworkBinding>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkBindings(List<NetworkBinding>)
         */
        Builder networkBindings(Consumer<NetworkBinding.Builder>... networkBindings);

        /**
         * <p>
         * The reason for the state change.
         * </p>
         * 
         * @param reason
         *        The reason for the state change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The status of the container.
         * </p>
         * 
         * @param status
         *        The status of the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String containerName;

        private String imageDigest;

        private String runtimeId;

        private Integer exitCode;

        private List<NetworkBinding> networkBindings = DefaultSdkAutoConstructList.getInstance();

        private String reason;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerStateChange model) {
            containerName(model.containerName);
            imageDigest(model.imageDigest);
            runtimeId(model.runtimeId);
            exitCode(model.exitCode);
            networkBindings(model.networkBindings);
            reason(model.reason);
            status(model.status);
        }

        public final String getContainerName() {
            return containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public final String getImageDigest() {
            return imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        public final String getRuntimeId() {
            return runtimeId;
        }

        @Override
        public final Builder runtimeId(String runtimeId) {
            this.runtimeId = runtimeId;
            return this;
        }

        public final void setRuntimeId(String runtimeId) {
            this.runtimeId = runtimeId;
        }

        public final Integer getExitCode() {
            return exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        public final Collection<NetworkBinding.Builder> getNetworkBindings() {
            if (networkBindings instanceof SdkAutoConstructList) {
                return null;
            }
            return networkBindings != null ? networkBindings.stream().map(NetworkBinding::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder networkBindings(Collection<NetworkBinding> networkBindings) {
            this.networkBindings = NetworkBindingsCopier.copy(networkBindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkBindings(NetworkBinding... networkBindings) {
            networkBindings(Arrays.asList(networkBindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkBindings(Consumer<NetworkBinding.Builder>... networkBindings) {
            networkBindings(Stream.of(networkBindings).map(c -> NetworkBinding.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkBindings(Collection<NetworkBinding.BuilderImpl> networkBindings) {
            this.networkBindings = NetworkBindingsCopier.copyFromBuilder(networkBindings);
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public ContainerStateChange build() {
            return new ContainerStateChange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
