/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.Compatibility;
import software.amazon.awssdk.services.ecs.model.CompatibilityListCopier;
import software.amazon.awssdk.services.ecs.model.ContainerDefinition;
import software.amazon.awssdk.services.ecs.model.ContainerDefinitionsCopier;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.InferenceAccelerator;
import software.amazon.awssdk.services.ecs.model.InferenceAcceleratorsCopier;
import software.amazon.awssdk.services.ecs.model.IpcMode;
import software.amazon.awssdk.services.ecs.model.NetworkMode;
import software.amazon.awssdk.services.ecs.model.PidMode;
import software.amazon.awssdk.services.ecs.model.ProxyConfiguration;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.services.ecs.model.TaskDefinitionPlacementConstraint;
import software.amazon.awssdk.services.ecs.model.TaskDefinitionPlacementConstraintsCopier;
import software.amazon.awssdk.services.ecs.model.Volume;
import software.amazon.awssdk.services.ecs.model.VolumeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterTaskDefinitionRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, RegisterTaskDefinitionRequest> {
    private static final SdkField<String> FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::family)).setter(RegisterTaskDefinitionRequest.setter(Builder::family)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("family").build()}).build();
    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::taskRoleArn)).setter(RegisterTaskDefinitionRequest.setter(Builder::taskRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRoleArn").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::executionRoleArn)).setter(RegisterTaskDefinitionRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<String> NETWORK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::networkModeAsString)).setter(RegisterTaskDefinitionRequest.setter(Builder::networkMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkMode").build()}).build();
    private static final SdkField<List<ContainerDefinition>> CONTAINER_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::containerDefinitions)).setter(RegisterTaskDefinitionRequest.setter(Builder::containerDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Volume>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::volumes)).setter(RegisterTaskDefinitionRequest.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Volume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TaskDefinitionPlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::placementConstraints)).setter(RegisterTaskDefinitionRequest.setter(Builder::placementConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskDefinitionPlacementConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REQUIRES_COMPATIBILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::requiresCompatibilitiesAsStrings)).setter(RegisterTaskDefinitionRequest.setter(Builder::requiresCompatibilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiresCompatibilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::cpu)).setter(RegisterTaskDefinitionRequest.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()}).build();
    private static final SdkField<String> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::memory)).setter(RegisterTaskDefinitionRequest.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::tags)).setter(RegisterTaskDefinitionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PID_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::pidModeAsString)).setter(RegisterTaskDefinitionRequest.setter(Builder::pidMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pidMode").build()}).build();
    private static final SdkField<String> IPC_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::ipcModeAsString)).setter(RegisterTaskDefinitionRequest.setter(Builder::ipcMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipcMode").build()}).build();
    private static final SdkField<ProxyConfiguration> PROXY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::proxyConfiguration)).setter(RegisterTaskDefinitionRequest.setter(Builder::proxyConfiguration)).constructor(ProxyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proxyConfiguration").build()}).build();
    private static final SdkField<List<InferenceAccelerator>> INFERENCE_ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RegisterTaskDefinitionRequest.getter(RegisterTaskDefinitionRequest::inferenceAccelerators)).setter(RegisterTaskDefinitionRequest.setter(Builder::inferenceAccelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceAccelerators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InferenceAccelerator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILY_FIELD, TASK_ROLE_ARN_FIELD, EXECUTION_ROLE_ARN_FIELD, NETWORK_MODE_FIELD, CONTAINER_DEFINITIONS_FIELD, VOLUMES_FIELD, PLACEMENT_CONSTRAINTS_FIELD, REQUIRES_COMPATIBILITIES_FIELD, CPU_FIELD, MEMORY_FIELD, TAGS_FIELD, PID_MODE_FIELD, IPC_MODE_FIELD, PROXY_CONFIGURATION_FIELD, INFERENCE_ACCELERATORS_FIELD));
    private final String family;
    private final String taskRoleArn;
    private final String executionRoleArn;
    private final String networkMode;
    private final List<ContainerDefinition> containerDefinitions;
    private final List<Volume> volumes;
    private final List<TaskDefinitionPlacementConstraint> placementConstraints;
    private final List<String> requiresCompatibilities;
    private final String cpu;
    private final String memory;
    private final List<Tag> tags;
    private final String pidMode;
    private final String ipcMode;
    private final ProxyConfiguration proxyConfiguration;
    private final List<InferenceAccelerator> inferenceAccelerators;

    private RegisterTaskDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.family = builder.family;
        this.taskRoleArn = builder.taskRoleArn;
        this.executionRoleArn = builder.executionRoleArn;
        this.networkMode = builder.networkMode;
        this.containerDefinitions = builder.containerDefinitions;
        this.volumes = builder.volumes;
        this.placementConstraints = builder.placementConstraints;
        this.requiresCompatibilities = builder.requiresCompatibilities;
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.tags = builder.tags;
        this.pidMode = builder.pidMode;
        this.ipcMode = builder.ipcMode;
        this.proxyConfiguration = builder.proxyConfiguration;
        this.inferenceAccelerators = builder.inferenceAccelerators;
    }

    public String family() {
        return this.family;
    }

    public String taskRoleArn() {
        return this.taskRoleArn;
    }

    public String executionRoleArn() {
        return this.executionRoleArn;
    }

    public NetworkMode networkMode() {
        return NetworkMode.fromValue(this.networkMode);
    }

    public String networkModeAsString() {
        return this.networkMode;
    }

    public boolean hasContainerDefinitions() {
        return this.containerDefinitions != null && !(this.containerDefinitions instanceof SdkAutoConstructList);
    }

    public List<ContainerDefinition> containerDefinitions() {
        return this.containerDefinitions;
    }

    public boolean hasVolumes() {
        return this.volumes != null && !(this.volumes instanceof SdkAutoConstructList);
    }

    public List<Volume> volumes() {
        return this.volumes;
    }

    public boolean hasPlacementConstraints() {
        return this.placementConstraints != null && !(this.placementConstraints instanceof SdkAutoConstructList);
    }

    public List<TaskDefinitionPlacementConstraint> placementConstraints() {
        return this.placementConstraints;
    }

    public List<Compatibility> requiresCompatibilities() {
        return CompatibilityListCopier.copyStringToEnum(this.requiresCompatibilities);
    }

    public boolean hasRequiresCompatibilities() {
        return this.requiresCompatibilities != null && !(this.requiresCompatibilities instanceof SdkAutoConstructList);
    }

    public List<String> requiresCompatibilitiesAsStrings() {
        return this.requiresCompatibilities;
    }

    public String cpu() {
        return this.cpu;
    }

    public String memory() {
        return this.memory;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public PidMode pidMode() {
        return PidMode.fromValue(this.pidMode);
    }

    public String pidModeAsString() {
        return this.pidMode;
    }

    public IpcMode ipcMode() {
        return IpcMode.fromValue(this.ipcMode);
    }

    public String ipcModeAsString() {
        return this.ipcMode;
    }

    public ProxyConfiguration proxyConfiguration() {
        return this.proxyConfiguration;
    }

    public boolean hasInferenceAccelerators() {
        return this.inferenceAccelerators != null && !(this.inferenceAccelerators instanceof SdkAutoConstructList);
    }

    public List<InferenceAccelerator> inferenceAccelerators() {
        return this.inferenceAccelerators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.family());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumes());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementConstraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiresCompatibilitiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.pidModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipcModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceAccelerators());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTaskDefinitionRequest)) {
            return false;
        }
        RegisterTaskDefinitionRequest other = (RegisterTaskDefinitionRequest)((Object)obj);
        return Objects.equals(this.family(), other.family()) && Objects.equals(this.taskRoleArn(), other.taskRoleArn()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.networkModeAsString(), other.networkModeAsString()) && Objects.equals(this.containerDefinitions(), other.containerDefinitions()) && Objects.equals(this.volumes(), other.volumes()) && Objects.equals(this.placementConstraints(), other.placementConstraints()) && Objects.equals(this.requiresCompatibilitiesAsStrings(), other.requiresCompatibilitiesAsStrings()) && Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.pidModeAsString(), other.pidModeAsString()) && Objects.equals(this.ipcModeAsString(), other.ipcModeAsString()) && Objects.equals(this.proxyConfiguration(), other.proxyConfiguration()) && Objects.equals(this.inferenceAccelerators(), other.inferenceAccelerators());
    }

    public String toString() {
        return ToString.builder((String)"RegisterTaskDefinitionRequest").add("Family", (Object)this.family()).add("TaskRoleArn", (Object)this.taskRoleArn()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("NetworkMode", (Object)this.networkModeAsString()).add("ContainerDefinitions", this.containerDefinitions()).add("Volumes", this.volumes()).add("PlacementConstraints", this.placementConstraints()).add("RequiresCompatibilities", this.requiresCompatibilitiesAsStrings()).add("Cpu", (Object)this.cpu()).add("Memory", (Object)this.memory()).add("Tags", this.tags()).add("PidMode", (Object)this.pidModeAsString()).add("IpcMode", (Object)this.ipcModeAsString()).add("ProxyConfiguration", (Object)this.proxyConfiguration()).add("InferenceAccelerators", this.inferenceAccelerators()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "family": {
                return Optional.ofNullable(clazz.cast(this.family()));
            }
            case "taskRoleArn": {
                return Optional.ofNullable(clazz.cast(this.taskRoleArn()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "networkMode": {
                return Optional.ofNullable(clazz.cast(this.networkModeAsString()));
            }
            case "containerDefinitions": {
                return Optional.ofNullable(clazz.cast(this.containerDefinitions()));
            }
            case "volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
            case "placementConstraints": {
                return Optional.ofNullable(clazz.cast(this.placementConstraints()));
            }
            case "requiresCompatibilities": {
                return Optional.ofNullable(clazz.cast(this.requiresCompatibilitiesAsStrings()));
            }
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "pidMode": {
                return Optional.ofNullable(clazz.cast(this.pidModeAsString()));
            }
            case "ipcMode": {
                return Optional.ofNullable(clazz.cast(this.ipcModeAsString()));
            }
            case "proxyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.proxyConfiguration()));
            }
            case "inferenceAccelerators": {
                return Optional.ofNullable(clazz.cast(this.inferenceAccelerators()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterTaskDefinitionRequest, T> g) {
        return obj -> g.apply((RegisterTaskDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String family;
        private String taskRoleArn;
        private String executionRoleArn;
        private String networkMode;
        private List<ContainerDefinition> containerDefinitions = DefaultSdkAutoConstructList.getInstance();
        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();
        private List<TaskDefinitionPlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();
        private List<String> requiresCompatibilities = DefaultSdkAutoConstructList.getInstance();
        private String cpu;
        private String memory;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String pidMode;
        private String ipcMode;
        private ProxyConfiguration proxyConfiguration;
        private List<InferenceAccelerator> inferenceAccelerators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTaskDefinitionRequest model) {
            super(model);
            this.family(model.family);
            this.taskRoleArn(model.taskRoleArn);
            this.executionRoleArn(model.executionRoleArn);
            this.networkMode(model.networkMode);
            this.containerDefinitions(model.containerDefinitions);
            this.volumes(model.volumes);
            this.placementConstraints(model.placementConstraints);
            this.requiresCompatibilitiesWithStrings(model.requiresCompatibilities);
            this.cpu(model.cpu);
            this.memory(model.memory);
            this.tags(model.tags);
            this.pidMode(model.pidMode);
            this.ipcMode(model.ipcMode);
            this.proxyConfiguration(model.proxyConfiguration);
            this.inferenceAccelerators(model.inferenceAccelerators);
        }

        public final String getFamily() {
            return this.family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        public final String getTaskRoleArn() {
            return this.taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final String getNetworkMode() {
            return this.networkMode;
        }

        @Override
        public final Builder networkMode(String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        @Override
        public final Builder networkMode(NetworkMode networkMode) {
            this.networkMode(networkMode == null ? null : networkMode.toString());
            return this;
        }

        public final void setNetworkMode(String networkMode) {
            this.networkMode = networkMode;
        }

        public final Collection<ContainerDefinition.Builder> getContainerDefinitions() {
            return this.containerDefinitions != null ? (Collection)this.containerDefinitions.stream().map(ContainerDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder containerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
            this.containerDefinitions = ContainerDefinitionsCopier.copy(containerDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(ContainerDefinition ... containerDefinitions) {
            this.containerDefinitions(Arrays.asList(containerDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(Consumer<ContainerDefinition.Builder> ... containerDefinitions) {
            this.containerDefinitions(Stream.of(containerDefinitions).map(c -> (ContainerDefinition)((ContainerDefinition.Builder)ContainerDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContainerDefinitions(Collection<ContainerDefinition.BuilderImpl> containerDefinitions) {
            this.containerDefinitions = ContainerDefinitionsCopier.copyFromBuilder(containerDefinitions);
        }

        public final Collection<Volume.Builder> getVolumes() {
            return this.volumes != null ? (Collection)this.volumes.stream().map(Volume::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumeListCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (Volume)((Volume.Builder)Volume.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumeListCopier.copyFromBuilder(volumes);
        }

        public final Collection<TaskDefinitionPlacementConstraint.Builder> getPlacementConstraints() {
            return this.placementConstraints != null ? (Collection)this.placementConstraints.stream().map(TaskDefinitionPlacementConstraint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementConstraints(Collection<TaskDefinitionPlacementConstraint> placementConstraints) {
            this.placementConstraints = TaskDefinitionPlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(TaskDefinitionPlacementConstraint ... placementConstraints) {
            this.placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<TaskDefinitionPlacementConstraint.Builder> ... placementConstraints) {
            this.placementConstraints(Stream.of(placementConstraints).map(c -> (TaskDefinitionPlacementConstraint)((TaskDefinitionPlacementConstraint.Builder)TaskDefinitionPlacementConstraint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementConstraints(Collection<TaskDefinitionPlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = TaskDefinitionPlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        public final Collection<String> getRequiresCompatibilities() {
            return this.requiresCompatibilities;
        }

        @Override
        public final Builder requiresCompatibilitiesWithStrings(Collection<String> requiresCompatibilities) {
            this.requiresCompatibilities = CompatibilityListCopier.copy(requiresCompatibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiresCompatibilitiesWithStrings(String ... requiresCompatibilities) {
            this.requiresCompatibilitiesWithStrings(Arrays.asList(requiresCompatibilities));
            return this;
        }

        @Override
        public final Builder requiresCompatibilities(Collection<Compatibility> requiresCompatibilities) {
            this.requiresCompatibilities = CompatibilityListCopier.copyEnumToString(requiresCompatibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiresCompatibilities(Compatibility ... requiresCompatibilities) {
            this.requiresCompatibilities(Arrays.asList(requiresCompatibilities));
            return this;
        }

        public final void setRequiresCompatibilities(Collection<String> requiresCompatibilities) {
            this.requiresCompatibilities = CompatibilityListCopier.copy(requiresCompatibilities);
        }

        public final String getCpu() {
            return this.cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        public final String getMemory() {
            return this.memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getPidMode() {
            return this.pidMode;
        }

        @Override
        public final Builder pidMode(String pidMode) {
            this.pidMode = pidMode;
            return this;
        }

        @Override
        public final Builder pidMode(PidMode pidMode) {
            this.pidMode(pidMode == null ? null : pidMode.toString());
            return this;
        }

        public final void setPidMode(String pidMode) {
            this.pidMode = pidMode;
        }

        public final String getIpcMode() {
            return this.ipcMode;
        }

        @Override
        public final Builder ipcMode(String ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        @Override
        public final Builder ipcMode(IpcMode ipcMode) {
            this.ipcMode(ipcMode == null ? null : ipcMode.toString());
            return this;
        }

        public final void setIpcMode(String ipcMode) {
            this.ipcMode = ipcMode;
        }

        public final ProxyConfiguration.Builder getProxyConfiguration() {
            return this.proxyConfiguration != null ? this.proxyConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public final void setProxyConfiguration(ProxyConfiguration.BuilderImpl proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration != null ? proxyConfiguration.build() : null;
        }

        public final Collection<InferenceAccelerator.Builder> getInferenceAccelerators() {
            return this.inferenceAccelerators != null ? (Collection)this.inferenceAccelerators.stream().map(InferenceAccelerator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inferenceAccelerators(Collection<InferenceAccelerator> inferenceAccelerators) {
            this.inferenceAccelerators = InferenceAcceleratorsCopier.copy(inferenceAccelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAccelerators(InferenceAccelerator ... inferenceAccelerators) {
            this.inferenceAccelerators(Arrays.asList(inferenceAccelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAccelerators(Consumer<InferenceAccelerator.Builder> ... inferenceAccelerators) {
            this.inferenceAccelerators(Stream.of(inferenceAccelerators).map(c -> (InferenceAccelerator)((InferenceAccelerator.Builder)InferenceAccelerator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInferenceAccelerators(Collection<InferenceAccelerator.BuilderImpl> inferenceAccelerators) {
            this.inferenceAccelerators = InferenceAcceleratorsCopier.copyFromBuilder(inferenceAccelerators);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterTaskDefinitionRequest build() {
            return new RegisterTaskDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterTaskDefinitionRequest> {
        public Builder family(String var1);

        public Builder taskRoleArn(String var1);

        public Builder executionRoleArn(String var1);

        public Builder networkMode(String var1);

        public Builder networkMode(NetworkMode var1);

        public Builder containerDefinitions(Collection<ContainerDefinition> var1);

        public Builder containerDefinitions(ContainerDefinition ... var1);

        public Builder containerDefinitions(Consumer<ContainerDefinition.Builder> ... var1);

        public Builder volumes(Collection<Volume> var1);

        public Builder volumes(Volume ... var1);

        public Builder volumes(Consumer<Volume.Builder> ... var1);

        public Builder placementConstraints(Collection<TaskDefinitionPlacementConstraint> var1);

        public Builder placementConstraints(TaskDefinitionPlacementConstraint ... var1);

        public Builder placementConstraints(Consumer<TaskDefinitionPlacementConstraint.Builder> ... var1);

        public Builder requiresCompatibilitiesWithStrings(Collection<String> var1);

        public Builder requiresCompatibilitiesWithStrings(String ... var1);

        public Builder requiresCompatibilities(Collection<Compatibility> var1);

        public Builder requiresCompatibilities(Compatibility ... var1);

        public Builder cpu(String var1);

        public Builder memory(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder pidMode(String var1);

        public Builder pidMode(PidMode var1);

        public Builder ipcMode(String var1);

        public Builder ipcMode(IpcMode var1);

        public Builder proxyConfiguration(ProxyConfiguration var1);

        default public Builder proxyConfiguration(Consumer<ProxyConfiguration.Builder> proxyConfiguration) {
            return this.proxyConfiguration((ProxyConfiguration)((ProxyConfiguration.Builder)ProxyConfiguration.builder().applyMutation(proxyConfiguration)).build());
        }

        public Builder inferenceAccelerators(Collection<InferenceAccelerator> var1);

        public Builder inferenceAccelerators(InferenceAccelerator ... var1);

        public Builder inferenceAccelerators(Consumer<InferenceAccelerator.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

