/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.AutoScalingGroupProvider;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStatus;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityProvider> {
    private static final SdkField<String> CAPACITY_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CapacityProvider.getter(CapacityProvider::capacityProviderArn)).setter(CapacityProvider.setter(Builder::capacityProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CapacityProvider.getter(CapacityProvider::name)).setter(CapacityProvider.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CapacityProvider.getter(CapacityProvider::statusAsString)).setter(CapacityProvider.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<AutoScalingGroupProvider> AUTO_SCALING_GROUP_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CapacityProvider.getter(CapacityProvider::autoScalingGroupProvider)).setter(CapacityProvider.setter(Builder::autoScalingGroupProvider)).constructor(AutoScalingGroupProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupProvider").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CapacityProvider.getter(CapacityProvider::tags)).setter(CapacityProvider.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDER_ARN_FIELD, NAME_FIELD, STATUS_FIELD, AUTO_SCALING_GROUP_PROVIDER_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String capacityProviderArn;
    private final String name;
    private final String status;
    private final AutoScalingGroupProvider autoScalingGroupProvider;
    private final List<Tag> tags;

    private CapacityProvider(BuilderImpl builder) {
        this.capacityProviderArn = builder.capacityProviderArn;
        this.name = builder.name;
        this.status = builder.status;
        this.autoScalingGroupProvider = builder.autoScalingGroupProvider;
        this.tags = builder.tags;
    }

    public String capacityProviderArn() {
        return this.capacityProviderArn;
    }

    public String name() {
        return this.name;
    }

    public CapacityProviderStatus status() {
        return CapacityProviderStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public AutoScalingGroupProvider autoScalingGroupProvider() {
        return this.autoScalingGroupProvider;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityProvider)) {
            return false;
        }
        CapacityProvider other = (CapacityProvider)obj;
        return Objects.equals(this.capacityProviderArn(), other.capacityProviderArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.autoScalingGroupProvider(), other.autoScalingGroupProvider()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CapacityProvider").add("CapacityProviderArn", (Object)this.capacityProviderArn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("AutoScalingGroupProvider", (Object)this.autoScalingGroupProvider()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "capacityProviderArn": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "autoScalingGroupProvider": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupProvider()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityProvider, T> g) {
        return obj -> g.apply((CapacityProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityProviderArn;
        private String name;
        private String status;
        private AutoScalingGroupProvider autoScalingGroupProvider;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityProvider model) {
            this.capacityProviderArn(model.capacityProviderArn);
            this.name(model.name);
            this.status(model.status);
            this.autoScalingGroupProvider(model.autoScalingGroupProvider);
            this.tags(model.tags);
        }

        public final String getCapacityProviderArn() {
            return this.capacityProviderArn;
        }

        @Override
        public final Builder capacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
            return this;
        }

        public final void setCapacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CapacityProviderStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final AutoScalingGroupProvider.Builder getAutoScalingGroupProvider() {
            return this.autoScalingGroupProvider != null ? this.autoScalingGroupProvider.toBuilder() : null;
        }

        @Override
        public final Builder autoScalingGroupProvider(AutoScalingGroupProvider autoScalingGroupProvider) {
            this.autoScalingGroupProvider = autoScalingGroupProvider;
            return this;
        }

        public final void setAutoScalingGroupProvider(AutoScalingGroupProvider.BuilderImpl autoScalingGroupProvider) {
            this.autoScalingGroupProvider = autoScalingGroupProvider != null ? autoScalingGroupProvider.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public CapacityProvider build() {
            return new CapacityProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityProvider> {
        public Builder capacityProviderArn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(CapacityProviderStatus var1);

        public Builder autoScalingGroupProvider(AutoScalingGroupProvider var1);

        default public Builder autoScalingGroupProvider(Consumer<AutoScalingGroupProvider.Builder> autoScalingGroupProvider) {
            return this.autoScalingGroupProvider((AutoScalingGroupProvider)((AutoScalingGroupProvider.Builder)AutoScalingGroupProvider.builder().applyMutation(autoScalingGroupProvider)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

