/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a constraint on task placement. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html">Task Placement
 * Constraints</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
 * </p>
 * <note>
 * <p>
 * If you are using the Fargate launch type, task placement constraints are not supported.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlacementConstraint implements SdkPojo, Serializable,
        ToCopyableBuilder<PlacementConstraint.Builder, PlacementConstraint> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlacementConstraint::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlacementConstraint::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, EXPRESSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String expression;

    private PlacementConstraint(BuilderImpl builder) {
        this.type = builder.type;
        this.expression = builder.expression;
    }

    /**
     * <p>
     * The type of constraint. Use <code>distinctInstance</code> to ensure that each task in a particular group is
     * running on a different container instance. Use <code>memberOf</code> to restrict the selection to a group of
     * valid candidates.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PlacementConstraintType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of constraint. Use <code>distinctInstance</code> to ensure that each task in a particular group
     *         is running on a different container instance. Use <code>memberOf</code> to restrict the selection to a
     *         group of valid candidates.
     * @see PlacementConstraintType
     */
    public PlacementConstraintType type() {
        return PlacementConstraintType.fromValue(type);
    }

    /**
     * <p>
     * The type of constraint. Use <code>distinctInstance</code> to ensure that each task in a particular group is
     * running on a different container instance. Use <code>memberOf</code> to restrict the selection to a group of
     * valid candidates.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PlacementConstraintType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of constraint. Use <code>distinctInstance</code> to ensure that each task in a particular group
     *         is running on a different container instance. Use <code>memberOf</code> to restrict the selection to a
     *         group of valid candidates.
     * @see PlacementConstraintType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A cluster query language expression to apply to the constraint. You cannot specify an expression if the
     * constraint type is <code>distinctInstance</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query
     * Language</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return A cluster query language expression to apply to the constraint. You cannot specify an expression if the
     *         constraint type is <code>distinctInstance</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster
     *         Query Language</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public String expression() {
        return expression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementConstraint)) {
            return false;
        }
        PlacementConstraint other = (PlacementConstraint) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(expression(), other.expression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PlacementConstraint").add("Type", typeAsString()).add("Expression", expression()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "expression":
            return Optional.ofNullable(clazz.cast(expression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlacementConstraint, T> g) {
        return obj -> g.apply((PlacementConstraint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlacementConstraint> {
        /**
         * <p>
         * The type of constraint. Use <code>distinctInstance</code> to ensure that each task in a particular group is
         * running on a different container instance. Use <code>memberOf</code> to restrict the selection to a group of
         * valid candidates.
         * </p>
         * 
         * @param type
         *        The type of constraint. Use <code>distinctInstance</code> to ensure that each task in a particular
         *        group is running on a different container instance. Use <code>memberOf</code> to restrict the
         *        selection to a group of valid candidates.
         * @see PlacementConstraintType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementConstraintType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of constraint. Use <code>distinctInstance</code> to ensure that each task in a particular group is
         * running on a different container instance. Use <code>memberOf</code> to restrict the selection to a group of
         * valid candidates.
         * </p>
         * 
         * @param type
         *        The type of constraint. Use <code>distinctInstance</code> to ensure that each task in a particular
         *        group is running on a different container instance. Use <code>memberOf</code> to restrict the
         *        selection to a group of valid candidates.
         * @see PlacementConstraintType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementConstraintType
         */
        Builder type(PlacementConstraintType type);

        /**
         * <p>
         * A cluster query language expression to apply to the constraint. You cannot specify an expression if the
         * constraint type is <code>distinctInstance</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query
         * Language</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param expression
         *        A cluster query language expression to apply to the constraint. You cannot specify an expression if
         *        the constraint type is <code>distinctInstance</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster
         *        Query Language</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String expression;

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementConstraint model) {
            type(model.type);
            expression(model.expression);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PlacementConstraintType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getExpression() {
            return expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public PlacementConstraint build() {
            return new PlacementConstraint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
