/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the network configuration for a task or service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkConfiguration.Builder, NetworkConfiguration> {
    private static final SdkField<AwsVpcConfiguration> AWSVPC_CONFIGURATION_FIELD = SdkField
            .<AwsVpcConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(NetworkConfiguration::awsvpcConfiguration))
            .setter(setter(Builder::awsvpcConfiguration)).constructor(AwsVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsvpcConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWSVPC_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsVpcConfiguration awsvpcConfiguration;

    private NetworkConfiguration(BuilderImpl builder) {
        this.awsvpcConfiguration = builder.awsvpcConfiguration;
    }

    /**
     * <p>
     * The VPC subnets and security groups associated with a task.
     * </p>
     * <note>
     * <p>
     * All specified subnets and security groups must be from the same VPC.
     * </p>
     * </note>
     * 
     * @return The VPC subnets and security groups associated with a task.</p> <note>
     *         <p>
     *         All specified subnets and security groups must be from the same VPC.
     *         </p>
     */
    public AwsVpcConfiguration awsvpcConfiguration() {
        return awsvpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsvpcConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkConfiguration)) {
            return false;
        }
        NetworkConfiguration other = (NetworkConfiguration) obj;
        return Objects.equals(awsvpcConfiguration(), other.awsvpcConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NetworkConfiguration").add("AwsvpcConfiguration", awsvpcConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsvpcConfiguration":
            return Optional.ofNullable(clazz.cast(awsvpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkConfiguration, T> g) {
        return obj -> g.apply((NetworkConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkConfiguration> {
        /**
         * <p>
         * The VPC subnets and security groups associated with a task.
         * </p>
         * <note>
         * <p>
         * All specified subnets and security groups must be from the same VPC.
         * </p>
         * </note>
         * 
         * @param awsvpcConfiguration
         *        The VPC subnets and security groups associated with a task.</p> <note>
         *        <p>
         *        All specified subnets and security groups must be from the same VPC.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsvpcConfiguration(AwsVpcConfiguration awsvpcConfiguration);

        /**
         * <p>
         * The VPC subnets and security groups associated with a task.
         * </p>
         * <note>
         * <p>
         * All specified subnets and security groups must be from the same VPC.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link AwsVpcConfiguration.Builder} avoiding
         * the need to create one manually via {@link AwsVpcConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsVpcConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #awsvpcConfiguration(AwsVpcConfiguration)}.
         * 
         * @param awsvpcConfiguration
         *        a consumer that will call methods on {@link AwsVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsvpcConfiguration(AwsVpcConfiguration)
         */
        default Builder awsvpcConfiguration(Consumer<AwsVpcConfiguration.Builder> awsvpcConfiguration) {
            return awsvpcConfiguration(AwsVpcConfiguration.builder().applyMutation(awsvpcConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsVpcConfiguration awsvpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkConfiguration model) {
            awsvpcConfiguration(model.awsvpcConfiguration);
        }

        public final AwsVpcConfiguration.Builder getAwsvpcConfiguration() {
            return awsvpcConfiguration != null ? awsvpcConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder awsvpcConfiguration(AwsVpcConfiguration awsvpcConfiguration) {
            this.awsvpcConfiguration = awsvpcConfiguration;
            return this;
        }

        public final void setAwsvpcConfiguration(AwsVpcConfiguration.BuilderImpl awsvpcConfiguration) {
            this.awsvpcConfiguration = awsvpcConfiguration != null ? awsvpcConfiguration.build() : null;
        }

        @Override
        public NetworkConfiguration build() {
            return new NetworkConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
