/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeContainerInstancesResponse extends EcsResponse implements
        ToCopyableBuilder<DescribeContainerInstancesResponse.Builder, DescribeContainerInstancesResponse> {
    private static final SdkField<List<ContainerInstance>> CONTAINER_INSTANCES_FIELD = SdkField
            .<List<ContainerInstance>> builder(MarshallingType.LIST)
            .getter(getter(DescribeContainerInstancesResponse::containerInstances))
            .setter(setter(Builder::containerInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Failure>> FAILURES_FIELD = SdkField
            .<List<Failure>> builder(MarshallingType.LIST)
            .getter(getter(DescribeContainerInstancesResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Failure> builder(MarshallingType.SDK_POJO)
                                            .constructor(Failure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_INSTANCES_FIELD,
            FAILURES_FIELD));

    private final List<ContainerInstance> containerInstances;

    private final List<Failure> failures;

    private DescribeContainerInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.containerInstances = builder.containerInstances;
        this.failures = builder.failures;
    }

    /**
     * Returns true if the ContainerInstances property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasContainerInstances() {
        return containerInstances != null && !(containerInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of container instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContainerInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of container instances.
     */
    public List<ContainerInstance> containerInstances() {
        return containerInstances;
    }

    /**
     * Returns true if the Failures property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFailures() {
        return failures != null && !(failures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any failures associated with the call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailures()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any failures associated with the call.
     */
    public List<Failure> failures() {
        return failures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(containerInstances());
        hashCode = 31 * hashCode + Objects.hashCode(failures());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContainerInstancesResponse)) {
            return false;
        }
        DescribeContainerInstancesResponse other = (DescribeContainerInstancesResponse) obj;
        return Objects.equals(containerInstances(), other.containerInstances()) && Objects.equals(failures(), other.failures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeContainerInstancesResponse").add("ContainerInstances", containerInstances())
                .add("Failures", failures()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerInstances":
            return Optional.ofNullable(clazz.cast(containerInstances()));
        case "failures":
            return Optional.ofNullable(clazz.cast(failures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeContainerInstancesResponse, T> g) {
        return obj -> g.apply((DescribeContainerInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeContainerInstancesResponse> {
        /**
         * <p>
         * The list of container instances.
         * </p>
         * 
         * @param containerInstances
         *        The list of container instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstances(Collection<ContainerInstance> containerInstances);

        /**
         * <p>
         * The list of container instances.
         * </p>
         * 
         * @param containerInstances
         *        The list of container instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstances(ContainerInstance... containerInstances);

        /**
         * <p>
         * The list of container instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContainerInstance>.Builder} avoiding the
         * need to create one manually via {@link List<ContainerInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContainerInstance>.Builder#build()} is called immediately
         * and its result is passed to {@link #containerInstances(List<ContainerInstance>)}.
         * 
         * @param containerInstances
         *        a consumer that will call methods on {@link List<ContainerInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerInstances(List<ContainerInstance>)
         */
        Builder containerInstances(Consumer<ContainerInstance.Builder>... containerInstances);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<Failure> failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Failure... failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Failure>.Builder} avoiding the need to
         * create one manually via {@link List<Failure>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Failure>.Builder#build()} is called immediately and its
         * result is passed to {@link #failures(List<Failure>)}.
         * 
         * @param failures
         *        a consumer that will call methods on {@link List<Failure>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(List<Failure>)
         */
        Builder failures(Consumer<Failure.Builder>... failures);
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private List<ContainerInstance> containerInstances = DefaultSdkAutoConstructList.getInstance();

        private List<Failure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContainerInstancesResponse model) {
            super(model);
            containerInstances(model.containerInstances);
            failures(model.failures);
        }

        public final Collection<ContainerInstance.Builder> getContainerInstances() {
            return containerInstances != null ? containerInstances.stream().map(ContainerInstance::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder containerInstances(Collection<ContainerInstance> containerInstances) {
            this.containerInstances = ContainerInstancesCopier.copy(containerInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerInstances(ContainerInstance... containerInstances) {
            containerInstances(Arrays.asList(containerInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerInstances(Consumer<ContainerInstance.Builder>... containerInstances) {
            containerInstances(Stream.of(containerInstances).map(c -> ContainerInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setContainerInstances(Collection<ContainerInstance.BuilderImpl> containerInstances) {
            this.containerInstances = ContainerInstancesCopier.copyFromBuilder(containerInstances);
        }

        public final Collection<Failure.Builder> getFailures() {
            return failures != null ? failures.stream().map(Failure::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failures(Collection<Failure> failures) {
            this.failures = FailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Failure... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<Failure.Builder>... failures) {
            failures(Stream.of(failures).map(c -> Failure.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailures(Collection<Failure.BuilderImpl> failures) {
            this.failures = FailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public DescribeContainerInstancesResponse build() {
            return new DescribeContainerInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
