/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTaskSetRequest extends EcsRequest implements
        ToCopyableBuilder<CreateTaskSetRequest.Builder, CreateTaskSetRequest> {
    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTaskSetRequest::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTaskSetRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTaskSetRequest::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTaskSetRequest::taskDefinition)).setter(setter(Builder::taskDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()).build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(CreateTaskSetRequest::networkConfiguration))
            .setter(setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField
            .<List<LoadBalancer>> builder(MarshallingType.LIST)
            .getter(getter(CreateTaskSetRequest::loadBalancers))
            .setter(setter(Builder::loadBalancers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancer> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ServiceRegistry>> SERVICE_REGISTRIES_FIELD = SdkField
            .<List<ServiceRegistry>> builder(MarshallingType.LIST)
            .getter(getter(CreateTaskSetRequest::serviceRegistries))
            .setter(setter(Builder::serviceRegistries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRegistries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceRegistry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceRegistry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTaskSetRequest::launchTypeAsString)).setter(setter(Builder::launchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()).build();

    private static final SdkField<List<CapacityProviderStrategyItem>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField
            .<List<CapacityProviderStrategyItem>> builder(MarshallingType.LIST)
            .getter(getter(CreateTaskSetRequest::capacityProviderStrategy))
            .setter(setter(Builder::capacityProviderStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderStrategy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapacityProviderStrategyItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityProviderStrategyItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTaskSetRequest::platformVersion)).setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()).build();

    private static final SdkField<Scale> SCALE_FIELD = SdkField.<Scale> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateTaskSetRequest::scale)).setter(setter(Builder::scale)).constructor(Scale::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scale").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTaskSetRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateTaskSetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, CLUSTER_FIELD,
            EXTERNAL_ID_FIELD, TASK_DEFINITION_FIELD, NETWORK_CONFIGURATION_FIELD, LOAD_BALANCERS_FIELD,
            SERVICE_REGISTRIES_FIELD, LAUNCH_TYPE_FIELD, CAPACITY_PROVIDER_STRATEGY_FIELD, PLATFORM_VERSION_FIELD, SCALE_FIELD,
            CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private final String service;

    private final String cluster;

    private final String externalId;

    private final String taskDefinition;

    private final NetworkConfiguration networkConfiguration;

    private final List<LoadBalancer> loadBalancers;

    private final List<ServiceRegistry> serviceRegistries;

    private final String launchType;

    private final List<CapacityProviderStrategyItem> capacityProviderStrategy;

    private final String platformVersion;

    private final Scale scale;

    private final String clientToken;

    private final List<Tag> tags;

    private CreateTaskSetRequest(BuilderImpl builder) {
        super(builder);
        this.service = builder.service;
        this.cluster = builder.cluster;
        this.externalId = builder.externalId;
        this.taskDefinition = builder.taskDefinition;
        this.networkConfiguration = builder.networkConfiguration;
        this.loadBalancers = builder.loadBalancers;
        this.serviceRegistries = builder.serviceRegistries;
        this.launchType = builder.launchType;
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.platformVersion = builder.platformVersion;
        this.scale = builder.scale;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
     */
    public String service() {
        return service;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set
     * in.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the
     *         task set in.
     */
    public String cluster() {
        return cluster;
    }

    /**
     * <p>
     * An optional non-unique tag that identifies this task set in external systems. If the task set is associated with
     * a service discovery registry, the tasks in this task set will have the <code>ECS_TASK_SET_EXTERNAL_ID</code> AWS
     * Cloud Map attribute set to the provided value.
     * </p>
     * 
     * @return An optional non-unique tag that identifies this task set in external systems. If the task set is
     *         associated with a service discovery registry, the tasks in this task set will have the
     *         <code>ECS_TASK_SET_EXTERNAL_ID</code> AWS Cloud Map attribute set to the provided value.
     */
    public String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The task definition for the tasks in the task set to use.
     * </p>
     * 
     * @return The task definition for the tasks in the task set to use.
     */
    public String taskDefinition() {
        return taskDefinition;
    }

    /**
     * Returns the value of the NetworkConfiguration property for this object.
     * 
     * @return The value of the NetworkConfiguration property for this object.
     */
    public NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * Returns true if the LoadBalancers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLoadBalancers() {
        return loadBalancers != null && !(loadBalancers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A load balancer object representing the load balancer to use with the task set. The supported load balancer types
     * are either an Application Load Balancer or a Network Load Balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLoadBalancers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A load balancer object representing the load balancer to use with the task set. The supported load
     *         balancer types are either an Application Load Balancer or a Network Load Balancer.
     */
    public List<LoadBalancer> loadBalancers() {
        return loadBalancers;
    }

    /**
     * Returns true if the ServiceRegistries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasServiceRegistries() {
        return serviceRegistries != null && !(serviceRegistries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the service discovery registries to assign to this task set. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServiceRegistries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The details of the service discovery registries to assign to this task set. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
     *         Discovery</a>.
     */
    public List<ServiceRegistry> serviceRegistries() {
        return serviceRegistries;
    }

    /**
     * <p>
     * The launch type that new tasks in the task set will use. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch Types</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be omitted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The launch type that new tasks in the task set will use. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch
     *         Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
     *         <p>
     *         If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be
     *         omitted.
     * @see LaunchType
     */
    public LaunchType launchType() {
        return LaunchType.fromValue(launchType);
    }

    /**
     * <p>
     * The launch type that new tasks in the task set will use. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch Types</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be omitted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The launch type that new tasks in the task set will use. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch
     *         Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
     *         <p>
     *         If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be
     *         omitted.
     * @see LaunchType
     */
    public String launchTypeAsString() {
        return launchType;
    }

    /**
     * Returns true if the CapacityProviderStrategy property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCapacityProviderStrategy() {
        return capacityProviderStrategy != null && !(capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capacity provider strategy to use for the task set.
     * </p>
     * <p>
     * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and
     * <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a
     * capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a capacity provider
     * with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
     * </p>
     * <p>
     * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted.
     * If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the
     * <code>defaultCapacityProviderStrategy</code> for the cluster is used.
     * </p>
     * <p>
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created.
     * New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
     * </p>
     * <p>
     * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
     * capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be
     * associated with a cluster to be used.
     * </p>
     * <p>
     * The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity providers
     * for a cluster after the cluster is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCapacityProviderStrategy()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The capacity provider strategy to use for the task set.</p>
     *         <p>
     *         A capacity provider strategy consists of one or more capacity providers along with the <code>base</code>
     *         and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be
     *         used in a capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a
     *         capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or
     *         <code>UPDATING</code> status can be used.
     *         </p>
     *         <p>
     *         If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be
     *         omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the
     *         <code>defaultCapacityProviderStrategy</code> for the cluster is used.
     *         </p>
     *         <p>
     *         If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
     *         created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
     *         </p>
     *         <p>
     *         To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or
     *         <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all
     *         accounts and only need to be associated with a cluster to be used.
     *         </p>
     *         <p>
     *         The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
     *         providers for a cluster after the cluster is created.
     */
    public List<CapacityProviderStrategyItem> capacityProviderStrategy() {
        return capacityProviderStrategy;
    }

    /**
     * <p>
     * The platform version that the tasks in the task set should use. A platform version is specified only for tasks
     * using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform version is used by
     * default.
     * </p>
     * 
     * @return The platform version that the tasks in the task set should use. A platform version is specified only for
     *         tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform version is
     *         used by default.
     */
    public String platformVersion() {
        return platformVersion;
    }

    /**
     * Returns the value of the Scale property for this object.
     * 
     * @return The value of the Scale property for this object.
     */
    public Scale scale() {
        return scale;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 32 ASCII
     * characters are allowed.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 32
     *         ASCII characters are allowed.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a key
     * and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this
     * prefix. Tags with this prefix do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metadata that you apply to the task set to help you categorize and organize them. Each tag consists
     *         of a key and an optional value, both of which you define. When a service is deleted, the tags are deleted
     *         as well.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case-sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
     *         prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or
     *         values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     *         </p>
     *         </li>
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancers());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRegistries());
        hashCode = 31 * hashCode + Objects.hashCode(launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capacityProviderStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(scale());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTaskSetRequest)) {
            return false;
        }
        CreateTaskSetRequest other = (CreateTaskSetRequest) obj;
        return Objects.equals(service(), other.service()) && Objects.equals(cluster(), other.cluster())
                && Objects.equals(externalId(), other.externalId()) && Objects.equals(taskDefinition(), other.taskDefinition())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(loadBalancers(), other.loadBalancers())
                && Objects.equals(serviceRegistries(), other.serviceRegistries())
                && Objects.equals(launchTypeAsString(), other.launchTypeAsString())
                && Objects.equals(capacityProviderStrategy(), other.capacityProviderStrategy())
                && Objects.equals(platformVersion(), other.platformVersion()) && Objects.equals(scale(), other.scale())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateTaskSetRequest").add("Service", service()).add("Cluster", cluster())
                .add("ExternalId", externalId()).add("TaskDefinition", taskDefinition())
                .add("NetworkConfiguration", networkConfiguration()).add("LoadBalancers", loadBalancers())
                .add("ServiceRegistries", serviceRegistries()).add("LaunchType", launchTypeAsString())
                .add("CapacityProviderStrategy", capacityProviderStrategy()).add("PlatformVersion", platformVersion())
                .add("Scale", scale()).add("ClientToken", clientToken()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "taskDefinition":
            return Optional.ofNullable(clazz.cast(taskDefinition()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "loadBalancers":
            return Optional.ofNullable(clazz.cast(loadBalancers()));
        case "serviceRegistries":
            return Optional.ofNullable(clazz.cast(serviceRegistries()));
        case "launchType":
            return Optional.ofNullable(clazz.cast(launchTypeAsString()));
        case "capacityProviderStrategy":
            return Optional.ofNullable(clazz.cast(capacityProviderStrategy()));
        case "platformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "scale":
            return Optional.ofNullable(clazz.cast(scale()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTaskSetRequest, T> g) {
        return obj -> g.apply((CreateTaskSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTaskSetRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
         * </p>
         * 
         * @param service
         *        The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task
         * set in.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the
         *        task set in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * An optional non-unique tag that identifies this task set in external systems. If the task set is associated
         * with a service discovery registry, the tasks in this task set will have the
         * <code>ECS_TASK_SET_EXTERNAL_ID</code> AWS Cloud Map attribute set to the provided value.
         * </p>
         * 
         * @param externalId
         *        An optional non-unique tag that identifies this task set in external systems. If the task set is
         *        associated with a service discovery registry, the tasks in this task set will have the
         *        <code>ECS_TASK_SET_EXTERNAL_ID</code> AWS Cloud Map attribute set to the provided value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The task definition for the tasks in the task set to use.
         * </p>
         * 
         * @param taskDefinition
         *        The task definition for the tasks in the task set to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinition(String taskDefinition);

        /**
         * Sets the value of the NetworkConfiguration property for this object.
         *
         * @param networkConfiguration
         *        The new value for the NetworkConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * Sets the value of the NetworkConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link NetworkConfiguration.Builder} avoiding the need
         * to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * A load balancer object representing the load balancer to use with the task set. The supported load balancer
         * types are either an Application Load Balancer or a Network Load Balancer.
         * </p>
         * 
         * @param loadBalancers
         *        A load balancer object representing the load balancer to use with the task set. The supported load
         *        balancer types are either an Application Load Balancer or a Network Load Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(Collection<LoadBalancer> loadBalancers);

        /**
         * <p>
         * A load balancer object representing the load balancer to use with the task set. The supported load balancer
         * types are either an Application Load Balancer or a Network Load Balancer.
         * </p>
         * 
         * @param loadBalancers
         *        A load balancer object representing the load balancer to use with the task set. The supported load
         *        balancer types are either an Application Load Balancer or a Network Load Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(LoadBalancer... loadBalancers);

        /**
         * <p>
         * A load balancer object representing the load balancer to use with the task set. The supported load balancer
         * types are either an Application Load Balancer or a Network Load Balancer.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoadBalancer>.Builder} avoiding the need to
         * create one manually via {@link List<LoadBalancer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoadBalancer>.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancers(List<LoadBalancer>)}.
         * 
         * @param loadBalancers
         *        a consumer that will call methods on {@link List<LoadBalancer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancers(List<LoadBalancer>)
         */
        Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers);

        /**
         * <p>
         * The details of the service discovery registries to assign to this task set. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * 
         * @param serviceRegistries
         *        The details of the service discovery registries to assign to this task set. For more information, see
         *        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         *        Discovery</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries);

        /**
         * <p>
         * The details of the service discovery registries to assign to this task set. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * 
         * @param serviceRegistries
         *        The details of the service discovery registries to assign to this task set. For more information, see
         *        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         *        Discovery</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegistries(ServiceRegistry... serviceRegistries);

        /**
         * <p>
         * The details of the service discovery registries to assign to this task set. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceRegistry>.Builder} avoiding the need
         * to create one manually via {@link List<ServiceRegistry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceRegistry>.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceRegistries(List<ServiceRegistry>)}.
         * 
         * @param serviceRegistries
         *        a consumer that will call methods on {@link List<ServiceRegistry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceRegistries(List<ServiceRegistry>)
         */
        Builder serviceRegistries(Consumer<ServiceRegistry.Builder>... serviceRegistries);

        /**
         * <p>
         * The launch type that new tasks in the task set will use. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch
         * Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be
         * omitted.
         * </p>
         * 
         * @param launchType
         *        The launch type that new tasks in the task set will use. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch
         *        Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
         *        <p>
         *        If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be
         *        omitted.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(String launchType);

        /**
         * <p>
         * The launch type that new tasks in the task set will use. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch
         * Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be
         * omitted.
         * </p>
         * 
         * @param launchType
         *        The launch type that new tasks in the task set will use. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch
         *        Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
         *        <p>
         *        If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be
         *        omitted.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(LaunchType launchType);

        /**
         * <p>
         * The capacity provider strategy to use for the task set.
         * </p>
         * <p>
         * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and
         * <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in
         * a capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a capacity
         * provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status
         * can be used.
         * </p>
         * <p>
         * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be
         * omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the
         * <code>defaultCapacityProviderStrategy</code> for the cluster is used.
         * </p>
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
         * created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
         * </p>
         * <p>
         * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
         * capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be
         * associated with a cluster to be used.
         * </p>
         * <p>
         * The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
         * providers for a cluster after the cluster is created.
         * </p>
         * 
         * @param capacityProviderStrategy
         *        The capacity provider strategy to use for the task set.</p>
         *        <p>
         *        A capacity provider strategy consists of one or more capacity providers along with the
         *        <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated
         *        with the cluster to be used in a capacity provider strategy. The <a>PutClusterCapacityProviders</a>
         *        API is used to associate a capacity provider with a cluster. Only capacity providers with an
         *        <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
         *        </p>
         *        <p>
         *        If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be
         *        omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the
         *        <code>defaultCapacityProviderStrategy</code> for the cluster is used.
         *        </p>
         *        <p>
         *        If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already
         *        be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API
         *        operation.
         *        </p>
         *        <p>
         *        To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or
         *        <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all
         *        accounts and only need to be associated with a cluster to be used.
         *        </p>
         *        <p>
         *        The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
         *        providers for a cluster after the cluster is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy);

        /**
         * <p>
         * The capacity provider strategy to use for the task set.
         * </p>
         * <p>
         * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and
         * <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in
         * a capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a capacity
         * provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status
         * can be used.
         * </p>
         * <p>
         * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be
         * omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the
         * <code>defaultCapacityProviderStrategy</code> for the cluster is used.
         * </p>
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
         * created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
         * </p>
         * <p>
         * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
         * capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be
         * associated with a cluster to be used.
         * </p>
         * <p>
         * The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
         * providers for a cluster after the cluster is created.
         * </p>
         * 
         * @param capacityProviderStrategy
         *        The capacity provider strategy to use for the task set.</p>
         *        <p>
         *        A capacity provider strategy consists of one or more capacity providers along with the
         *        <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated
         *        with the cluster to be used in a capacity provider strategy. The <a>PutClusterCapacityProviders</a>
         *        API is used to associate a capacity provider with a cluster. Only capacity providers with an
         *        <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
         *        </p>
         *        <p>
         *        If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be
         *        omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the
         *        <code>defaultCapacityProviderStrategy</code> for the cluster is used.
         *        </p>
         *        <p>
         *        If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already
         *        be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API
         *        operation.
         *        </p>
         *        <p>
         *        To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or
         *        <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all
         *        accounts and only need to be associated with a cluster to be used.
         *        </p>
         *        <p>
         *        The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
         *        providers for a cluster after the cluster is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderStrategy(CapacityProviderStrategyItem... capacityProviderStrategy);

        /**
         * <p>
         * The capacity provider strategy to use for the task set.
         * </p>
         * <p>
         * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and
         * <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in
         * a capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a capacity
         * provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status
         * can be used.
         * </p>
         * <p>
         * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be
         * omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the
         * <code>defaultCapacityProviderStrategy</code> for the cluster is used.
         * </p>
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
         * created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
         * </p>
         * <p>
         * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
         * capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be
         * associated with a cluster to be used.
         * </p>
         * <p>
         * The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
         * providers for a cluster after the cluster is created.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CapacityProviderStrategyItem>.Builder}
         * avoiding the need to create one manually via {@link List<CapacityProviderStrategyItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CapacityProviderStrategyItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #capacityProviderStrategy(List<CapacityProviderStrategyItem>)}
         * .
         * 
         * @param capacityProviderStrategy
         *        a consumer that will call methods on {@link List<CapacityProviderStrategyItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityProviderStrategy(List<CapacityProviderStrategyItem>)
         */
        Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder>... capacityProviderStrategy);

        /**
         * <p>
         * The platform version that the tasks in the task set should use. A platform version is specified only for
         * tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform version is used
         * by default.
         * </p>
         * 
         * @param platformVersion
         *        The platform version that the tasks in the task set should use. A platform version is specified only
         *        for tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform
         *        version is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * Sets the value of the Scale property for this object.
         *
         * @param scale
         *        The new value for the Scale property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scale(Scale scale);

        /**
         * Sets the value of the Scale property for this object.
         *
         * This is a convenience that creates an instance of the {@link Scale.Builder} avoiding the need to create one
         * manually via {@link Scale#builder()}.
         *
         * When the {@link Consumer} completes, {@link Scale.Builder#build()} is called immediately and its result is
         * passed to {@link #scale(Scale)}.
         * 
         * @param scale
         *        a consumer that will call methods on {@link Scale.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scale(Scale)
         */
        default Builder scale(Consumer<Scale.Builder> scale) {
            return scale(Scale.builder().applyMutation(scale).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 32 ASCII
         * characters are allowed.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 32
         *        ASCII characters are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a
         * key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with
         * this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the task set to help you categorize and organize them. Each tag
         *        consists of a key and an optional value, both of which you define. When a service is deleted, the tags
         *        are deleted as well.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or
         *        values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a
         * key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with
         * this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the task set to help you categorize and organize them. Each tag
         *        consists of a key and an optional value, both of which you define. When a service is deleted, the tags
         *        are deleted as well.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or
         *        values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a
         * key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with
         * this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String service;

        private String cluster;

        private String externalId;

        private String taskDefinition;

        private NetworkConfiguration networkConfiguration;

        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();

        private List<ServiceRegistry> serviceRegistries = DefaultSdkAutoConstructList.getInstance();

        private String launchType;

        private List<CapacityProviderStrategyItem> capacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();

        private String platformVersion;

        private Scale scale;

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTaskSetRequest model) {
            super(model);
            service(model.service);
            cluster(model.cluster);
            externalId(model.externalId);
            taskDefinition(model.taskDefinition);
            networkConfiguration(model.networkConfiguration);
            loadBalancers(model.loadBalancers);
            serviceRegistries(model.serviceRegistries);
            launchType(model.launchType);
            capacityProviderStrategy(model.capacityProviderStrategy);
            platformVersion(model.platformVersion);
            scale(model.scale);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getService() {
            return service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final String getCluster() {
            return cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getExternalId() {
            return externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final String getTaskDefinition() {
            return taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final Collection<LoadBalancer.Builder> getLoadBalancers() {
            return loadBalancers != null ? loadBalancers.stream().map(LoadBalancer::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer... loadBalancers) {
            loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers) {
            loadBalancers(Stream.of(loadBalancers).map(c -> LoadBalancer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        public final Collection<ServiceRegistry.Builder> getServiceRegistries() {
            return serviceRegistries != null ? serviceRegistries.stream().map(ServiceRegistry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copy(serviceRegistries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(ServiceRegistry... serviceRegistries) {
            serviceRegistries(Arrays.asList(serviceRegistries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(Consumer<ServiceRegistry.Builder>... serviceRegistries) {
            serviceRegistries(Stream.of(serviceRegistries).map(c -> ServiceRegistry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setServiceRegistries(Collection<ServiceRegistry.BuilderImpl> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copyFromBuilder(serviceRegistries);
        }

        public final String getLaunchTypeAsString() {
            return launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        public final Collection<CapacityProviderStrategyItem.Builder> getCapacityProviderStrategy() {
            return capacityProviderStrategy != null ? capacityProviderStrategy.stream()
                    .map(CapacityProviderStrategyItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(CapacityProviderStrategyItem... capacityProviderStrategy) {
            capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder>... capacityProviderStrategy) {
            capacityProviderStrategy(Stream.of(capacityProviderStrategy)
                    .map(c -> CapacityProviderStrategyItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCapacityProviderStrategy(
                Collection<CapacityProviderStrategyItem.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(capacityProviderStrategy);
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final Scale.Builder getScale() {
            return scale != null ? scale.toBuilder() : null;
        }

        @Override
        public final Builder scale(Scale scale) {
            this.scale = scale;
            return this;
        }

        public final void setScale(Scale.BuilderImpl scale) {
            this.scale = scale != null ? scale.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTaskSetRequest build() {
            return new CreateTaskSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
