/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecrpublic.model.RegistryAliasStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegistryAlias
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegistryAlias> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RegistryAlias.getter(RegistryAlias::name)).setter(RegistryAlias.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(RegistryAlias.getter(RegistryAlias::statusAsString)).setter(RegistryAlias.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Boolean> PRIMARY_REGISTRY_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("primaryRegistryAlias").getter(RegistryAlias.getter(RegistryAlias::primaryRegistryAlias)).setter(RegistryAlias.setter(Builder::primaryRegistryAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryRegistryAlias").build()}).build();
    private static final SdkField<Boolean> DEFAULT_REGISTRY_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("defaultRegistryAlias").getter(RegistryAlias.getter(RegistryAlias::defaultRegistryAlias)).setter(RegistryAlias.setter(Builder::defaultRegistryAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultRegistryAlias").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD, PRIMARY_REGISTRY_ALIAS_FIELD, DEFAULT_REGISTRY_ALIAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegistryAlias.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String status;
    private final Boolean primaryRegistryAlias;
    private final Boolean defaultRegistryAlias;

    private RegistryAlias(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.primaryRegistryAlias = builder.primaryRegistryAlias;
        this.defaultRegistryAlias = builder.defaultRegistryAlias;
    }

    public final String name() {
        return this.name;
    }

    public final RegistryAliasStatus status() {
        return RegistryAliasStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Boolean primaryRegistryAlias() {
        return this.primaryRegistryAlias;
    }

    public final Boolean defaultRegistryAlias() {
        return this.defaultRegistryAlias;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryRegistryAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRegistryAlias());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistryAlias)) {
            return false;
        }
        RegistryAlias other = (RegistryAlias)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.primaryRegistryAlias(), other.primaryRegistryAlias()) && Objects.equals(this.defaultRegistryAlias(), other.defaultRegistryAlias());
    }

    public final String toString() {
        return ToString.builder((String)"RegistryAlias").add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("PrimaryRegistryAlias", (Object)this.primaryRegistryAlias()).add("DefaultRegistryAlias", (Object)this.defaultRegistryAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "primaryRegistryAlias": {
                return Optional.ofNullable(clazz.cast(this.primaryRegistryAlias()));
            }
            case "defaultRegistryAlias": {
                return Optional.ofNullable(clazz.cast(this.defaultRegistryAlias()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("primaryRegistryAlias", PRIMARY_REGISTRY_ALIAS_FIELD);
        map.put("defaultRegistryAlias", DEFAULT_REGISTRY_ALIAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegistryAlias, T> g) {
        return obj -> g.apply((RegistryAlias)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String status;
        private Boolean primaryRegistryAlias;
        private Boolean defaultRegistryAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistryAlias model) {
            this.name(model.name);
            this.status(model.status);
            this.primaryRegistryAlias(model.primaryRegistryAlias);
            this.defaultRegistryAlias(model.defaultRegistryAlias);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RegistryAliasStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getPrimaryRegistryAlias() {
            return this.primaryRegistryAlias;
        }

        public final void setPrimaryRegistryAlias(Boolean primaryRegistryAlias) {
            this.primaryRegistryAlias = primaryRegistryAlias;
        }

        @Override
        public final Builder primaryRegistryAlias(Boolean primaryRegistryAlias) {
            this.primaryRegistryAlias = primaryRegistryAlias;
            return this;
        }

        public final Boolean getDefaultRegistryAlias() {
            return this.defaultRegistryAlias;
        }

        public final void setDefaultRegistryAlias(Boolean defaultRegistryAlias) {
            this.defaultRegistryAlias = defaultRegistryAlias;
        }

        @Override
        public final Builder defaultRegistryAlias(Boolean defaultRegistryAlias) {
            this.defaultRegistryAlias = defaultRegistryAlias;
            return this;
        }

        public RegistryAlias build() {
            return new RegistryAlias(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegistryAlias> {
        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(RegistryAliasStatus var1);

        public Builder primaryRegistryAlias(Boolean var1);

        public Builder defaultRegistryAlias(Boolean var1);
    }
}

