/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecrpublic.model.ArchitectureListCopier;
import software.amazon.awssdk.services.ecrpublic.model.OperatingSystemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepositoryCatalogDataInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepositoryCatalogDataInput> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(RepositoryCatalogDataInput.getter(RepositoryCatalogDataInput::description)).setter(RepositoryCatalogDataInput.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> ARCHITECTURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("architectures").getter(RepositoryCatalogDataInput.getter(RepositoryCatalogDataInput::architectures)).setter(RepositoryCatalogDataInput.setter(Builder::architectures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architectures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OPERATING_SYSTEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("operatingSystems").getter(RepositoryCatalogDataInput.getter(RepositoryCatalogDataInput::operatingSystems)).setter(RepositoryCatalogDataInput.setter(Builder::operatingSystems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SdkBytes> LOGO_IMAGE_BLOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("logoImageBlob").getter(RepositoryCatalogDataInput.getter(RepositoryCatalogDataInput::logoImageBlob)).setter(RepositoryCatalogDataInput.setter(Builder::logoImageBlob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logoImageBlob").build()}).build();
    private static final SdkField<String> ABOUT_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aboutText").getter(RepositoryCatalogDataInput.getter(RepositoryCatalogDataInput::aboutText)).setter(RepositoryCatalogDataInput.setter(Builder::aboutText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aboutText").build()}).build();
    private static final SdkField<String> USAGE_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageText").getter(RepositoryCatalogDataInput.getter(RepositoryCatalogDataInput::usageText)).setter(RepositoryCatalogDataInput.setter(Builder::usageText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageText").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, ARCHITECTURES_FIELD, OPERATING_SYSTEMS_FIELD, LOGO_IMAGE_BLOB_FIELD, ABOUT_TEXT_FIELD, USAGE_TEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RepositoryCatalogDataInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final List<String> architectures;
    private final List<String> operatingSystems;
    private final SdkBytes logoImageBlob;
    private final String aboutText;
    private final String usageText;

    private RepositoryCatalogDataInput(BuilderImpl builder) {
        this.description = builder.description;
        this.architectures = builder.architectures;
        this.operatingSystems = builder.operatingSystems;
        this.logoImageBlob = builder.logoImageBlob;
        this.aboutText = builder.aboutText;
        this.usageText = builder.usageText;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasArchitectures() {
        return this.architectures != null && !(this.architectures instanceof SdkAutoConstructList);
    }

    public final List<String> architectures() {
        return this.architectures;
    }

    public final boolean hasOperatingSystems() {
        return this.operatingSystems != null && !(this.operatingSystems instanceof SdkAutoConstructList);
    }

    public final List<String> operatingSystems() {
        return this.operatingSystems;
    }

    public final SdkBytes logoImageBlob() {
        return this.logoImageBlob;
    }

    public final String aboutText() {
        return this.aboutText;
    }

    public final String usageText() {
        return this.usageText;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArchitectures() ? this.architectures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperatingSystems() ? this.operatingSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logoImageBlob());
        hashCode = 31 * hashCode + Objects.hashCode(this.aboutText());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageText());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryCatalogDataInput)) {
            return false;
        }
        RepositoryCatalogDataInput other = (RepositoryCatalogDataInput)obj;
        return Objects.equals(this.description(), other.description()) && this.hasArchitectures() == other.hasArchitectures() && Objects.equals(this.architectures(), other.architectures()) && this.hasOperatingSystems() == other.hasOperatingSystems() && Objects.equals(this.operatingSystems(), other.operatingSystems()) && Objects.equals(this.logoImageBlob(), other.logoImageBlob()) && Objects.equals(this.aboutText(), other.aboutText()) && Objects.equals(this.usageText(), other.usageText());
    }

    public final String toString() {
        return ToString.builder((String)"RepositoryCatalogDataInput").add("Description", (Object)this.description()).add("Architectures", this.hasArchitectures() ? this.architectures() : null).add("OperatingSystems", this.hasOperatingSystems() ? this.operatingSystems() : null).add("LogoImageBlob", (Object)this.logoImageBlob()).add("AboutText", (Object)this.aboutText()).add("UsageText", (Object)this.usageText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "architectures": {
                return Optional.ofNullable(clazz.cast(this.architectures()));
            }
            case "operatingSystems": {
                return Optional.ofNullable(clazz.cast(this.operatingSystems()));
            }
            case "logoImageBlob": {
                return Optional.ofNullable(clazz.cast(this.logoImageBlob()));
            }
            case "aboutText": {
                return Optional.ofNullable(clazz.cast(this.aboutText()));
            }
            case "usageText": {
                return Optional.ofNullable(clazz.cast(this.usageText()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("architectures", ARCHITECTURES_FIELD);
        map.put("operatingSystems", OPERATING_SYSTEMS_FIELD);
        map.put("logoImageBlob", LOGO_IMAGE_BLOB_FIELD);
        map.put("aboutText", ABOUT_TEXT_FIELD);
        map.put("usageText", USAGE_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RepositoryCatalogDataInput, T> g) {
        return obj -> g.apply((RepositoryCatalogDataInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private List<String> architectures = DefaultSdkAutoConstructList.getInstance();
        private List<String> operatingSystems = DefaultSdkAutoConstructList.getInstance();
        private SdkBytes logoImageBlob;
        private String aboutText;
        private String usageText;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryCatalogDataInput model) {
            this.description(model.description);
            this.architectures(model.architectures);
            this.operatingSystems(model.operatingSystems);
            this.logoImageBlob(model.logoImageBlob);
            this.aboutText(model.aboutText);
            this.usageText(model.usageText);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getArchitectures() {
            if (this.architectures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.architectures;
        }

        public final void setArchitectures(Collection<String> architectures) {
            this.architectures = ArchitectureListCopier.copy(architectures);
        }

        @Override
        public final Builder architectures(Collection<String> architectures) {
            this.architectures = ArchitectureListCopier.copy(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectures(String ... architectures) {
            this.architectures(Arrays.asList(architectures));
            return this;
        }

        public final Collection<String> getOperatingSystems() {
            if (this.operatingSystems instanceof SdkAutoConstructList) {
                return null;
            }
            return this.operatingSystems;
        }

        public final void setOperatingSystems(Collection<String> operatingSystems) {
            this.operatingSystems = OperatingSystemListCopier.copy(operatingSystems);
        }

        @Override
        public final Builder operatingSystems(Collection<String> operatingSystems) {
            this.operatingSystems = OperatingSystemListCopier.copy(operatingSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingSystems(String ... operatingSystems) {
            this.operatingSystems(Arrays.asList(operatingSystems));
            return this;
        }

        public final ByteBuffer getLogoImageBlob() {
            return this.logoImageBlob == null ? null : this.logoImageBlob.asByteBuffer();
        }

        public final void setLogoImageBlob(ByteBuffer logoImageBlob) {
            this.logoImageBlob(logoImageBlob == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)logoImageBlob));
        }

        @Override
        public final Builder logoImageBlob(SdkBytes logoImageBlob) {
            this.logoImageBlob = logoImageBlob;
            return this;
        }

        public final String getAboutText() {
            return this.aboutText;
        }

        public final void setAboutText(String aboutText) {
            this.aboutText = aboutText;
        }

        @Override
        public final Builder aboutText(String aboutText) {
            this.aboutText = aboutText;
            return this;
        }

        public final String getUsageText() {
            return this.usageText;
        }

        public final void setUsageText(String usageText) {
            this.usageText = usageText;
        }

        @Override
        public final Builder usageText(String usageText) {
            this.usageText = usageText;
            return this;
        }

        public RepositoryCatalogDataInput build() {
            return new RepositoryCatalogDataInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepositoryCatalogDataInput> {
        public Builder description(String var1);

        public Builder architectures(Collection<String> var1);

        public Builder architectures(String ... var1);

        public Builder operatingSystems(Collection<String> var1);

        public Builder operatingSystems(String ... var1);

        public Builder logoImageBlob(SdkBytes var1);

        public Builder aboutText(String var1);

        public Builder usageText(String var1);
    }
}

