/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecrpublic.model.EcrPublicResponse;
import software.amazon.awssdk.services.ecrpublic.model.Layer;
import software.amazon.awssdk.services.ecrpublic.model.LayerFailure;
import software.amazon.awssdk.services.ecrpublic.model.LayerFailureListCopier;
import software.amazon.awssdk.services.ecrpublic.model.LayerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCheckLayerAvailabilityResponse
extends EcrPublicResponse
implements ToCopyableBuilder<Builder, BatchCheckLayerAvailabilityResponse> {
    private static final SdkField<List<Layer>> LAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("layers").getter(BatchCheckLayerAvailabilityResponse.getter(BatchCheckLayerAvailabilityResponse::layers)).setter(BatchCheckLayerAvailabilityResponse.setter(Builder::layers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Layer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LayerFailure>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failures").getter(BatchCheckLayerAvailabilityResponse.getter(BatchCheckLayerAvailabilityResponse::failures)).setter(BatchCheckLayerAvailabilityResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LayerFailure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYERS_FIELD, FAILURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchCheckLayerAvailabilityResponse.memberNameToFieldInitializer();
    private final List<Layer> layers;
    private final List<LayerFailure> failures;

    private BatchCheckLayerAvailabilityResponse(BuilderImpl builder) {
        super(builder);
        this.layers = builder.layers;
        this.failures = builder.failures;
    }

    public final boolean hasLayers() {
        return this.layers != null && !(this.layers instanceof SdkAutoConstructList);
    }

    public final List<Layer> layers() {
        return this.layers;
    }

    public final boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public final List<LayerFailure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLayers() ? this.layers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailures() ? this.failures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCheckLayerAvailabilityResponse)) {
            return false;
        }
        BatchCheckLayerAvailabilityResponse other = (BatchCheckLayerAvailabilityResponse)((Object)obj);
        return this.hasLayers() == other.hasLayers() && Objects.equals(this.layers(), other.layers()) && this.hasFailures() == other.hasFailures() && Objects.equals(this.failures(), other.failures());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCheckLayerAvailabilityResponse").add("Layers", this.hasLayers() ? this.layers() : null).add("Failures", this.hasFailures() ? this.failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "layers": {
                return Optional.ofNullable(clazz.cast(this.layers()));
            }
            case "failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("layers", LAYERS_FIELD);
        map.put("failures", FAILURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCheckLayerAvailabilityResponse, T> g) {
        return obj -> g.apply((BatchCheckLayerAvailabilityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrPublicResponse.BuilderImpl
    implements Builder {
        private List<Layer> layers = DefaultSdkAutoConstructList.getInstance();
        private List<LayerFailure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCheckLayerAvailabilityResponse model) {
            super(model);
            this.layers(model.layers);
            this.failures(model.failures);
        }

        public final List<Layer.Builder> getLayers() {
            List<Layer.Builder> result = LayerListCopier.copyToBuilder(this.layers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLayers(Collection<Layer.BuilderImpl> layers) {
            this.layers = LayerListCopier.copyFromBuilder(layers);
        }

        @Override
        public final Builder layers(Collection<Layer> layers) {
            this.layers = LayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Layer ... layers) {
            this.layers(Arrays.asList(layers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Consumer<Layer.Builder> ... layers) {
            this.layers(Stream.of(layers).map(c -> (Layer)((Layer.Builder)Layer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LayerFailure.Builder> getFailures() {
            List<LayerFailure.Builder> result = LayerFailureListCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<LayerFailure.BuilderImpl> failures) {
            this.failures = LayerFailureListCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<LayerFailure> failures) {
            this.failures = LayerFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(LayerFailure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<LayerFailure.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (LayerFailure)((LayerFailure.Builder)LayerFailure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchCheckLayerAvailabilityResponse build() {
            return new BatchCheckLayerAvailabilityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcrPublicResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCheckLayerAvailabilityResponse> {
        public Builder layers(Collection<Layer> var1);

        public Builder layers(Layer ... var1);

        public Builder layers(Consumer<Layer.Builder> ... var1);

        public Builder failures(Collection<LayerFailure> var1);

        public Builder failures(LayerFailure ... var1);

        public Builder failures(Consumer<LayerFailure.Builder> ... var1);
    }
}

