/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.endpoints;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class EcrPublicEndpointParams
implements ToCopyableBuilder<Builder, EcrPublicEndpointParams> {
    private final Region region;
    private final Boolean useFIPS;
    private final Boolean useDualStack;

    private EcrPublicEndpointParams(BuilderImpl builder) {
        this.region = builder.region;
        this.useFIPS = builder.useFIPS;
        this.useDualStack = builder.useDualStack;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Region region() {
        return this.region;
    }

    public Boolean useFips() {
        return this.useFIPS;
    }

    public Boolean useDualStack() {
        return this.useDualStack;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    private static class BuilderImpl
    implements Builder {
        private Region region;
        private Boolean useFIPS = false;
        private Boolean useDualStack = false;

        private BuilderImpl() {
        }

        private BuilderImpl(EcrPublicEndpointParams builder) {
            this.region = builder.region;
            this.useFIPS = builder.useFIPS;
            this.useDualStack = builder.useDualStack;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder useDualStack(Boolean useDualStack) {
            this.useDualStack = useDualStack;
            if (this.useDualStack == null) {
                this.useDualStack = false;
            }
            return this;
        }

        @Override
        public EcrPublicEndpointParams build() {
            return new EcrPublicEndpointParams(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EcrPublicEndpointParams> {
        public Builder region(Region var1);

        public Builder useFips(Boolean var1);

        public Builder useDualStack(Boolean var1);

        public EcrPublicEndpointParams build();
    }
}

