/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecrpublic.EcrPublicAsyncClient;
import software.amazon.awssdk.services.ecrpublic.internal.UserAgentUtils;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ecrpublic.model.ImageDetail;

public class DescribeImagesPublisher
implements SdkPublisher<DescribeImagesResponse> {
    private final EcrPublicAsyncClient client;
    private final DescribeImagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeImagesPublisher(EcrPublicAsyncClient client, DescribeImagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeImagesPublisher(EcrPublicAsyncClient client, DescribeImagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeImagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeImagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImageDetail> imageDetails() {
        Function<DescribeImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageDetails() != null) {
                return response.imageDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeImagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeImagesResponseFetcher
    implements AsyncPageFetcher<DescribeImagesResponse> {
        private DescribeImagesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeImagesResponse> nextPage(DescribeImagesResponse previousPage) {
            if (previousPage == null) {
                return DescribeImagesPublisher.this.client.describeImages(DescribeImagesPublisher.this.firstRequest);
            }
            return DescribeImagesPublisher.this.client.describeImages((DescribeImagesRequest)((Object)DescribeImagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

