/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecrpublic.model.EcrPublicResponse;
import software.amazon.awssdk.services.ecrpublic.model.ImageDetail;
import software.amazon.awssdk.services.ecrpublic.model.ImageDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImagesResponse
extends EcrPublicResponse
implements ToCopyableBuilder<Builder, DescribeImagesResponse> {
    private static final SdkField<List<ImageDetail>> IMAGE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageDetails").getter(DescribeImagesResponse.getter(DescribeImagesResponse::imageDetails)).setter(DescribeImagesResponse.setter(Builder::imageDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeImagesResponse.getter(DescribeImagesResponse::nextToken)).setter(DescribeImagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ImageDetail> imageDetails;
    private final String nextToken;

    private DescribeImagesResponse(BuilderImpl builder) {
        super(builder);
        this.imageDetails = builder.imageDetails;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasImageDetails() {
        return this.imageDetails != null && !(this.imageDetails instanceof SdkAutoConstructList);
    }

    public final List<ImageDetail> imageDetails() {
        return this.imageDetails;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageDetails() ? this.imageDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesResponse)) {
            return false;
        }
        DescribeImagesResponse other = (DescribeImagesResponse)((Object)obj);
        return this.hasImageDetails() == other.hasImageDetails() && Objects.equals(this.imageDetails(), other.imageDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImagesResponse").add("ImageDetails", this.hasImageDetails() ? this.imageDetails() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageDetails": {
                return Optional.ofNullable(clazz.cast(this.imageDetails()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImagesResponse, T> g) {
        return obj -> g.apply((DescribeImagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrPublicResponse.BuilderImpl
    implements Builder {
        private List<ImageDetail> imageDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesResponse model) {
            super(model);
            this.imageDetails(model.imageDetails);
            this.nextToken(model.nextToken);
        }

        public final List<ImageDetail.Builder> getImageDetails() {
            List<ImageDetail.Builder> result = ImageDetailListCopier.copyToBuilder(this.imageDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageDetails(Collection<ImageDetail.BuilderImpl> imageDetails) {
            this.imageDetails = ImageDetailListCopier.copyFromBuilder(imageDetails);
        }

        @Override
        @Transient
        public final Builder imageDetails(Collection<ImageDetail> imageDetails) {
            this.imageDetails = ImageDetailListCopier.copy(imageDetails);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder imageDetails(ImageDetail ... imageDetails) {
            this.imageDetails(Arrays.asList(imageDetails));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder imageDetails(Consumer<ImageDetail.Builder> ... imageDetails) {
            this.imageDetails(Stream.of(imageDetails).map(c -> (ImageDetail)((ImageDetail.Builder)ImageDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeImagesResponse build() {
            return new DescribeImagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrPublicResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImagesResponse> {
        public Builder imageDetails(Collection<ImageDetail> var1);

        public Builder imageDetails(ImageDetail ... var1);

        public Builder imageDetails(Consumer<ImageDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

