/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecrpublic.model.EcrPublicResponse;
import software.amazon.awssdk.services.ecrpublic.model.ImageFailure;
import software.amazon.awssdk.services.ecrpublic.model.ImageFailureListCopier;
import software.amazon.awssdk.services.ecrpublic.model.ImageIdentifier;
import software.amazon.awssdk.services.ecrpublic.model.ImageIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteImageResponse
extends EcrPublicResponse
implements ToCopyableBuilder<Builder, BatchDeleteImageResponse> {
    private static final SdkField<List<ImageIdentifier>> IMAGE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageIds").getter(BatchDeleteImageResponse.getter(BatchDeleteImageResponse::imageIds)).setter(BatchDeleteImageResponse.setter(Builder::imageIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ImageFailure>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failures").getter(BatchDeleteImageResponse.getter(BatchDeleteImageResponse::failures)).setter(BatchDeleteImageResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageFailure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_IDS_FIELD, FAILURES_FIELD));
    private final List<ImageIdentifier> imageIds;
    private final List<ImageFailure> failures;

    private BatchDeleteImageResponse(BuilderImpl builder) {
        super(builder);
        this.imageIds = builder.imageIds;
        this.failures = builder.failures;
    }

    public final boolean hasImageIds() {
        return this.imageIds != null && !(this.imageIds instanceof SdkAutoConstructList);
    }

    public final List<ImageIdentifier> imageIds() {
        return this.imageIds;
    }

    public final boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public final List<ImageFailure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageIds() ? this.imageIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailures() ? this.failures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteImageResponse)) {
            return false;
        }
        BatchDeleteImageResponse other = (BatchDeleteImageResponse)((Object)obj);
        return this.hasImageIds() == other.hasImageIds() && Objects.equals(this.imageIds(), other.imageIds()) && this.hasFailures() == other.hasFailures() && Objects.equals(this.failures(), other.failures());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteImageResponse").add("ImageIds", this.hasImageIds() ? this.imageIds() : null).add("Failures", this.hasFailures() ? this.failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageIds": {
                return Optional.ofNullable(clazz.cast(this.imageIds()));
            }
            case "failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteImageResponse, T> g) {
        return obj -> g.apply((BatchDeleteImageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrPublicResponse.BuilderImpl
    implements Builder {
        private List<ImageIdentifier> imageIds = DefaultSdkAutoConstructList.getInstance();
        private List<ImageFailure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteImageResponse model) {
            super(model);
            this.imageIds(model.imageIds);
            this.failures(model.failures);
        }

        public final List<ImageIdentifier.Builder> getImageIds() {
            List<ImageIdentifier.Builder> result = ImageIdentifierListCopier.copyToBuilder(this.imageIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageIds(Collection<ImageIdentifier.BuilderImpl> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copyFromBuilder(imageIds);
        }

        @Override
        public final Builder imageIds(Collection<ImageIdentifier> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(ImageIdentifier ... imageIds) {
            this.imageIds(Arrays.asList(imageIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(Consumer<ImageIdentifier.Builder> ... imageIds) {
            this.imageIds(Stream.of(imageIds).map(c -> (ImageIdentifier)((ImageIdentifier.Builder)ImageIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ImageFailure.Builder> getFailures() {
            List<ImageFailure.Builder> result = ImageFailureListCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<ImageFailure.BuilderImpl> failures) {
            this.failures = ImageFailureListCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<ImageFailure> failures) {
            this.failures = ImageFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(ImageFailure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<ImageFailure.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (ImageFailure)((ImageFailure.Builder)ImageFailure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDeleteImageResponse build() {
            return new BatchDeleteImageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrPublicResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteImageResponse> {
        public Builder imageIds(Collection<ImageIdentifier> var1);

        public Builder imageIds(ImageIdentifier ... var1);

        public Builder imageIds(Consumer<ImageIdentifier.Builder> ... var1);

        public Builder failures(Collection<ImageFailure> var1);

        public Builder failures(ImageFailure ... var1);

        public Builder failures(Consumer<ImageFailure.Builder> ... var1);
    }
}

