/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecrpublic.model.EcrPublicResponse;
import software.amazon.awssdk.services.ecrpublic.model.ImageTagDetail;
import software.amazon.awssdk.services.ecrpublic.model.ImageTagDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImageTagsResponse
extends EcrPublicResponse
implements ToCopyableBuilder<Builder, DescribeImageTagsResponse> {
    private static final SdkField<List<ImageTagDetail>> IMAGE_TAG_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageTagDetails").getter(DescribeImageTagsResponse.getter(DescribeImageTagsResponse::imageTagDetails)).setter(DescribeImageTagsResponse.setter(Builder::imageTagDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTagDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageTagDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeImageTagsResponse.getter(DescribeImageTagsResponse::nextToken)).setter(DescribeImageTagsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_TAG_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ImageTagDetail> imageTagDetails;
    private final String nextToken;

    private DescribeImageTagsResponse(BuilderImpl builder) {
        super(builder);
        this.imageTagDetails = builder.imageTagDetails;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasImageTagDetails() {
        return this.imageTagDetails != null && !(this.imageTagDetails instanceof SdkAutoConstructList);
    }

    public final List<ImageTagDetail> imageTagDetails() {
        return this.imageTagDetails;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageTagDetails() ? this.imageTagDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageTagsResponse)) {
            return false;
        }
        DescribeImageTagsResponse other = (DescribeImageTagsResponse)((Object)obj);
        return this.hasImageTagDetails() == other.hasImageTagDetails() && Objects.equals(this.imageTagDetails(), other.imageTagDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImageTagsResponse").add("ImageTagDetails", this.hasImageTagDetails() ? this.imageTagDetails() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageTagDetails": {
                return Optional.ofNullable(clazz.cast(this.imageTagDetails()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageTagsResponse, T> g) {
        return obj -> g.apply((DescribeImageTagsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrPublicResponse.BuilderImpl
    implements Builder {
        private List<ImageTagDetail> imageTagDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageTagsResponse model) {
            super(model);
            this.imageTagDetails(model.imageTagDetails);
            this.nextToken(model.nextToken);
        }

        public final Collection<ImageTagDetail.Builder> getImageTagDetails() {
            if (this.imageTagDetails instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageTagDetails != null ? (Collection)this.imageTagDetails.stream().map(ImageTagDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imageTagDetails(Collection<ImageTagDetail> imageTagDetails) {
            this.imageTagDetails = ImageTagDetailListCopier.copy(imageTagDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTagDetails(ImageTagDetail ... imageTagDetails) {
            this.imageTagDetails(Arrays.asList(imageTagDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTagDetails(Consumer<ImageTagDetail.Builder> ... imageTagDetails) {
            this.imageTagDetails(Stream.of(imageTagDetails).map(c -> (ImageTagDetail)((ImageTagDetail.Builder)ImageTagDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImageTagDetails(Collection<ImageTagDetail.BuilderImpl> imageTagDetails) {
            this.imageTagDetails = ImageTagDetailListCopier.copyFromBuilder(imageTagDetails);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeImageTagsResponse build() {
            return new DescribeImageTagsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrPublicResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImageTagsResponse> {
        public Builder imageTagDetails(Collection<ImageTagDetail> var1);

        public Builder imageTagDetails(ImageTagDetail ... var1);

        public Builder imageTagDetails(Consumer<ImageTagDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

