/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ImageFailureCode {
    INVALID_IMAGE_DIGEST("InvalidImageDigest"),
    INVALID_IMAGE_TAG("InvalidImageTag"),
    IMAGE_TAG_DOES_NOT_MATCH_DIGEST("ImageTagDoesNotMatchDigest"),
    IMAGE_NOT_FOUND("ImageNotFound"),
    MISSING_DIGEST_AND_TAG("MissingDigestAndTag"),
    IMAGE_REFERENCED_BY_MANIFEST_LIST("ImageReferencedByManifestList"),
    KMS_ERROR("KmsError"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ImageFailureCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageFailureCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ImageFailureCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageFailureCode> knownValues() {
        return Stream.of(ImageFailureCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

