/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImageTagsResponse extends EcrPublicResponse implements
        ToCopyableBuilder<DescribeImageTagsResponse.Builder, DescribeImageTagsResponse> {
    private static final SdkField<List<ImageTagDetail>> IMAGE_TAG_DETAILS_FIELD = SdkField
            .<List<ImageTagDetail>> builder(MarshallingType.LIST)
            .memberName("imageTagDetails")
            .getter(getter(DescribeImageTagsResponse::imageTagDetails))
            .setter(setter(Builder::imageTagDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTagDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageTagDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageTagDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeImageTagsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_TAG_DETAILS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ImageTagDetail> imageTagDetails;

    private final String nextToken;

    private DescribeImageTagsResponse(BuilderImpl builder) {
        super(builder);
        this.imageTagDetails = builder.imageTagDetails;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ImageTagDetails property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasImageTagDetails() {
        return imageTagDetails != null && !(imageTagDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The image tag details for the images in the requested repository.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasImageTagDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The image tag details for the images in the requested repository.
     */
    public final List<ImageTagDetail> imageTagDetails() {
        return imageTagDetails;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeImageTags</code> request. When the results
     * of a <code>DescribeImageTags</code> request exceed <code>maxResults</code>, this value can be used to retrieve
     * the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribeImageTags</code> request. When the
     *         results of a <code>DescribeImageTags</code> request exceed <code>maxResults</code>, this value can be
     *         used to retrieve the next page of results. This value is <code>null</code> when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImageTagDetails() ? imageTagDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageTagsResponse)) {
            return false;
        }
        DescribeImageTagsResponse other = (DescribeImageTagsResponse) obj;
        return hasImageTagDetails() == other.hasImageTagDetails() && Objects.equals(imageTagDetails(), other.imageTagDetails())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImageTagsResponse")
                .add("ImageTagDetails", hasImageTagDetails() ? imageTagDetails() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageTagDetails":
            return Optional.ofNullable(clazz.cast(imageTagDetails()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageTagsResponse, T> g) {
        return obj -> g.apply((DescribeImageTagsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrPublicResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImageTagsResponse> {
        /**
         * <p>
         * The image tag details for the images in the requested repository.
         * </p>
         * 
         * @param imageTagDetails
         *        The image tag details for the images in the requested repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTagDetails(Collection<ImageTagDetail> imageTagDetails);

        /**
         * <p>
         * The image tag details for the images in the requested repository.
         * </p>
         * 
         * @param imageTagDetails
         *        The image tag details for the images in the requested repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTagDetails(ImageTagDetail... imageTagDetails);

        /**
         * <p>
         * The image tag details for the images in the requested repository.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImageTagDetail>.Builder} avoiding the need
         * to create one manually via {@link List<ImageTagDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImageTagDetail>.Builder#build()} is called immediately and
         * its result is passed to {@link #imageTagDetails(List<ImageTagDetail>)}.
         * 
         * @param imageTagDetails
         *        a consumer that will call methods on {@link List<ImageTagDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageTagDetails(List<ImageTagDetail>)
         */
        Builder imageTagDetails(Consumer<ImageTagDetail.Builder>... imageTagDetails);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>DescribeImageTags</code> request. When the
         * results of a <code>DescribeImageTags</code> request exceed <code>maxResults</code>, this value can be used to
         * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>DescribeImageTags</code> request. When
         *        the results of a <code>DescribeImageTags</code> request exceed <code>maxResults</code>, this value can
         *        be used to retrieve the next page of results. This value is <code>null</code> when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EcrPublicResponse.BuilderImpl implements Builder {
        private List<ImageTagDetail> imageTagDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageTagsResponse model) {
            super(model);
            imageTagDetails(model.imageTagDetails);
            nextToken(model.nextToken);
        }

        public final Collection<ImageTagDetail.Builder> getImageTagDetails() {
            if (imageTagDetails instanceof SdkAutoConstructList) {
                return null;
            }
            return imageTagDetails != null ? imageTagDetails.stream().map(ImageTagDetail::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder imageTagDetails(Collection<ImageTagDetail> imageTagDetails) {
            this.imageTagDetails = ImageTagDetailListCopier.copy(imageTagDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTagDetails(ImageTagDetail... imageTagDetails) {
            imageTagDetails(Arrays.asList(imageTagDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTagDetails(Consumer<ImageTagDetail.Builder>... imageTagDetails) {
            imageTagDetails(Stream.of(imageTagDetails).map(c -> ImageTagDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setImageTagDetails(Collection<ImageTagDetail.BuilderImpl> imageTagDetails) {
            this.imageTagDetails = ImageTagDetailListCopier.copyFromBuilder(imageTagDetails);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeImageTagsResponse build() {
            return new DescribeImageTagsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
