/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageIdentifier> {
    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageDigest").getter(ImageIdentifier.getter(ImageIdentifier::imageDigest)).setter(ImageIdentifier.setter(Builder::imageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()}).build();
    private static final SdkField<String> IMAGE_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageTag").getter(ImageIdentifier.getter(ImageIdentifier::imageTag)).setter(ImageIdentifier.setter(Builder::imageTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_DIGEST_FIELD, IMAGE_TAG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String imageDigest;
    private final String imageTag;

    private ImageIdentifier(BuilderImpl builder) {
        this.imageDigest = builder.imageDigest;
        this.imageTag = builder.imageTag;
    }

    public final String imageDigest() {
        return this.imageDigest;
    }

    public final String imageTag() {
        return this.imageTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageIdentifier)) {
            return false;
        }
        ImageIdentifier other = (ImageIdentifier)obj;
        return Objects.equals(this.imageDigest(), other.imageDigest()) && Objects.equals(this.imageTag(), other.imageTag());
    }

    public final String toString() {
        return ToString.builder((String)"ImageIdentifier").add("ImageDigest", (Object)this.imageDigest()).add("ImageTag", (Object)this.imageTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageDigest": {
                return Optional.ofNullable(clazz.cast(this.imageDigest()));
            }
            case "imageTag": {
                return Optional.ofNullable(clazz.cast(this.imageTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageIdentifier, T> g) {
        return obj -> g.apply((ImageIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageDigest;
        private String imageTag;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageIdentifier model) {
            this.imageDigest(model.imageDigest);
            this.imageTag(model.imageTag);
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        public final String getImageTag() {
            return this.imageTag;
        }

        @Override
        public final Builder imageTag(String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        public final void setImageTag(String imageTag) {
            this.imageTag = imageTag;
        }

        public ImageIdentifier build() {
            return new ImageIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageIdentifier> {
        public Builder imageDigest(String var1);

        public Builder imageTag(String var1);
    }
}

