/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecrpublic.model.EcrPublicRequest;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryCatalogDataInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRepositoryRequest
extends EcrPublicRequest
implements ToCopyableBuilder<Builder, CreateRepositoryRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(CreateRepositoryRequest.getter(CreateRepositoryRequest::repositoryName)).setter(CreateRepositoryRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<RepositoryCatalogDataInput> CATALOG_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("catalogData").getter(CreateRepositoryRequest.getter(CreateRepositoryRequest::catalogData)).setter(CreateRepositoryRequest.setter(Builder::catalogData)).constructor(RepositoryCatalogDataInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalogData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, CATALOG_DATA_FIELD));
    private final String repositoryName;
    private final RepositoryCatalogDataInput catalogData;

    private CreateRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.catalogData = builder.catalogData;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final RepositoryCatalogDataInput catalogData() {
        return this.catalogData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRepositoryRequest)) {
            return false;
        }
        CreateRepositoryRequest other = (CreateRepositoryRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.catalogData(), other.catalogData());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRepositoryRequest").add("RepositoryName", (Object)this.repositoryName()).add("CatalogData", (Object)this.catalogData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "catalogData": {
                return Optional.ofNullable(clazz.cast(this.catalogData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRepositoryRequest, T> g) {
        return obj -> g.apply((CreateRepositoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrPublicRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private RepositoryCatalogDataInput catalogData;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRepositoryRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.catalogData(model.catalogData);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final RepositoryCatalogDataInput.Builder getCatalogData() {
            return this.catalogData != null ? this.catalogData.toBuilder() : null;
        }

        @Override
        public final Builder catalogData(RepositoryCatalogDataInput catalogData) {
            this.catalogData = catalogData;
            return this;
        }

        public final void setCatalogData(RepositoryCatalogDataInput.BuilderImpl catalogData) {
            this.catalogData = catalogData != null ? catalogData.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRepositoryRequest build() {
            return new CreateRepositoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrPublicRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRepositoryRequest> {
        public Builder repositoryName(String var1);

        public Builder catalogData(RepositoryCatalogDataInput var1);

        default public Builder catalogData(Consumer<RepositoryCatalogDataInput.Builder> catalogData) {
            return this.catalogData((RepositoryCatalogDataInput)((RepositoryCatalogDataInput.Builder)RepositoryCatalogDataInput.builder().applyMutation(catalogData)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

