/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ArtifactStatusFilter {
    ACTIVE("ACTIVE"),
    ARCHIVED("ARCHIVED"),
    ACTIVATING("ACTIVATING"),
    ANY("ANY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ArtifactStatusFilter> VALUE_MAP;
    private final String value;

    private ArtifactStatusFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ArtifactStatusFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ArtifactStatusFilter> knownValues() {
        EnumSet<ArtifactStatusFilter> knownValues = EnumSet.allOf(ArtifactStatusFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ArtifactStatusFilter.class, ArtifactStatusFilter::toString);
    }
}

