/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LayerAvailability {
    AVAILABLE("AVAILABLE"),
    UNAVAILABLE("UNAVAILABLE"),
    ARCHIVED("ARCHIVED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LayerAvailability> VALUE_MAP;
    private final String value;

    private LayerAvailability(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LayerAvailability fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LayerAvailability> knownValues() {
        EnumSet<LayerAvailability> knownValues = EnumSet.allOf(LayerAvailability.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LayerAvailability.class, LayerAvailability::toString);
    }
}

