/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ImageStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateImageStorageClassResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, UpdateImageStorageClassResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(UpdateImageStorageClassResponse.getter(UpdateImageStorageClassResponse::registryId)).setter(UpdateImageStorageClassResponse.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(UpdateImageStorageClassResponse.getter(UpdateImageStorageClassResponse::repositoryName)).setter(UpdateImageStorageClassResponse.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<ImageIdentifier> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageId").getter(UpdateImageStorageClassResponse.getter(UpdateImageStorageClassResponse::imageId)).setter(UpdateImageStorageClassResponse.setter(Builder::imageId)).constructor(ImageIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()}).build();
    private static final SdkField<String> IMAGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageStatus").getter(UpdateImageStorageClassResponse.getter(UpdateImageStorageClassResponse::imageStatusAsString)).setter(UpdateImageStorageClassResponse.setter(Builder::imageStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, IMAGE_ID_FIELD, IMAGE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateImageStorageClassResponse.memberNameToFieldInitializer();
    private final String registryId;
    private final String repositoryName;
    private final ImageIdentifier imageId;
    private final String imageStatus;

    private UpdateImageStorageClassResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageId = builder.imageId;
        this.imageStatus = builder.imageStatus;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final ImageIdentifier imageId() {
        return this.imageId;
    }

    public final ImageStatus imageStatus() {
        return ImageStatus.fromValue(this.imageStatus);
    }

    public final String imageStatusAsString() {
        return this.imageStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImageStorageClassResponse)) {
            return false;
        }
        UpdateImageStorageClassResponse other = (UpdateImageStorageClassResponse)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.imageStatusAsString(), other.imageStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateImageStorageClassResponse").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("ImageId", (Object)this.imageId()).add("ImageStatus", (Object)this.imageStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "imageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "imageStatus": {
                return Optional.ofNullable(clazz.cast(this.imageStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("imageId", IMAGE_ID_FIELD);
        map.put("imageStatus", IMAGE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateImageStorageClassResponse, T> g) {
        return obj -> g.apply((UpdateImageStorageClassResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private ImageIdentifier imageId;
        private String imageStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImageStorageClassResponse model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.imageId(model.imageId);
            this.imageStatus(model.imageStatus);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final ImageIdentifier.Builder getImageId() {
            return this.imageId != null ? this.imageId.toBuilder() : null;
        }

        public final void setImageId(ImageIdentifier.BuilderImpl imageId) {
            this.imageId = imageId != null ? imageId.build() : null;
        }

        @Override
        public final Builder imageId(ImageIdentifier imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getImageStatus() {
            return this.imageStatus;
        }

        public final void setImageStatus(String imageStatus) {
            this.imageStatus = imageStatus;
        }

        @Override
        public final Builder imageStatus(String imageStatus) {
            this.imageStatus = imageStatus;
            return this;
        }

        @Override
        public final Builder imageStatus(ImageStatus imageStatus) {
            this.imageStatus(imageStatus == null ? null : imageStatus.toString());
            return this;
        }

        @Override
        public UpdateImageStorageClassResponse build() {
            return new UpdateImageStorageClassResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateImageStorageClassResponse> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder imageId(ImageIdentifier var1);

        default public Builder imageId(Consumer<ImageIdentifier.Builder> imageId) {
            return this.imageId((ImageIdentifier)((ImageIdentifier.Builder)ImageIdentifier.builder().applyMutation(imageId)).build());
        }

        public Builder imageStatus(String var1);

        public Builder imageStatus(ImageStatus var1);
    }
}

