/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrRequest;
import software.amazon.awssdk.services.ecr.model.SigningConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSigningConfigurationRequest
extends EcrRequest
implements ToCopyableBuilder<Builder, PutSigningConfigurationRequest> {
    private static final SdkField<SigningConfiguration> SIGNING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("signingConfiguration").getter(PutSigningConfigurationRequest.getter(PutSigningConfigurationRequest::signingConfiguration)).setter(PutSigningConfigurationRequest.setter(Builder::signingConfiguration)).constructor(SigningConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutSigningConfigurationRequest.memberNameToFieldInitializer();
    private final SigningConfiguration signingConfiguration;

    private PutSigningConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.signingConfiguration = builder.signingConfiguration;
    }

    public final SigningConfiguration signingConfiguration() {
        return this.signingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.signingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSigningConfigurationRequest)) {
            return false;
        }
        PutSigningConfigurationRequest other = (PutSigningConfigurationRequest)((Object)obj);
        return Objects.equals(this.signingConfiguration(), other.signingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"PutSigningConfigurationRequest").add("SigningConfiguration", (Object)this.signingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "signingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.signingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SigningConfiguration>> map = new HashMap<String, SdkField<SigningConfiguration>>();
        map.put("signingConfiguration", SIGNING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSigningConfigurationRequest, T> g) {
        return obj -> g.apply((PutSigningConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrRequest.BuilderImpl
    implements Builder {
        private SigningConfiguration signingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSigningConfigurationRequest model) {
            super(model);
            this.signingConfiguration(model.signingConfiguration);
        }

        public final SigningConfiguration.Builder getSigningConfiguration() {
            return this.signingConfiguration != null ? this.signingConfiguration.toBuilder() : null;
        }

        public final void setSigningConfiguration(SigningConfiguration.BuilderImpl signingConfiguration) {
            this.signingConfiguration = signingConfiguration != null ? signingConfiguration.build() : null;
        }

        @Override
        public final Builder signingConfiguration(SigningConfiguration signingConfiguration) {
            this.signingConfiguration = signingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSigningConfigurationRequest build() {
            return new PutSigningConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSigningConfigurationRequest> {
        public Builder signingConfiguration(SigningConfiguration var1);

        default public Builder signingConfiguration(Consumer<SigningConfiguration.Builder> signingConfiguration) {
            return this.signingConfiguration((SigningConfiguration)((SigningConfiguration.Builder)SigningConfiguration.builder().applyMutation(signingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

