/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSigningConfigurationResponse extends EcrResponse implements
        ToCopyableBuilder<PutSigningConfigurationResponse.Builder, PutSigningConfigurationResponse> {
    private static final SdkField<SigningConfiguration> SIGNING_CONFIGURATION_FIELD = SdkField
            .<SigningConfiguration> builder(MarshallingType.SDK_POJO).memberName("signingConfiguration")
            .getter(getter(PutSigningConfigurationResponse::signingConfiguration)).setter(setter(Builder::signingConfiguration))
            .constructor(SigningConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SigningConfiguration signingConfiguration;

    private PutSigningConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.signingConfiguration = builder.signingConfiguration;
    }

    /**
     * <p>
     * The registry's updated signing configuration.
     * </p>
     * 
     * @return The registry's updated signing configuration.
     */
    public final SigningConfiguration signingConfiguration() {
        return signingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(signingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSigningConfigurationResponse)) {
            return false;
        }
        PutSigningConfigurationResponse other = (PutSigningConfigurationResponse) obj;
        return Objects.equals(signingConfiguration(), other.signingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSigningConfigurationResponse").add("SigningConfiguration", signingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signingConfiguration":
            return Optional.ofNullable(clazz.cast(signingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("signingConfiguration", SIGNING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSigningConfigurationResponse, T> g) {
        return obj -> g.apply((PutSigningConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutSigningConfigurationResponse> {
        /**
         * <p>
         * The registry's updated signing configuration.
         * </p>
         * 
         * @param signingConfiguration
         *        The registry's updated signing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingConfiguration(SigningConfiguration signingConfiguration);

        /**
         * <p>
         * The registry's updated signing configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link SigningConfiguration.Builder} avoiding
         * the need to create one manually via {@link SigningConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SigningConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #signingConfiguration(SigningConfiguration)}.
         * 
         * @param signingConfiguration
         *        a consumer that will call methods on {@link SigningConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signingConfiguration(SigningConfiguration)
         */
        default Builder signingConfiguration(Consumer<SigningConfiguration.Builder> signingConfiguration) {
            return signingConfiguration(SigningConfiguration.builder().applyMutation(signingConfiguration).build());
        }
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private SigningConfiguration signingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSigningConfigurationResponse model) {
            super(model);
            signingConfiguration(model.signingConfiguration);
        }

        public final SigningConfiguration.Builder getSigningConfiguration() {
            return signingConfiguration != null ? signingConfiguration.toBuilder() : null;
        }

        public final void setSigningConfiguration(SigningConfiguration.BuilderImpl signingConfiguration) {
            this.signingConfiguration = signingConfiguration != null ? signingConfiguration.build() : null;
        }

        @Override
        public final Builder signingConfiguration(SigningConfiguration signingConfiguration) {
            this.signingConfiguration = signingConfiguration;
            return this;
        }

        @Override
        public PutSigningConfigurationResponse build() {
            return new PutSigningConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
