/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a filter on a <a>ListImageReferrers</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImageReferrersFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListImageReferrersFilter.Builder, ListImageReferrersFilter> {
    private static final SdkField<List<String>> ARTIFACT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("artifactTypes")
            .getter(getter(ListImageReferrersFilter::artifactTypes))
            .setter(setter(Builder::artifactTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARTIFACT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("artifactStatus").getter(getter(ListImageReferrersFilter::artifactStatusAsString))
            .setter(setter(Builder::artifactStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_TYPES_FIELD,
            ARTIFACT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> artifactTypes;

    private final String artifactStatus;

    private ListImageReferrersFilter(BuilderImpl builder) {
        this.artifactTypes = builder.artifactTypes;
        this.artifactStatus = builder.artifactStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the ArtifactTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasArtifactTypes() {
        return artifactTypes != null && !(artifactTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The artifact types with which to filter your <a>ListImageReferrers</a> results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArtifactTypes} method.
     * </p>
     * 
     * @return The artifact types with which to filter your <a>ListImageReferrers</a> results.
     */
    public final List<String> artifactTypes() {
        return artifactTypes;
    }

    /**
     * <p>
     * The artifact status with which to filter your <a>ListImageReferrers</a> results. Valid values are
     * <code>ACTIVE</code>, <code>ARCHIVED</code>, <code>ACTIVATING</code>, or <code>ANY</code>. If not specified, only
     * artifacts with <code>ACTIVE</code> status are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #artifactStatus}
     * will return {@link ArtifactStatusFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #artifactStatusAsString}.
     * </p>
     * 
     * @return The artifact status with which to filter your <a>ListImageReferrers</a> results. Valid values are
     *         <code>ACTIVE</code>, <code>ARCHIVED</code>, <code>ACTIVATING</code>, or <code>ANY</code>. If not
     *         specified, only artifacts with <code>ACTIVE</code> status are returned.
     * @see ArtifactStatusFilter
     */
    public final ArtifactStatusFilter artifactStatus() {
        return ArtifactStatusFilter.fromValue(artifactStatus);
    }

    /**
     * <p>
     * The artifact status with which to filter your <a>ListImageReferrers</a> results. Valid values are
     * <code>ACTIVE</code>, <code>ARCHIVED</code>, <code>ACTIVATING</code>, or <code>ANY</code>. If not specified, only
     * artifacts with <code>ACTIVE</code> status are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #artifactStatus}
     * will return {@link ArtifactStatusFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #artifactStatusAsString}.
     * </p>
     * 
     * @return The artifact status with which to filter your <a>ListImageReferrers</a> results. Valid values are
     *         <code>ACTIVE</code>, <code>ARCHIVED</code>, <code>ACTIVATING</code>, or <code>ANY</code>. If not
     *         specified, only artifacts with <code>ACTIVE</code> status are returned.
     * @see ArtifactStatusFilter
     */
    public final String artifactStatusAsString() {
        return artifactStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasArtifactTypes() ? artifactTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(artifactStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImageReferrersFilter)) {
            return false;
        }
        ListImageReferrersFilter other = (ListImageReferrersFilter) obj;
        return hasArtifactTypes() == other.hasArtifactTypes() && Objects.equals(artifactTypes(), other.artifactTypes())
                && Objects.equals(artifactStatusAsString(), other.artifactStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImageReferrersFilter").add("ArtifactTypes", hasArtifactTypes() ? artifactTypes() : null)
                .add("ArtifactStatus", artifactStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "artifactTypes":
            return Optional.ofNullable(clazz.cast(artifactTypes()));
        case "artifactStatus":
            return Optional.ofNullable(clazz.cast(artifactStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("artifactTypes", ARTIFACT_TYPES_FIELD);
        map.put("artifactStatus", ARTIFACT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListImageReferrersFilter, T> g) {
        return obj -> g.apply((ListImageReferrersFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListImageReferrersFilter> {
        /**
         * <p>
         * The artifact types with which to filter your <a>ListImageReferrers</a> results.
         * </p>
         * 
         * @param artifactTypes
         *        The artifact types with which to filter your <a>ListImageReferrers</a> results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactTypes(Collection<String> artifactTypes);

        /**
         * <p>
         * The artifact types with which to filter your <a>ListImageReferrers</a> results.
         * </p>
         * 
         * @param artifactTypes
         *        The artifact types with which to filter your <a>ListImageReferrers</a> results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactTypes(String... artifactTypes);

        /**
         * <p>
         * The artifact status with which to filter your <a>ListImageReferrers</a> results. Valid values are
         * <code>ACTIVE</code>, <code>ARCHIVED</code>, <code>ACTIVATING</code>, or <code>ANY</code>. If not specified,
         * only artifacts with <code>ACTIVE</code> status are returned.
         * </p>
         * 
         * @param artifactStatus
         *        The artifact status with which to filter your <a>ListImageReferrers</a> results. Valid values are
         *        <code>ACTIVE</code>, <code>ARCHIVED</code>, <code>ACTIVATING</code>, or <code>ANY</code>. If not
         *        specified, only artifacts with <code>ACTIVE</code> status are returned.
         * @see ArtifactStatusFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactStatusFilter
         */
        Builder artifactStatus(String artifactStatus);

        /**
         * <p>
         * The artifact status with which to filter your <a>ListImageReferrers</a> results. Valid values are
         * <code>ACTIVE</code>, <code>ARCHIVED</code>, <code>ACTIVATING</code>, or <code>ANY</code>. If not specified,
         * only artifacts with <code>ACTIVE</code> status are returned.
         * </p>
         * 
         * @param artifactStatus
         *        The artifact status with which to filter your <a>ListImageReferrers</a> results. Valid values are
         *        <code>ACTIVE</code>, <code>ARCHIVED</code>, <code>ACTIVATING</code>, or <code>ANY</code>. If not
         *        specified, only artifacts with <code>ACTIVE</code> status are returned.
         * @see ArtifactStatusFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactStatusFilter
         */
        Builder artifactStatus(ArtifactStatusFilter artifactStatus);
    }

    static final class BuilderImpl implements Builder {
        private List<String> artifactTypes = DefaultSdkAutoConstructList.getInstance();

        private String artifactStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImageReferrersFilter model) {
            artifactTypes(model.artifactTypes);
            artifactStatus(model.artifactStatus);
        }

        public final Collection<String> getArtifactTypes() {
            if (artifactTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return artifactTypes;
        }

        public final void setArtifactTypes(Collection<String> artifactTypes) {
            this.artifactTypes = ArtifactTypeListCopier.copy(artifactTypes);
        }

        @Override
        public final Builder artifactTypes(Collection<String> artifactTypes) {
            this.artifactTypes = ArtifactTypeListCopier.copy(artifactTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifactTypes(String... artifactTypes) {
            artifactTypes(Arrays.asList(artifactTypes));
            return this;
        }

        public final String getArtifactStatus() {
            return artifactStatus;
        }

        public final void setArtifactStatus(String artifactStatus) {
            this.artifactStatus = artifactStatus;
        }

        @Override
        public final Builder artifactStatus(String artifactStatus) {
            this.artifactStatus = artifactStatus;
            return this;
        }

        @Override
        public final Builder artifactStatus(ArtifactStatusFilter artifactStatus) {
            this.artifactStatus(artifactStatus == null ? null : artifactStatus.toString());
            return this;
        }

        @Override
        public ListImageReferrersFilter build() {
            return new ListImageReferrersFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
