/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecr.EcrAsyncClient;
import software.amazon.awssdk.services.ecr.internal.UserAgentUtils;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ListImagesRequest;
import software.amazon.awssdk.services.ecr.model.ListImagesResponse;

public class ListImagesPublisher
implements SdkPublisher<ListImagesResponse> {
    private final EcrAsyncClient client;
    private final ListImagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImagesPublisher(EcrAsyncClient client, ListImagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImagesPublisher(EcrAsyncClient client, ListImagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImageIdentifier> imageIds() {
        return this.flatMapIterable(response -> response.imageIds());
    }

    private class ListImagesResponseFetcher
    implements AsyncPageFetcher<ListImagesResponse> {
        private ListImagesResponseFetcher() {
        }

        public boolean hasNextPage(ListImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImagesResponse> nextPage(ListImagesResponse previousPage) {
            if (previousPage == null) {
                return ListImagesPublisher.this.client.listImages(ListImagesPublisher.this.firstRequest);
            }
            return ListImagesPublisher.this.client.listImages((ListImagesRequest)((Object)ListImagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

