/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutImageTagMutabilityResponse extends EcrResponse implements
        ToCopyableBuilder<PutImageTagMutabilityResponse.Builder, PutImageTagMutabilityResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(PutImageTagMutabilityResponse::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(PutImageTagMutabilityResponse::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> IMAGE_TAG_MUTABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageTagMutability").getter(getter(PutImageTagMutabilityResponse::imageTagMutabilityAsString))
            .setter(setter(Builder::imageTagMutability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTagMutability").build())
            .build();

    private static final SdkField<List<ImageTagMutabilityExclusionFilter>> IMAGE_TAG_MUTABILITY_EXCLUSION_FILTERS_FIELD = SdkField
            .<List<ImageTagMutabilityExclusionFilter>> builder(MarshallingType.LIST)
            .memberName("imageTagMutabilityExclusionFilters")
            .getter(getter(PutImageTagMutabilityResponse::imageTagMutabilityExclusionFilters))
            .setter(setter(Builder::imageTagMutabilityExclusionFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTagMutabilityExclusionFilters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageTagMutabilityExclusionFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageTagMutabilityExclusionFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, IMAGE_TAG_MUTABILITY_FIELD, IMAGE_TAG_MUTABILITY_EXCLUSION_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registryId;

    private final String repositoryName;

    private final String imageTagMutability;

    private final List<ImageTagMutabilityExclusionFilter> imageTagMutabilityExclusionFilters;

    private PutImageTagMutabilityResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageTagMutability = builder.imageTagMutability;
        this.imageTagMutabilityExclusionFilters = builder.imageTagMutabilityExclusionFilters;
    }

    /**
     * <p>
     * The registry ID associated with the request.
     * </p>
     * 
     * @return The registry ID associated with the request.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The repository name associated with the request.
     * </p>
     * 
     * @return The repository name associated with the request.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The image tag mutability setting for the repository.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageTagMutability} will return {@link ImageTagMutability#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #imageTagMutabilityAsString}.
     * </p>
     * 
     * @return The image tag mutability setting for the repository.
     * @see ImageTagMutability
     */
    public final ImageTagMutability imageTagMutability() {
        return ImageTagMutability.fromValue(imageTagMutability);
    }

    /**
     * <p>
     * The image tag mutability setting for the repository.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageTagMutability} will return {@link ImageTagMutability#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #imageTagMutabilityAsString}.
     * </p>
     * 
     * @return The image tag mutability setting for the repository.
     * @see ImageTagMutability
     */
    public final String imageTagMutabilityAsString() {
        return imageTagMutability;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageTagMutabilityExclusionFilters
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasImageTagMutabilityExclusionFilters() {
        return imageTagMutabilityExclusionFilters != null
                && !(imageTagMutabilityExclusionFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of filters that specify which image tags are excluded from the repository's image tag mutability
     * setting.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageTagMutabilityExclusionFilters}
     * method.
     * </p>
     * 
     * @return The list of filters that specify which image tags are excluded from the repository's image tag mutability
     *         setting.
     */
    public final List<ImageTagMutabilityExclusionFilter> imageTagMutabilityExclusionFilters() {
        return imageTagMutabilityExclusionFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(imageTagMutabilityAsString());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasImageTagMutabilityExclusionFilters() ? imageTagMutabilityExclusionFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutImageTagMutabilityResponse)) {
            return false;
        }
        PutImageTagMutabilityResponse other = (PutImageTagMutabilityResponse) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(imageTagMutabilityAsString(), other.imageTagMutabilityAsString())
                && hasImageTagMutabilityExclusionFilters() == other.hasImageTagMutabilityExclusionFilters()
                && Objects.equals(imageTagMutabilityExclusionFilters(), other.imageTagMutabilityExclusionFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("PutImageTagMutabilityResponse")
                .add("RegistryId", registryId())
                .add("RepositoryName", repositoryName())
                .add("ImageTagMutability", imageTagMutabilityAsString())
                .add("ImageTagMutabilityExclusionFilters",
                        hasImageTagMutabilityExclusionFilters() ? imageTagMutabilityExclusionFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "imageTagMutability":
            return Optional.ofNullable(clazz.cast(imageTagMutabilityAsString()));
        case "imageTagMutabilityExclusionFilters":
            return Optional.ofNullable(clazz.cast(imageTagMutabilityExclusionFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("imageTagMutability", IMAGE_TAG_MUTABILITY_FIELD);
        map.put("imageTagMutabilityExclusionFilters", IMAGE_TAG_MUTABILITY_EXCLUSION_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutImageTagMutabilityResponse, T> g) {
        return obj -> g.apply((PutImageTagMutabilityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutImageTagMutabilityResponse> {
        /**
         * <p>
         * The registry ID associated with the request.
         * </p>
         * 
         * @param registryId
         *        The registry ID associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The repository name associated with the request.
         * </p>
         * 
         * @param repositoryName
         *        The repository name associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The image tag mutability setting for the repository.
         * </p>
         * 
         * @param imageTagMutability
         *        The image tag mutability setting for the repository.
         * @see ImageTagMutability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTagMutability
         */
        Builder imageTagMutability(String imageTagMutability);

        /**
         * <p>
         * The image tag mutability setting for the repository.
         * </p>
         * 
         * @param imageTagMutability
         *        The image tag mutability setting for the repository.
         * @see ImageTagMutability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTagMutability
         */
        Builder imageTagMutability(ImageTagMutability imageTagMutability);

        /**
         * <p>
         * The list of filters that specify which image tags are excluded from the repository's image tag mutability
         * setting.
         * </p>
         * 
         * @param imageTagMutabilityExclusionFilters
         *        The list of filters that specify which image tags are excluded from the repository's image tag
         *        mutability setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTagMutabilityExclusionFilters(
                Collection<ImageTagMutabilityExclusionFilter> imageTagMutabilityExclusionFilters);

        /**
         * <p>
         * The list of filters that specify which image tags are excluded from the repository's image tag mutability
         * setting.
         * </p>
         * 
         * @param imageTagMutabilityExclusionFilters
         *        The list of filters that specify which image tags are excluded from the repository's image tag
         *        mutability setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTagMutabilityExclusionFilters(ImageTagMutabilityExclusionFilter... imageTagMutabilityExclusionFilters);

        /**
         * <p>
         * The list of filters that specify which image tags are excluded from the repository's image tag mutability
         * setting.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.ImageTagMutabilityExclusionFilter.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.ecr.model.ImageTagMutabilityExclusionFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecr.model.ImageTagMutabilityExclusionFilter.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #imageTagMutabilityExclusionFilters(List<ImageTagMutabilityExclusionFilter>)}.
         * 
         * @param imageTagMutabilityExclusionFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecr.model.ImageTagMutabilityExclusionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageTagMutabilityExclusionFilters(java.util.Collection<ImageTagMutabilityExclusionFilter>)
         */
        Builder imageTagMutabilityExclusionFilters(
                Consumer<ImageTagMutabilityExclusionFilter.Builder>... imageTagMutabilityExclusionFilters);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private String imageTagMutability;

        private List<ImageTagMutabilityExclusionFilter> imageTagMutabilityExclusionFilters = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutImageTagMutabilityResponse model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            imageTagMutability(model.imageTagMutability);
            imageTagMutabilityExclusionFilters(model.imageTagMutabilityExclusionFilters);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getImageTagMutability() {
            return imageTagMutability;
        }

        public final void setImageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
        }

        @Override
        public final Builder imageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
            return this;
        }

        @Override
        public final Builder imageTagMutability(ImageTagMutability imageTagMutability) {
            this.imageTagMutability(imageTagMutability == null ? null : imageTagMutability.toString());
            return this;
        }

        public final List<ImageTagMutabilityExclusionFilter.Builder> getImageTagMutabilityExclusionFilters() {
            List<ImageTagMutabilityExclusionFilter.Builder> result = ImageTagMutabilityExclusionFiltersCopier
                    .copyToBuilder(this.imageTagMutabilityExclusionFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageTagMutabilityExclusionFilters(
                Collection<ImageTagMutabilityExclusionFilter.BuilderImpl> imageTagMutabilityExclusionFilters) {
            this.imageTagMutabilityExclusionFilters = ImageTagMutabilityExclusionFiltersCopier
                    .copyFromBuilder(imageTagMutabilityExclusionFilters);
        }

        @Override
        public final Builder imageTagMutabilityExclusionFilters(
                Collection<ImageTagMutabilityExclusionFilter> imageTagMutabilityExclusionFilters) {
            this.imageTagMutabilityExclusionFilters = ImageTagMutabilityExclusionFiltersCopier
                    .copy(imageTagMutabilityExclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTagMutabilityExclusionFilters(
                ImageTagMutabilityExclusionFilter... imageTagMutabilityExclusionFilters) {
            imageTagMutabilityExclusionFilters(Arrays.asList(imageTagMutabilityExclusionFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTagMutabilityExclusionFilters(
                Consumer<ImageTagMutabilityExclusionFilter.Builder>... imageTagMutabilityExclusionFilters) {
            imageTagMutabilityExclusionFilters(Stream.of(imageTagMutabilityExclusionFilters)
                    .map(c -> ImageTagMutabilityExclusionFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutImageTagMutabilityResponse build() {
            return new PutImageTagMutabilityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
