/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter that specifies which image tags should be excluded from the repository's image tag mutability setting.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageTagMutabilityExclusionFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageTagMutabilityExclusionFilter.Builder, ImageTagMutabilityExclusionFilter> {
    private static final SdkField<String> FILTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterType").getter(getter(ImageTagMutabilityExclusionFilter::filterTypeAsString))
            .setter(setter(Builder::filterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterType").build()).build();

    private static final SdkField<String> FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("filter")
            .getter(getter(ImageTagMutabilityExclusionFilter::filter)).setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_TYPE_FIELD,
            FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filterType;

    private final String filter;

    private ImageTagMutabilityExclusionFilter(BuilderImpl builder) {
        this.filterType = builder.filterType;
        this.filter = builder.filter;
    }

    /**
     * <p>
     * The type of filter to apply for excluding image tags from mutability settings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link ImageTagMutabilityExclusionFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The type of filter to apply for excluding image tags from mutability settings.
     * @see ImageTagMutabilityExclusionFilterType
     */
    public final ImageTagMutabilityExclusionFilterType filterType() {
        return ImageTagMutabilityExclusionFilterType.fromValue(filterType);
    }

    /**
     * <p>
     * The type of filter to apply for excluding image tags from mutability settings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link ImageTagMutabilityExclusionFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The type of filter to apply for excluding image tags from mutability settings.
     * @see ImageTagMutabilityExclusionFilterType
     */
    public final String filterTypeAsString() {
        return filterType;
    }

    /**
     * <p>
     * The filter value used to match image tags for exclusion from mutability settings.
     * </p>
     * 
     * @return The filter value used to match image tags for exclusion from mutability settings.
     */
    public final String filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageTagMutabilityExclusionFilter)) {
            return false;
        }
        ImageTagMutabilityExclusionFilter other = (ImageTagMutabilityExclusionFilter) obj;
        return Objects.equals(filterTypeAsString(), other.filterTypeAsString()) && Objects.equals(filter(), other.filter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageTagMutabilityExclusionFilter").add("FilterType", filterTypeAsString())
                .add("Filter", filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterType":
            return Optional.ofNullable(clazz.cast(filterTypeAsString()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filterType", FILTER_TYPE_FIELD);
        map.put("filter", FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageTagMutabilityExclusionFilter, T> g) {
        return obj -> g.apply((ImageTagMutabilityExclusionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageTagMutabilityExclusionFilter> {
        /**
         * <p>
         * The type of filter to apply for excluding image tags from mutability settings.
         * </p>
         * 
         * @param filterType
         *        The type of filter to apply for excluding image tags from mutability settings.
         * @see ImageTagMutabilityExclusionFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTagMutabilityExclusionFilterType
         */
        Builder filterType(String filterType);

        /**
         * <p>
         * The type of filter to apply for excluding image tags from mutability settings.
         * </p>
         * 
         * @param filterType
         *        The type of filter to apply for excluding image tags from mutability settings.
         * @see ImageTagMutabilityExclusionFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTagMutabilityExclusionFilterType
         */
        Builder filterType(ImageTagMutabilityExclusionFilterType filterType);

        /**
         * <p>
         * The filter value used to match image tags for exclusion from mutability settings.
         * </p>
         * 
         * @param filter
         *        The filter value used to match image tags for exclusion from mutability settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(String filter);
    }

    static final class BuilderImpl implements Builder {
        private String filterType;

        private String filter;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageTagMutabilityExclusionFilter model) {
            filterType(model.filterType);
            filter(model.filter);
        }

        public final String getFilterType() {
            return filterType;
        }

        public final void setFilterType(String filterType) {
            this.filterType = filterType;
        }

        @Override
        public final Builder filterType(String filterType) {
            this.filterType = filterType;
            return this;
        }

        @Override
        public final Builder filterType(ImageTagMutabilityExclusionFilterType filterType) {
            this.filterType(filterType == null ? null : filterType.toString());
            return this;
        }

        public final String getFilter() {
            return filter;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public ImageTagMutabilityExclusionFilter build() {
            return new ImageTagMutabilityExclusionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
