/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateImageStorageClassResponse extends EcrResponse implements
        ToCopyableBuilder<UpdateImageStorageClassResponse.Builder, UpdateImageStorageClassResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(UpdateImageStorageClassResponse::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(UpdateImageStorageClassResponse::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<ImageIdentifier> IMAGE_ID_FIELD = SdkField.<ImageIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("imageId").getter(getter(UpdateImageStorageClassResponse::imageId)).setter(setter(Builder::imageId))
            .constructor(ImageIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()).build();

    private static final SdkField<String> IMAGE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageStatus").getter(getter(UpdateImageStorageClassResponse::imageStatusAsString))
            .setter(setter(Builder::imageStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, IMAGE_ID_FIELD, IMAGE_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registryId;

    private final String repositoryName;

    private final ImageIdentifier imageId;

    private final String imageStatus;

    private UpdateImageStorageClassResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageId = builder.imageId;
        this.imageStatus = builder.imageStatus;
    }

    /**
     * <p>
     * The registry ID associated with the request.
     * </p>
     * 
     * @return The registry ID associated with the request.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The repository name associated with the request.
     * </p>
     * 
     * @return The repository name associated with the request.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * Returns the value of the ImageId property for this object.
     * 
     * @return The value of the ImageId property for this object.
     */
    public final ImageIdentifier imageId() {
        return imageId;
    }

    /**
     * <p>
     * The current status of the image after the call to UpdateImageStorageClass is complete. Valid values are
     * <code>ACTIVE</code>, <code>ARCHIVED</code>, and <code>ACTIVATING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageStatus} will
     * return {@link ImageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageStatusAsString}.
     * </p>
     * 
     * @return The current status of the image after the call to UpdateImageStorageClass is complete. Valid values are
     *         <code>ACTIVE</code>, <code>ARCHIVED</code>, and <code>ACTIVATING</code>.
     * @see ImageStatus
     */
    public final ImageStatus imageStatus() {
        return ImageStatus.fromValue(imageStatus);
    }

    /**
     * <p>
     * The current status of the image after the call to UpdateImageStorageClass is complete. Valid values are
     * <code>ACTIVE</code>, <code>ARCHIVED</code>, and <code>ACTIVATING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageStatus} will
     * return {@link ImageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageStatusAsString}.
     * </p>
     * 
     * @return The current status of the image after the call to UpdateImageStorageClass is complete. Valid values are
     *         <code>ACTIVE</code>, <code>ARCHIVED</code>, and <code>ACTIVATING</code>.
     * @see ImageStatus
     */
    public final String imageStatusAsString() {
        return imageStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(imageStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImageStorageClassResponse)) {
            return false;
        }
        UpdateImageStorageClassResponse other = (UpdateImageStorageClassResponse) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(imageId(), other.imageId())
                && Objects.equals(imageStatusAsString(), other.imageStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateImageStorageClassResponse").add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("ImageId", imageId()).add("ImageStatus", imageStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "imageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "imageStatus":
            return Optional.ofNullable(clazz.cast(imageStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("imageId", IMAGE_ID_FIELD);
        map.put("imageStatus", IMAGE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateImageStorageClassResponse, T> g) {
        return obj -> g.apply((UpdateImageStorageClassResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateImageStorageClassResponse> {
        /**
         * <p>
         * The registry ID associated with the request.
         * </p>
         * 
         * @param registryId
         *        The registry ID associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The repository name associated with the request.
         * </p>
         * 
         * @param repositoryName
         *        The repository name associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * Sets the value of the ImageId property for this object.
         *
         * @param imageId
         *        The new value for the ImageId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(ImageIdentifier imageId);

        /**
         * Sets the value of the ImageId property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ImageIdentifier.Builder} avoiding the
         * need to create one manually via {@link ImageIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #imageId(ImageIdentifier)}.
         * 
         * @param imageId
         *        a consumer that will call methods on {@link ImageIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageId(ImageIdentifier)
         */
        default Builder imageId(Consumer<ImageIdentifier.Builder> imageId) {
            return imageId(ImageIdentifier.builder().applyMutation(imageId).build());
        }

        /**
         * <p>
         * The current status of the image after the call to UpdateImageStorageClass is complete. Valid values are
         * <code>ACTIVE</code>, <code>ARCHIVED</code>, and <code>ACTIVATING</code>.
         * </p>
         * 
         * @param imageStatus
         *        The current status of the image after the call to UpdateImageStorageClass is complete. Valid values
         *        are <code>ACTIVE</code>, <code>ARCHIVED</code>, and <code>ACTIVATING</code>.
         * @see ImageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageStatus
         */
        Builder imageStatus(String imageStatus);

        /**
         * <p>
         * The current status of the image after the call to UpdateImageStorageClass is complete. Valid values are
         * <code>ACTIVE</code>, <code>ARCHIVED</code>, and <code>ACTIVATING</code>.
         * </p>
         * 
         * @param imageStatus
         *        The current status of the image after the call to UpdateImageStorageClass is complete. Valid values
         *        are <code>ACTIVE</code>, <code>ARCHIVED</code>, and <code>ACTIVATING</code>.
         * @see ImageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageStatus
         */
        Builder imageStatus(ImageStatus imageStatus);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private ImageIdentifier imageId;

        private String imageStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImageStorageClassResponse model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            imageId(model.imageId);
            imageStatus(model.imageStatus);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final ImageIdentifier.Builder getImageId() {
            return imageId != null ? imageId.toBuilder() : null;
        }

        public final void setImageId(ImageIdentifier.BuilderImpl imageId) {
            this.imageId = imageId != null ? imageId.build() : null;
        }

        @Override
        public final Builder imageId(ImageIdentifier imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getImageStatus() {
            return imageStatus;
        }

        public final void setImageStatus(String imageStatus) {
            this.imageStatus = imageStatus;
        }

        @Override
        public final Builder imageStatus(String imageStatus) {
            this.imageStatus = imageStatus;
            return this;
        }

        @Override
        public final Builder imageStatus(ImageStatus imageStatus) {
            this.imageStatus(imageStatus == null ? null : imageStatus.toString());
            return this;
        }

        @Override
        public UpdateImageStorageClassResponse build() {
            return new UpdateImageStorageClassResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
