/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.ImageStatusFilter;
import software.amazon.awssdk.services.ecr.model.TagStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImagesFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribeImagesFilter> {
    private static final SdkField<String> TAG_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tagStatus").getter(DescribeImagesFilter.getter(DescribeImagesFilter::tagStatusAsString)).setter(DescribeImagesFilter.setter(Builder::tagStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagStatus").build()}).build();
    private static final SdkField<String> IMAGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageStatus").getter(DescribeImagesFilter.getter(DescribeImagesFilter::imageStatusAsString)).setter(DescribeImagesFilter.setter(Builder::imageStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_STATUS_FIELD, IMAGE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeImagesFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tagStatus;
    private final String imageStatus;

    private DescribeImagesFilter(BuilderImpl builder) {
        this.tagStatus = builder.tagStatus;
        this.imageStatus = builder.imageStatus;
    }

    public final TagStatus tagStatus() {
        return TagStatus.fromValue(this.tagStatus);
    }

    public final String tagStatusAsString() {
        return this.tagStatus;
    }

    public final ImageStatusFilter imageStatus() {
        return ImageStatusFilter.fromValue(this.imageStatus);
    }

    public final String imageStatusAsString() {
        return this.imageStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tagStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesFilter)) {
            return false;
        }
        DescribeImagesFilter other = (DescribeImagesFilter)obj;
        return Objects.equals(this.tagStatusAsString(), other.tagStatusAsString()) && Objects.equals(this.imageStatusAsString(), other.imageStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImagesFilter").add("TagStatus", (Object)this.tagStatusAsString()).add("ImageStatus", (Object)this.imageStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tagStatus": {
                return Optional.ofNullable(clazz.cast(this.tagStatusAsString()));
            }
            case "imageStatus": {
                return Optional.ofNullable(clazz.cast(this.imageStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("tagStatus", TAG_STATUS_FIELD);
        map.put("imageStatus", IMAGE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImagesFilter, T> g) {
        return obj -> g.apply((DescribeImagesFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tagStatus;
        private String imageStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesFilter model) {
            this.tagStatus(model.tagStatus);
            this.imageStatus(model.imageStatus);
        }

        public final String getTagStatus() {
            return this.tagStatus;
        }

        public final void setTagStatus(String tagStatus) {
            this.tagStatus = tagStatus;
        }

        @Override
        public final Builder tagStatus(String tagStatus) {
            this.tagStatus = tagStatus;
            return this;
        }

        @Override
        public final Builder tagStatus(TagStatus tagStatus) {
            this.tagStatus(tagStatus == null ? null : tagStatus.toString());
            return this;
        }

        public final String getImageStatus() {
            return this.imageStatus;
        }

        public final void setImageStatus(String imageStatus) {
            this.imageStatus = imageStatus;
        }

        @Override
        public final Builder imageStatus(String imageStatus) {
            this.imageStatus = imageStatus;
            return this;
        }

        @Override
        public final Builder imageStatus(ImageStatusFilter imageStatus) {
            this.imageStatus(imageStatus == null ? null : imageStatus.toString());
            return this;
        }

        public DescribeImagesFilter build() {
            return new DescribeImagesFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribeImagesFilter> {
        public Builder tagStatus(String var1);

        public Builder tagStatus(TagStatus var1);

        public Builder imageStatus(String var1);

        public Builder imageStatus(ImageStatusFilter var1);
    }
}

