/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRegistryScanningConfigurationRequest extends EcrRequest implements
        ToCopyableBuilder<PutRegistryScanningConfigurationRequest.Builder, PutRegistryScanningConfigurationRequest> {
    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanType").getter(getter(PutRegistryScanningConfigurationRequest::scanTypeAsString))
            .setter(setter(Builder::scanType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()).build();

    private static final SdkField<List<RegistryScanningRule>> RULES_FIELD = SdkField
            .<List<RegistryScanningRule>> builder(MarshallingType.LIST)
            .memberName("rules")
            .getter(getter(PutRegistryScanningConfigurationRequest::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegistryScanningRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegistryScanningRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_TYPE_FIELD, RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scanType;

    private final List<RegistryScanningRule> rules;

    private PutRegistryScanningConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.scanType = builder.scanType;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * The scanning type to set for the registry.
     * </p>
     * <p>
     * When a registry scanning configuration is not defined, by default the <code>BASIC</code> scan type is used. When
     * basic scanning is used, you may specify filters to determine which individual repositories, or all repositories,
     * are scanned when new images are pushed to those repositories. Alternatively, you can do manual scans of images
     * with basic scanning.
     * </p>
     * <p>
     * When the <code>ENHANCED</code> scan type is set, Amazon Inspector provides automated vulnerability scanning. You
     * may choose between continuous scanning or scan on push and you may specify filters to determine which individual
     * repositories, or all repositories, are scanned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanType} will
     * return {@link ScanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanTypeAsString}.
     * </p>
     * 
     * @return The scanning type to set for the registry.</p>
     *         <p>
     *         When a registry scanning configuration is not defined, by default the <code>BASIC</code> scan type is
     *         used. When basic scanning is used, you may specify filters to determine which individual repositories, or
     *         all repositories, are scanned when new images are pushed to those repositories. Alternatively, you can do
     *         manual scans of images with basic scanning.
     *         </p>
     *         <p>
     *         When the <code>ENHANCED</code> scan type is set, Amazon Inspector provides automated vulnerability
     *         scanning. You may choose between continuous scanning or scan on push and you may specify filters to
     *         determine which individual repositories, or all repositories, are scanned.
     * @see ScanType
     */
    public final ScanType scanType() {
        return ScanType.fromValue(scanType);
    }

    /**
     * <p>
     * The scanning type to set for the registry.
     * </p>
     * <p>
     * When a registry scanning configuration is not defined, by default the <code>BASIC</code> scan type is used. When
     * basic scanning is used, you may specify filters to determine which individual repositories, or all repositories,
     * are scanned when new images are pushed to those repositories. Alternatively, you can do manual scans of images
     * with basic scanning.
     * </p>
     * <p>
     * When the <code>ENHANCED</code> scan type is set, Amazon Inspector provides automated vulnerability scanning. You
     * may choose between continuous scanning or scan on push and you may specify filters to determine which individual
     * repositories, or all repositories, are scanned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanType} will
     * return {@link ScanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanTypeAsString}.
     * </p>
     * 
     * @return The scanning type to set for the registry.</p>
     *         <p>
     *         When a registry scanning configuration is not defined, by default the <code>BASIC</code> scan type is
     *         used. When basic scanning is used, you may specify filters to determine which individual repositories, or
     *         all repositories, are scanned when new images are pushed to those repositories. Alternatively, you can do
     *         manual scans of images with basic scanning.
     *         </p>
     *         <p>
     *         When the <code>ENHANCED</code> scan type is set, Amazon Inspector provides automated vulnerability
     *         scanning. You may choose between continuous scanning or scan on push and you may specify filters to
     *         determine which individual repositories, or all repositories, are scanned.
     * @see ScanType
     */
    public final String scanTypeAsString() {
        return scanType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scanning rules to use for the registry. A scanning rule is used to determine which repository filters are
     * used and at what frequency scanning will occur.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The scanning rules to use for the registry. A scanning rule is used to determine which repository filters
     *         are used and at what frequency scanning will occur.
     */
    public final List<RegistryScanningRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRegistryScanningConfigurationRequest)) {
            return false;
        }
        PutRegistryScanningConfigurationRequest other = (PutRegistryScanningConfigurationRequest) obj;
        return Objects.equals(scanTypeAsString(), other.scanTypeAsString()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRegistryScanningConfigurationRequest").add("ScanType", scanTypeAsString())
                .add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanType":
            return Optional.ofNullable(clazz.cast(scanTypeAsString()));
        case "rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanType", SCAN_TYPE_FIELD);
        map.put("rules", RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRegistryScanningConfigurationRequest, T> g) {
        return obj -> g.apply((PutRegistryScanningConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcrRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutRegistryScanningConfigurationRequest> {
        /**
         * <p>
         * The scanning type to set for the registry.
         * </p>
         * <p>
         * When a registry scanning configuration is not defined, by default the <code>BASIC</code> scan type is used.
         * When basic scanning is used, you may specify filters to determine which individual repositories, or all
         * repositories, are scanned when new images are pushed to those repositories. Alternatively, you can do manual
         * scans of images with basic scanning.
         * </p>
         * <p>
         * When the <code>ENHANCED</code> scan type is set, Amazon Inspector provides automated vulnerability scanning.
         * You may choose between continuous scanning or scan on push and you may specify filters to determine which
         * individual repositories, or all repositories, are scanned.
         * </p>
         * 
         * @param scanType
         *        The scanning type to set for the registry.</p>
         *        <p>
         *        When a registry scanning configuration is not defined, by default the <code>BASIC</code> scan type is
         *        used. When basic scanning is used, you may specify filters to determine which individual repositories,
         *        or all repositories, are scanned when new images are pushed to those repositories. Alternatively, you
         *        can do manual scans of images with basic scanning.
         *        </p>
         *        <p>
         *        When the <code>ENHANCED</code> scan type is set, Amazon Inspector provides automated vulnerability
         *        scanning. You may choose between continuous scanning or scan on push and you may specify filters to
         *        determine which individual repositories, or all repositories, are scanned.
         * @see ScanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanType
         */
        Builder scanType(String scanType);

        /**
         * <p>
         * The scanning type to set for the registry.
         * </p>
         * <p>
         * When a registry scanning configuration is not defined, by default the <code>BASIC</code> scan type is used.
         * When basic scanning is used, you may specify filters to determine which individual repositories, or all
         * repositories, are scanned when new images are pushed to those repositories. Alternatively, you can do manual
         * scans of images with basic scanning.
         * </p>
         * <p>
         * When the <code>ENHANCED</code> scan type is set, Amazon Inspector provides automated vulnerability scanning.
         * You may choose between continuous scanning or scan on push and you may specify filters to determine which
         * individual repositories, or all repositories, are scanned.
         * </p>
         * 
         * @param scanType
         *        The scanning type to set for the registry.</p>
         *        <p>
         *        When a registry scanning configuration is not defined, by default the <code>BASIC</code> scan type is
         *        used. When basic scanning is used, you may specify filters to determine which individual repositories,
         *        or all repositories, are scanned when new images are pushed to those repositories. Alternatively, you
         *        can do manual scans of images with basic scanning.
         *        </p>
         *        <p>
         *        When the <code>ENHANCED</code> scan type is set, Amazon Inspector provides automated vulnerability
         *        scanning. You may choose between continuous scanning or scan on push and you may specify filters to
         *        determine which individual repositories, or all repositories, are scanned.
         * @see ScanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanType
         */
        Builder scanType(ScanType scanType);

        /**
         * <p>
         * The scanning rules to use for the registry. A scanning rule is used to determine which repository filters are
         * used and at what frequency scanning will occur.
         * </p>
         * 
         * @param rules
         *        The scanning rules to use for the registry. A scanning rule is used to determine which repository
         *        filters are used and at what frequency scanning will occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<RegistryScanningRule> rules);

        /**
         * <p>
         * The scanning rules to use for the registry. A scanning rule is used to determine which repository filters are
         * used and at what frequency scanning will occur.
         * </p>
         * 
         * @param rules
         *        The scanning rules to use for the registry. A scanning rule is used to determine which repository
         *        filters are used and at what frequency scanning will occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(RegistryScanningRule... rules);

        /**
         * <p>
         * The scanning rules to use for the registry. A scanning rule is used to determine which repository filters are
         * used and at what frequency scanning will occur.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.RegistryScanningRule.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ecr.model.RegistryScanningRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecr.model.RegistryScanningRule.Builder#build()} is called immediately
         * and its result is passed to {@link #rules(List<RegistryScanningRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecr.model.RegistryScanningRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<RegistryScanningRule>)
         */
        Builder rules(Consumer<RegistryScanningRule.Builder>... rules);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private String scanType;

        private List<RegistryScanningRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRegistryScanningConfigurationRequest model) {
            super(model);
            scanType(model.scanType);
            rules(model.rules);
        }

        public final String getScanType() {
            return scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(ScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public final List<RegistryScanningRule.Builder> getRules() {
            List<RegistryScanningRule.Builder> result = RegistryScanningRuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<RegistryScanningRule.BuilderImpl> rules) {
            this.rules = RegistryScanningRuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<RegistryScanningRule> rules) {
            this.rules = RegistryScanningRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(RegistryScanningRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<RegistryScanningRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> RegistryScanningRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRegistryScanningConfigurationRequest build() {
            return new PutRegistryScanningConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
