/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScanStatus {
    IN_PROGRESS("IN_PROGRESS"),
    COMPLETE("COMPLETE"),
    FAILED("FAILED"),
    UNSUPPORTED_IMAGE("UNSUPPORTED_IMAGE"),
    ACTIVE("ACTIVE"),
    PENDING("PENDING"),
    SCAN_ELIGIBILITY_EXPIRED("SCAN_ELIGIBILITY_EXPIRED"),
    FINDINGS_UNAVAILABLE("FINDINGS_UNAVAILABLE"),
    LIMIT_EXCEEDED("LIMIT_EXCEEDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScanStatus> VALUE_MAP;
    private final String value;

    private ScanStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScanStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScanStatus> knownValues() {
        EnumSet<ScanStatus> knownValues = EnumSet.allOf(ScanStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScanStatus.class, ScanStatus::toString);
    }
}

