/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutImageTagMutabilityRequest extends EcrRequest implements
        ToCopyableBuilder<PutImageTagMutabilityRequest.Builder, PutImageTagMutabilityRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutImageTagMutabilityRequest::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutImageTagMutabilityRequest::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> IMAGE_TAG_MUTABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutImageTagMutabilityRequest::imageTagMutabilityAsString)).setter(setter(Builder::imageTagMutability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTagMutability").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, IMAGE_TAG_MUTABILITY_FIELD));

    private final String registryId;

    private final String repositoryName;

    private final String imageTagMutability;

    private PutImageTagMutabilityRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageTagMutability = builder.imageTagMutability;
    }

    /**
     * <p>
     * The AWS account ID associated with the registry that contains the repository in which to update the image tag
     * mutability settings. If you do not specify a registry, the default registry is assumed.
     * </p>
     * 
     * @return The AWS account ID associated with the registry that contains the repository in which to update the image
     *         tag mutability settings. If you do not specify a registry, the default registry is assumed.
     */
    public String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name of the repository in which to update the image tag mutability settings.
     * </p>
     * 
     * @return The name of the repository in which to update the image tag mutability settings.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The tag mutability setting for the repository. If <code>MUTABLE</code> is specified, image tags can be
     * overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which
     * will prevent them from being overwritten.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageTagMutability} will return {@link ImageTagMutability#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #imageTagMutabilityAsString}.
     * </p>
     * 
     * @return The tag mutability setting for the repository. If <code>MUTABLE</code> is specified, image tags can be
     *         overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be
     *         immutable which will prevent them from being overwritten.
     * @see ImageTagMutability
     */
    public ImageTagMutability imageTagMutability() {
        return ImageTagMutability.fromValue(imageTagMutability);
    }

    /**
     * <p>
     * The tag mutability setting for the repository. If <code>MUTABLE</code> is specified, image tags can be
     * overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which
     * will prevent them from being overwritten.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageTagMutability} will return {@link ImageTagMutability#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #imageTagMutabilityAsString}.
     * </p>
     * 
     * @return The tag mutability setting for the repository. If <code>MUTABLE</code> is specified, image tags can be
     *         overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be
     *         immutable which will prevent them from being overwritten.
     * @see ImageTagMutability
     */
    public String imageTagMutabilityAsString() {
        return imageTagMutability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(imageTagMutabilityAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutImageTagMutabilityRequest)) {
            return false;
        }
        PutImageTagMutabilityRequest other = (PutImageTagMutabilityRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(imageTagMutabilityAsString(), other.imageTagMutabilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutImageTagMutabilityRequest").add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("ImageTagMutability", imageTagMutabilityAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "imageTagMutability":
            return Optional.ofNullable(clazz.cast(imageTagMutabilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutImageTagMutabilityRequest, T> g) {
        return obj -> g.apply((PutImageTagMutabilityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutImageTagMutabilityRequest> {
        /**
         * <p>
         * The AWS account ID associated with the registry that contains the repository in which to update the image tag
         * mutability settings. If you do not specify a registry, the default registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The AWS account ID associated with the registry that contains the repository in which to update the
         *        image tag mutability settings. If you do not specify a registry, the default registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name of the repository in which to update the image tag mutability settings.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository in which to update the image tag mutability settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The tag mutability setting for the repository. If <code>MUTABLE</code> is specified, image tags can be
         * overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable
         * which will prevent them from being overwritten.
         * </p>
         * 
         * @param imageTagMutability
         *        The tag mutability setting for the repository. If <code>MUTABLE</code> is specified, image tags can be
         *        overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be
         *        immutable which will prevent them from being overwritten.
         * @see ImageTagMutability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTagMutability
         */
        Builder imageTagMutability(String imageTagMutability);

        /**
         * <p>
         * The tag mutability setting for the repository. If <code>MUTABLE</code> is specified, image tags can be
         * overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable
         * which will prevent them from being overwritten.
         * </p>
         * 
         * @param imageTagMutability
         *        The tag mutability setting for the repository. If <code>MUTABLE</code> is specified, image tags can be
         *        overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be
         *        immutable which will prevent them from being overwritten.
         * @see ImageTagMutability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTagMutability
         */
        Builder imageTagMutability(ImageTagMutability imageTagMutability);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private String imageTagMutability;

        private BuilderImpl() {
        }

        private BuilderImpl(PutImageTagMutabilityRequest model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            imageTagMutability(model.imageTagMutability);
        }

        public final String getRegistryId() {
            return registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getImageTagMutability() {
            return imageTagMutability;
        }

        @Override
        public final Builder imageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
            return this;
        }

        @Override
        public final Builder imageTagMutability(ImageTagMutability imageTagMutability) {
            this.imageTagMutability(imageTagMutability == null ? null : imageTagMutability.toString());
            return this;
        }

        public final void setImageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutImageTagMutabilityRequest build() {
            return new PutImageTagMutabilityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
